/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceHashtable;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.util.Tracer;

public final class CardServiceRegistry {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardServiceRegistry == null ? (class$opencard$core$service$CardServiceRegistry = CardServiceRegistry.class$("opencard.core.service.CardServiceRegistry")) : class$opencard$core$service$CardServiceRegistry);
    private static Tracer ctracer = new Tracer(class$opencard$core$service$CardServiceRegistry == null ? (class$opencard$core$service$CardServiceRegistry = CardServiceRegistry.class$("opencard.core.service.CardServiceRegistry")) : class$opencard$core$service$CardServiceRegistry);
    private static final CardServiceRegistry registry = new CardServiceRegistry();
    private CardServiceHashtable factories = new CardServiceHashtable();
    static /* synthetic */ Class class$opencard$core$service$CardServiceRegistry;

    private CardServiceRegistry() {
        ctracer.debug("<init>", "instantiating");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("add", "(" + cardServiceFactory + ")");
        if (!this.factories.containsKey(cardServiceFactory)) {
            CardServiceHashtable cardServiceHashtable = this.factories;
            synchronized (cardServiceHashtable) {
                this.factories.put(cardServiceFactory, cardServiceFactory);
            }
        }
    }

    public void addToEnd(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("addToEnd", "(" + cardServiceFactory + ")");
        this.factories.putAtEnd(cardServiceFactory, cardServiceFactory);
    }

    public final Enumeration getCardServiceFactories() {
        return this.factories.elements();
    }

    public static CardServiceRegistry getRegistry() {
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CardServiceFactory cardServiceFactory) {
        this.itracer.debug("remove", "(" + cardServiceFactory + ")");
        if (this.factories.containsKey(cardServiceFactory)) {
            CardServiceHashtable cardServiceHashtable = this.factories;
            synchronized (cardServiceHashtable) {
                this.factories.remove(cardServiceFactory);
            }
            this.itracer.info("remove", "removed " + cardServiceFactory);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n");
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            stringBuffer.append("++ registered factory ").append(cardServiceFactory).append("\n");
        }
        return stringBuffer.toString();
    }

    protected Class getCardServiceClassFor(Class clazz, CardID cardID) {
        this.itracer.debug("getCardServiceClass", "for " + clazz + " and " + cardID);
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            this.itracer.debug("getCardServiceClass", "checking " + cardServiceFactory);
            if (!cardServiceFactory.knows(cardID)) continue;
            Class clazz2 = cardServiceFactory.getCardServiceClassFor(clazz, cardID);
            this.itracer.debug("getCardServiceInstance", "factory " + cardServiceFactory + " produced " + clazz2);
            if (clazz2 == null) continue;
            return clazz2;
        }
        this.itracer.info("getCardServiceClass", "no CardService for " + clazz);
        return null;
    }

    protected CardService getCardServiceInstance(Class clazz, CardID cardID, CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws ClassNotFoundException {
        this.itracer.debug("getCardServiceInstance", "for " + clazz + " from " + smartCard);
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            this.itracer.debug("getCardServiceInstance", "checking " + cardServiceFactory);
            if (!cardServiceFactory.knows(cardID)) continue;
            try {
                CardService cardService = cardServiceFactory.getCardServiceInstance(clazz, cardID, cardServiceScheduler, smartCard, bl);
                this.itracer.debug("getCardServiceInstance", "factory " + cardServiceFactory + " produced " + cardService);
                if (cardService == null) continue;
                return cardService;
            }
            catch (CardServiceException cardServiceException) {
                this.itracer.info("getCardServiceInstance", "factory " + cardServiceFactory + " failed: " + cardServiceException);
            }
        }
        this.itracer.info("getCardServiceInstance", "no CardService for " + clazz + " found");
        throw new ClassNotFoundException("CardService implementing " + clazz.toString());
    }

    public CardServiceFactory getCardServiceFactory(String string) {
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            if (!cardServiceFactory.getName().equals(string)) continue;
            return cardServiceFactory;
        }
        return null;
    }

    public CardServiceFactory find(CardID cardID) {
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            CardServiceFactory cardServiceFactory = (CardServiceFactory)enumeration.nextElement();
            if (!cardServiceFactory.knows(cardID)) continue;
            return cardServiceFactory;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

