/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.DefaultCHVDialog;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalIOControl;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.Tracer;

public final class CardHolderVerificationGUI {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$service$CardHolderVerificationGUI == null ? (class$opencard$core$service$CardHolderVerificationGUI = CardHolderVerificationGUI.class$("opencard.core.service.CardHolderVerificationGUI")) : class$opencard$core$service$CardHolderVerificationGUI);
    private static String BACKGROUND = System.getProperty("OpenCard.UserInteraction.image", "ZueriLab.gif");
    private int chvNumber = -1;
    private CHVDialog chvDialog = new DefaultCHVDialog();
    static /* synthetic */ Class class$opencard$core$service$CardHolderVerificationGUI;

    protected CardHolderVerificationGUI() {
    }

    protected void display(int n) {
        this.chvNumber = n;
    }

    protected void clearDisplay() {
        this.chvNumber = -1;
    }

    protected String keyboardInput(CardTerminalIOControl cardTerminalIOControl, CHVDialog cHVDialog) {
        if (cHVDialog != null) {
            return cHVDialog.getCHV(this.chvNumber);
        }
        return this.chvDialog.getCHV(this.chvNumber);
    }

    protected String promptUser(int n, CardTerminalIOControl cardTerminalIOControl, CHVDialog cHVDialog) {
        this.clearDisplay();
        this.display(n);
        return this.keyboardInput(cardTerminalIOControl, cHVDialog);
    }

    public ResponseAPDU sendVerifiedAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU, CHVControl cHVControl, CHVDialog cHVDialog, int n) throws CardTerminalException, CardServiceInvalidCredentialException {
        if (!cHVControl.passwordEncoding().equals("String encoding")) {
            throw new CardTerminalException("verification type not supported: " + cHVControl.toString());
        }
        String string = this.promptUser(cHVControl.chvNumber(), cHVControl.ioControl(), cHVDialog);
        if (string == null) {
            throw new CardServiceInvalidCredentialException("CHV cancelled");
        }
        byte[] byArray = string.getBytes();
        int n2 = cHVControl.passwordOffset();
        int n3 = cHVControl.ioControl().maxInputChars();
        if (byArray.length < n3) {
            n3 = byArray.length;
        }
        int n4 = 0;
        while (n4 < n3) {
            commandAPDU.setByte(5 + n2 + n4, byArray[n4]);
            ++n4;
        }
        if (!slotChannel.isOpen()) {
            throw new CardTerminalException("SlotChannel closed");
        }
        ResponseAPDU responseAPDU = slotChannel.sendAPDU(commandAPDU, cHVControl.ioControl().timeout());
        return responseAPDU;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

