/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.event;

import opencard.core.OpenCardConstants;
import opencard.core.event.OpenCardEvent;
import opencard.core.util.TraceLevels;

public class TracerEvent
extends OpenCardEvent
implements OpenCardConstants,
TraceLevels {
    public static final int TRACE_EVENT = 1;
    private int level = -1;
    private String levelName = null;
    private Thread thread = null;
    private Throwable frisbee = null;
    private String meth = null;
    private String msg = null;

    private TracerEvent(int n, Object object, String string, Thread thread) {
        super(object, 1);
        this.level = n;
        this.levelName = TraceLevels.levelAsString[n];
        this.meth = string;
        this.thread = thread;
    }

    public TracerEvent(int n, Object object, String string, Thread thread, Throwable throwable) {
        this(n, object, string, thread);
        this.frisbee = throwable;
    }

    public TracerEvent(int n, Object object, String string, Thread thread, String string2) {
        this(n, object, string, thread);
        this.msg = string2;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Throwable getThrowable() {
        return this.frisbee;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getMethodName() {
        return this.meth;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n---level     ").append(this.levelName);
        stringBuffer.append("\n---method    ").append(this.meth);
        stringBuffer.append("\n---thread    ").append(this.thread);
        if (this.frisbee != null) {
            stringBuffer.append("\n---throwable ").append(this.frisbee);
        }
        if (this.msg != null) {
            stringBuffer.append("\n---msg       ").append(this.msg);
        }
        return stringBuffer.toString();
    }
}

