/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ibutton;

import com.sun.opencard.service.common.IButtonException;
import com.sun.opencard.service.common.KeyImportCardService;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.ibutton.IButtonCode;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class IButtonKeyImportCardService
extends KeyImportCardService {
    int apdu_status;
    private Certificate cert;
    private PrivateKey privKey;

    public IButtonKeyImportCardService() {
        this.ocf_codes = new IButtonCode();
    }

    public void setup() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            throw new CardServiceException(openCardException.getMessage());
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }

    public ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        System.out.println(" printing cmd APDU ");
        int n = 0;
        while (n < iSOCommandAPDU.getBytes().length) {
            System.out.print(Integer.toHexString(iSOCommandAPDU.getBytes()[n]));
            ++n;
        }
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        System.out.println(IButtonException.errorString(responseAPDU.sw()));
        if (responseAPDU.sw() != 36864 && responseAPDU.sw() != 28416) {
            throw new CardServiceException(IButtonException.errorString(responseAPDU.sw()));
        }
        if (responseAPDU.sw() != 36864) {
            System.out.println("resp: ");
            System.out.println("resp data length: " + responseAPDU.data().length);
            short s = ServiceUtil.byteArrayToShort(responseAPDU.data(), 0);
            System.out.println("resp: " + s);
            int n2 = 0;
            while (n2 < responseAPDU.data().length) {
                System.out.print(Integer.toHexString(responseAPDU.data()[n2]));
                ++n2;
            }
            if (s != 0) {
                throw new CardServiceException(IButtonException.errorByte(responseAPDU.data()));
            }
        }
        return responseAPDU;
    }
}

