/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.ibutton;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.service.common.CardletAdminCardService;
import com.sun.opencard.service.common.IButtonException;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.ibutton.IButtonCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.terminal.ISOCommandAPDU;

public class IButtonCardletAdminCardService
extends CardletAdminCardService {
    private byte[] pin = null;
    private byte[] appletCode = null;
    private String filename = "";
    private String type = "";
    private byte[] aid = null;
    private boolean verbose = false;
    private boolean unload = false;
    static final byte CLA = -48;
    static final byte INS = -107;
    public static final int PIN_LENGTH_SIZE = 1;
    public static final int PIN_SIZE = 8;
    public static final int AID_LENGTH_SIZE = 1;
    public static final int AID_SIZE = 16;
    public static final int AID_LENGTH_OFFSET = 9;
    public static final int AID_NAME_OFFSET = 10;
    public static final int CLASS_FILE_HDRSZE = 26;
    public static int APDU_PLEN = 116;
    public int bytesSent = 0;
    public int bytesToSend = 0;

    public IButtonCardletAdminCardService() {
        this.ocf_codes = new IButtonCode();
    }

    public void loadApplet(Hashtable hashtable) throws CardServiceException {
        try {
            this.allocateCardChannel();
        }
        catch (Exception exception) {
            throw new CardServiceException(exception.getMessage());
        }
        this.readOptions(hashtable);
        if (this.aid == null) {
            throw new CardServiceException("No AID specified");
        }
        if (this.appletCode == null) {
            throw new CardServiceException("No bytes to load or incompatible bytes  ");
        }
        if (this.verbose) {
            System.out.println("IBttonCACS::options passed are :" + hashtable);
            System.out.println("IBttonCACS:: loading the applet bytes ....");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.appletCode);
            ResponseAPDU responseAPDU = this.loadAppletPrivate(hashtable, byteArrayInputStream, this.pin, this.aid);
        }
        catch (Exception exception) {
            throw new CardServiceException(exception.getMessage());
        }
    }

    private ResponseAPDU loadAppletPrivate(Hashtable hashtable, ByteArrayInputStream byteArrayInputStream, byte[] byArray, byte[] byArray2) throws CardTerminalException, IOException {
        int n;
        byte[] byArray3 = new byte[APDU_PLEN];
        long l = byteArrayInputStream.available();
        if (this.verbose) {
            System.out.println("file length: " + l);
            System.out.println("CLASS_FILE_HDRSZE :26");
        }
        byte[] byArray4 = new byte[26 + (int)l];
        if (byArray != null) {
            byArray4[0] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        } else if (this.verbose) {
            System.out.println("loadAppletPrivate:: No pin specified ..");
        }
        byte[] byArray5 = new byte[]{0, 1};
        boolean bl = true;
        ResponseAPDU responseAPDU = null;
        byte[] byArray6 = new byte[]{-112, 0};
        responseAPDU = new ResponseAPDU(byArray6);
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU(-48, -107, 0, 3, byArray5);
        responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        if (this.verbose) {
            System.err.println("Applet mode Command\n" + iSOCommandAPDU);
        }
        if (responseAPDU.sw() != 36864) {
            System.err.println("Set Applet GC mode  error:" + responseAPDU);
        }
        iSOCommandAPDU = new ISOCommandAPDU(-48, -107, 0, 2, byArray5);
        responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        if (this.verbose) {
            System.err.println("Ephemeral mode Command\n" + iSOCommandAPDU);
        }
        if (responseAPDU.sw() != 36864) {
            System.err.println("Set Ephemeral GC mode  error:" + responseAPDU);
        }
        int n2 = 0;
        while (n2 < 16) {
            if (n2 >= byArray2.length) break;
            byArray4[n2 + 10] = byArray2[n2];
            ++n2;
        }
        byArray4[9] = (byte)n2;
        byteArrayInputStream.read(byArray4, 26, (int)l);
        byteArrayInputStream.close();
        this.bytesToSend = (int)(l + 26L - (long)APDU_PLEN);
        while ((long)this.bytesSent < l + 26L - (long)APDU_PLEN) {
            n = 0;
            while (n < APDU_PLEN && n < byArray4.length) {
                byArray3[n] = byArray4[n + this.bytesSent];
                ++n;
            }
            this.bytesSent += APDU_PLEN;
            if (bl) {
                iSOCommandAPDU = new ISOCommandAPDU(-48, -90, 1, 0, byArray3);
                bl = false;
            } else {
                iSOCommandAPDU = new ISOCommandAPDU(-48, -90, 2, 0, byArray3);
            }
            if (this.verbose) {
                System.err.println("Command\n" + iSOCommandAPDU);
            }
            CardChannel cardChannel = this.getCardChannel();
            responseAPDU = cardChannel.sendCommandAPDU(iSOCommandAPDU);
            if (this.verbose) {
                System.err.println("Response:\n" + responseAPDU);
            }
            if ((long)this.bytesSent >= l + 26L) continue;
            if (this.verbose) {
                System.out.println("return: " + IButtonException.errorString(responseAPDU.sw()));
            }
            if (responseAPDU.sw() == 25345) continue;
            throw new CardTerminalException(HexString.hexifyShort(responseAPDU.sw()) + ": " + IButtonException.errorString(responseAPDU.sw()));
        }
        if ((long)this.bytesSent < l + 26L) {
            byArray3 = new byte[(int)(l + 26L - (long)this.bytesSent)];
            n = 0;
            while ((long)n < l + 26L - (long)this.bytesSent) {
                byArray3[n] = byArray4[n + this.bytesSent];
                ++n;
            }
            iSOCommandAPDU = new ISOCommandAPDU(-48, -90, 2, 0, byArray3);
            if (this.verbose) {
                System.err.println("Command\n" + iSOCommandAPDU);
            }
            responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
            if (this.verbose) {
                System.err.println("Response\n" + responseAPDU);
            }
            if (responseAPDU.sw() == 28416) {
                iSOCommandAPDU = new ISOCommandAPDU(-48, -107, 0, 9, byArray5);
                if (this.verbose) {
                    System.err.println("Command\n" + iSOCommandAPDU);
                }
                responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
                if (this.verbose) {
                    System.err.println("Response\n" + responseAPDU);
                }
                if (responseAPDU.sw() != 36864) {
                    System.err.println("Set Reporting mode error:" + responseAPDU);
                    throw new CardTerminalException(HexString.hexifyShort(responseAPDU.sw()) + ": " + IButtonException.errorString(responseAPDU.sw()));
                }
                iSOCommandAPDU = new ISOCommandAPDU(-48, -107, 1, 15);
                if (this.verbose) {
                    System.err.println("Command\n" + iSOCommandAPDU);
                }
                responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
                if (this.verbose) {
                    System.err.println("Response\n" + responseAPDU);
                }
                if (responseAPDU.sw() != 36864) {
                    System.err.println("Get Last error:" + responseAPDU);
                    throw new CardTerminalException(HexString.hexifyShort(responseAPDU.sw()) + ": " + IButtonException.errorString(responseAPDU.sw()));
                }
                throw new CardTerminalException("6F00 " + responseAPDU.data().toString() + ": " + IButtonException.errorByte(responseAPDU.data()));
            }
            System.out.println("return: " + IButtonException.errorString(responseAPDU.sw()));
            if (responseAPDU.sw() != 36864) {
                throw new CardTerminalException(HexString.hexifyShort(responseAPDU.sw()) + ": " + IButtonException.errorString(responseAPDU.sw()));
            }
        }
        return responseAPDU;
    }

    private void readOptions(Hashtable hashtable) throws CardServiceException {
        this.type = OCFConstants.OCF_IBUTTON_CARD_NAME;
        if (hashtable.containsKey(new String(this.type + ".pin"))) {
            this.pin = (byte[])hashtable.get(new String(this.type + ".pin"));
        }
        if (hashtable.containsKey(new String(this.type + ".binary"))) {
            this.appletCode = (byte[])hashtable.get(new String(this.type + ".binary"));
        }
        if (hashtable.containsKey(new String(this.type + ".aid"))) {
            this.aid = this.parseAID((String)hashtable.get(new String(this.type + ".aid")));
        }
        if (hashtable.containsKey(new String(this.type + ".verbose"))) {
            this.verbose = (Boolean)hashtable.get(new String(this.type + ".verbose"));
        }
        if (hashtable.containsKey(new String(this.type + ".unload"))) {
            this.unload = (Boolean)hashtable.get(new String(this.type + ".unload"));
        }
    }

    private byte[] initPin(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{0};
        }
        return byArray;
    }

    private void validatePin(byte[] byArray) throws CardServiceException {
        try {
            this.setup();
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), (int)this.ocf_codes.CHECK_RSA_PIN_Byte(), 0, 0, byArray2);
            System.out.println("pin: " + new String(byArray2, 0, byArray2.length));
            int n = 0;
            while (n < byArray2.length) {
                System.out.print(Integer.toHexString(byArray2[n]));
                ++n;
            }
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        catch (Exception exception) {
            throw new CardServiceException(exception.getMessage());
        }
    }

    public void setup() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            throw new CardServiceException(openCardException.getMessage());
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }

    public ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        short s;
        System.out.println(" printing cmd APDU ");
        int n = 0;
        while (n < iSOCommandAPDU.getBytes().length) {
            System.out.print(Integer.toHexString(iSOCommandAPDU.getBytes()[n]));
            ++n;
        }
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        System.out.println(IButtonException.errorString(responseAPDU.sw()));
        if (responseAPDU.sw() != 36864 && responseAPDU.sw() != 28416) {
            throw new CardServiceException(IButtonException.errorString(responseAPDU.sw()));
        }
        if (responseAPDU.sw() != 36864 && responseAPDU.data() != null && (s = ServiceUtil.byteArrayToShort(responseAPDU.data(), 0)) != 0) {
            throw new CardServiceException(IButtonException.errorByte(responseAPDU.data()));
        }
        return responseAPDU;
    }

    public void unloadApplet(byte[] byArray, String string) throws CardServiceException {
        if (byArray == null) {
            byArray = this.initPin(byArray);
        }
        byte[] byArray2 = this.parseAID(string);
        byte[] byArray3 = ServiceUtil.arrayJoin(byArray, byArray2);
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU(-48, -107, 3, 2, byArray3);
        try {
            this.allocateCardChannel();
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceException(" Could not unload");
            }
        }
        catch (CardTerminalException cardTerminalException) {
            throw new CardServiceException(cardTerminalException.getMessage());
        }
        catch (OpenCardException openCardException) {
            throw new CardServiceException(openCardException.getMessage());
        }
    }

    public void unloadAllApplets(byte[] byArray) throws CardServiceException {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length + 1];
            byArray2[0] = (byte)byArray.length;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            if (this.verbose) {
                System.out.println("pin length: " + byArray.length);
            }
        } else {
            byArray2 = this.initPin(byArray2);
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU(-48, -107, 0, 0, byArray2);
        try {
            this.allocateCardChannel();
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
            if (responseAPDU.sw() != 36864) {
                throw new CardServiceException(" Could not unload");
            }
        }
        catch (CardTerminalException cardTerminalException) {
            throw new CardServiceException(cardTerminalException.getMessage());
        }
        catch (OpenCardException openCardException) {
            throw new CardServiceException(openCardException.getMessage());
        }
    }

    private byte[] parseAID(String string) throws CardServiceException {
        byte[] byArray = null;
        try {
            byArray = ServiceUtil.parseHexString(string);
        }
        catch (Exception exception) {
            throw new CardServiceException("wrong AID format");
        }
        if (byArray.length < 5 || byArray.length > 16) {
            throw new CardServiceException("invalid AID length");
        }
        return byArray;
    }

    public Vector listApplets() throws CardServiceException {
        throw new CardServiceException("service not supported");
    }
}

