/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.common;

import opencard.core.OpenCardException;

public class OCFCardException
extends OpenCardException {
    public int status;

    public OCFCardException(int n, String string) {
        super(Integer.toHexString(n) + " " + string);
        this.status = n;
    }

    public static void checkStatus(int n) throws OCFCardException {
        String string = OCFCardException.errorString(n);
        if (string != null) {
            throw new OCFCardException(n, string);
        }
    }

    public static String errorString(int n) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        switch (n2) {
            case 144: {
                return null;
            }
            case 145: {
                switch (n3) {
                    case 1: {
                        return "Invalidate User Pin";
                    }
                    case 2: {
                        return "Invalidate Issuer Pin";
                    }
                    case 3: {
                        return "Bad INS sequence";
                    }
                    case 4: {
                        return "Card is blocked. Validate your Pin";
                    }
                    case 5: {
                        return "User Password is not set";
                    }
                    case 8: {
                        return "User Info does not exist";
                    }
                    case 9: {
                        return "Wrong alias";
                    }
                    case 16: {
                        return "Private key not set yet";
                    }
                }
            }
            case 97: {
                return "unexpected data bytes available " + n3;
            }
            case 98: {
                switch (n3) {
                    case 0: {
                        return "non-volatile memory unchanged";
                    }
                    case 129: {
                        return "returned data may be corrupt";
                    }
                    case 130: {
                        return "end of file/record reached";
                    }
                    case 131: {
                        return "selected file invalidated";
                    }
                    case 132: {
                        return "FCI not formatted correctly";
                    }
                }
                break;
            }
            case 99: {
                if (n3 == 0) {
                    return "non-volatile memory changed";
                }
                if (n3 == 129) {
                    return "file filled up by last write";
                }
                if ((n3 & 0xF0) != 192) break;
                return "counter " + (n3 & 0xF);
            }
            case 100: {
                return "non-volatile memory unchanged";
            }
            case 101: {
                switch (n3) {
                    case 0: {
                        return "non-volatile memory changed";
                    }
                    case 177: {
                        return "memory failure";
                    }
                }
                break;
            }
            case 102: {
                break;
            }
            case 103: {
                return "wrong length";
            }
            case 104: {
                switch (n3) {
                    case 0: {
                        return "unsupported CLA";
                    }
                    case 129: {
                        return "logical channel not supported";
                    }
                    case 130: {
                        return "secure messaging not supported";
                    }
                }
                break;
            }
            case 105: {
                switch (n3) {
                    case 0: {
                        return "command not allowed";
                    }
                    case 129: {
                        return "command incompatible with file system";
                    }
                    case 130: {
                        return "security status not satisfied";
                    }
                    case 131: {
                        return "authentication method blocked";
                    }
                    case 132: {
                        return "referenced data invalid";
                    }
                    case 133: {
                        return "conditions of use not satisfied";
                    }
                    case 134: {
                        return "command not allowed - no current EF";
                    }
                    case 135: {
                        return "SM data objects missing";
                    }
                    case 136: {
                        return "SM data objects incorrect";
                    }
                }
                break;
            }
            case 106: {
                switch (n3) {
                    case 0: {
                        return "wrong parameters P1-P2";
                    }
                    case 128: {
                        return "incorrect parameters in data field";
                    }
                    case 129: {
                        return "function not supported";
                    }
                    case 130: {
                        return "file not found";
                    }
                    case 131: {
                        return "record not found";
                    }
                    case 132: {
                        return "not enough memory for file";
                    }
                    case 133: {
                        return "LC inconsistent with TLV";
                    }
                    case 134: {
                        return "incorrect parameters P1-P2";
                    }
                    case 135: {
                        return "LC inconsistent with P1-P2";
                    }
                    case 136: {
                        return "referenced data not found";
                    }
                }
                break;
            }
            case 107: {
                return "wrong parameters P1-P2";
            }
            case 108: {
                return "length expected " + n3;
            }
            case 109: {
                return "unsupported INS " + n3;
            }
            case 110: {
                return "unsupported CLA " + n3;
            }
            case 111: {
                return "no diagnostic available. Possible Wrong Pin ";
            }
        }
        return "unknown error";
    }
}

