/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.server;

import com.sun.opencard.common.OCFConstants;
import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.OCFReturnValues;
import com.sun.opencard.opt.security.CertificateAlias;
import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.server.OCFCardHandle;
import com.sun.opencard.server.OCFClientHandle;
import com.sun.opencard.server.OCFServer;
import com.sun.opencard.service.common.INT_CardService;
import com.sun.opencard.service.ocf.OCFService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;

public class OCFDispatcher {
    public String dispatchCardService(String string, String string2, long l, LinkedList linkedList) throws IllegalAccessException, InvocationTargetException {
        OCFClientHandle oCFClientHandle = OCFServer.getClientHandle(Long.parseLong((String)linkedList.removeFirst()));
        if (oCFClientHandle == null) {
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_INVALID_CLIENT, null);
            return oCFReturnValues.getReturnValues();
        }
        OCFCardHandle oCFCardHandle = OCFServer.getCardHandle(Long.parseLong((String)linkedList.removeFirst()));
        if (oCFCardHandle == null) {
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_INVALID_CARD, null);
            return oCFReturnValues.getReturnValues();
        }
        if (!oCFCardHandle.isAccessGranted(oCFClientHandle)) {
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_CARD_LOCKED, null);
            return oCFReturnValues.getReturnValues();
        }
        if (!oCFCardHandle.isAuthorizedUID(l)) {
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_UNAUTHORIZED_ACCESS, null);
            return oCFReturnValues.getReturnValues();
        }
        INT_CardService iNT_CardService = oCFCardHandle.getCardService(string);
        if (iNT_CardService == null) {
            OCFDebug.debugln("OCFDispatcher: cardService is NULL");
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_SERVICE_NOT_SUPPORTED, null);
            return oCFReturnValues.getReturnValues();
        }
        iNT_CardService.setUID(l);
        return this.invokeMethod(iNT_CardService, string2, linkedList, l);
    }

    public String dispatchOCFService(String string, String string2, long l, LinkedList linkedList) throws IllegalAccessException, InvocationTargetException {
        OCFService oCFService = new OCFService(l);
        return this.invokeMethod(oCFService, string2, linkedList, l);
    }

    private Method getMethod(Object object, String string) {
        Method[] methodArray = object.getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string)) {
                return methodArray[n];
            }
            ++n;
        }
        return null;
    }

    protected String invokeMethod(Object object, String string, LinkedList linkedList, long l) throws IllegalAccessException, InvocationTargetException {
        String string2;
        Method method = this.getMethod(object, string);
        Class[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        try {
            string2 = this.createArgs(classArray, linkedList, objectArray, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            OCFReturnValues oCFReturnValues = new OCFReturnValues(OCFConstants.OCF_PARAMETER_ERROR, null);
            return oCFReturnValues.getReturnValues();
        }
        if (string2 != null) {
            OCFReturnValues oCFReturnValues = new OCFReturnValues(string2, null);
            return oCFReturnValues.getReturnValues();
        }
        return (String)method.invoke(object, objectArray);
    }

    private String createArgs(Class[] classArray, LinkedList linkedList, Object[] objectArray, long l) throws ClassNotFoundException, IOException {
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (n < classArray.length) {
            Object object;
            Class clazz = classArray[n];
            String string = (String)iterator.next();
            if (clazz.getName().equals("java.lang.Integer") || clazz.getName().equals("int")) {
                objectArray[n] = Integer.valueOf(string);
            } else if (clazz.getName().equals("java.lang.Long") || clazz.getName().equals("long")) {
                objectArray[n] = Long.valueOf(string);
            } else if (clazz.getName().equals("java.lang.Float") || clazz.getName().equals("float")) {
                objectArray[n] = Float.valueOf(string);
            } else if (clazz.getName().equals("java.lang.String")) {
                objectArray[n] = string.equals("null") ? null : string;
            } else if (clazz.getName().equals("java.lang.Boolean") || clazz.getName().equals("boolean")) {
                objectArray[n] = Boolean.valueOf(string);
            } else if (clazz.getName().equals("com.sun.opencard.server.OCFClientHandle")) {
                object = OCFServer.getClientHandle(Long.parseLong(string));
                if (object == null || l != 0L && l != ((OCFClientHandle)object).getUID()) {
                    return OCFConstants.OCF_INVALID_CLIENT;
                }
                objectArray[n] = object;
            } else if (clazz.getName().equals("com.sun.opencard.server.OCFCardHandle")) {
                objectArray[n] = OCFServer.getCardHandle(Long.parseLong(string));
                if (objectArray[n] == null) {
                    return OCFConstants.OCF_INVALID_CARD;
                }
            } else if (clazz.getName().equals("[B")) {
                objectArray[n] = string.getBytes("ISO-8859-1");
            } else if (clazz.getName().equals("com.sun.opencard.opt.security.PrivateKeyAlias")) {
                objectArray[n] = new PrivateKeyAlias(string);
            } else if (clazz.getName().equals("com.sun.opencard.opt.security.CertificateAlias")) {
                objectArray[n] = new CertificateAlias(string);
            } else if (clazz.getName().equals("java.util.Hashtable")) {
                object = new ByteArrayInputStream(string.getBytes("ISO-8859-1"));
                ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
                objectArray[n] = objectInputStream.readObject();
            }
            ++n;
        }
        return null;
    }
}

