/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.http;

import com.sun.opencard.http.Connection;
import com.sun.opencard.http.Handler;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

public class Server
extends Thread {
    public ServerSocket listen;
    private Class handlerClass;
    Handler handler;
    public Properties props;
    public String hostName = null;
    public String protocol = "http";
    public InetAddress[] restrict = null;
    public String name = "NAWS/1.0";
    String defaultPrefix = "";
    public int timeout = 30000;
    public int maxRequests = 25;
    public int bufsize = 16384;
    public int acceptCount = 0;
    public int requestCount = 0;
    public int errorCount = 0;
    public int logLevel = 3;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_LOG = 3;
    public static final int LOG_INFORMATIONAL = 4;
    public static final int LOG_DIAGNOSTIC = 5;
    static /* synthetic */ Class class$com$sun$opencard$http$Handler;

    public Server(ServerSocket serverSocket, String string, Properties properties) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(string);
        if (!(class$com$sun$opencard$http$Handler == null ? (class$com$sun$opencard$http$Handler = Server.class$("com.sun.opencard.http.Handler")) : class$com$sun$opencard$http$Handler).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("handler must implement " + (class$com$sun$opencard$http$Handler == null ? (class$com$sun$opencard$http$Handler = Server.class$("com.sun.opencard.http.Handler")) : class$com$sun$opencard$http$Handler).toString());
        }
        this.listen = serverSocket;
        this.handlerClass = clazz;
        this.props = properties;
    }

    public void run() {
        try {
            if (this.hostName == null) {
                this.hostName = InetAddress.getLocalHost().getHostAddress();
            }
            this.handler = (Handler)this.handlerClass.newInstance();
            if (!this.handler.init(this, this.defaultPrefix)) {
                return;
            }
            this.listen.setSoTimeout(0);
            while (true) {
                Socket socket = this.listen.accept();
                String string = socket.getInetAddress().getHostAddress();
                ++this.acceptCount;
                Connection connection = new Connection(this, socket);
                connection.start();
            }
        }
        catch (Exception exception) {
            this.log(null, 1, exception.toString());
            exception.printStackTrace();
            return;
        }
    }

    public String serverUrl() {
        return this.protocol + "://" + this.hostName + Server.getUrlPortString(this.listen.getLocalPort());
    }

    public static String getUrlPortString(int n) {
        if (n != 80) {
            return ":" + Integer.toString(n);
        }
        return "";
    }

    public void log(Socket socket, int n, String string) {
        if (n <= this.logLevel) {
            if (socket != null) {
                System.out.print("sock" + socket.getPort() + ": ");
            }
            System.out.println(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

