/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.utils.OCFUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class OCFDebug {
    private static String OCFDEBUG = "ocf.server.debugging";
    private static String OCFDEBUG_FILE = OCFDEBUG + ".filename";
    private static boolean _isOn = false;
    private static boolean _initialised = false;
    private static PrintStream _os = null;
    private static DebugPropertyChangeListener propertyChangeListener = new DebugPropertyChangeListener();

    protected static PrintStream openStream() {
        String string = null;
        try {
            string = OCFUtils.getProperty(OCFDEBUG_FILE, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.exists() && !file.canWrite()) {
            System.out.println("Cannot access debug log file: '" + string + "'");
            return null;
        }
        try {
            return new PrintStream(new FileOutputStream(string, true));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("OCFDebug.openStream '" + string + "' not found");
            return null;
        }
    }

    private static void reinitialize() {
        if (_os != null) {
            if (_os != System.out) {
                _os.close();
            }
            _os = null;
        }
        _isOn = false;
        _initialised = false;
        OCFDebug.init();
    }

    protected static void init() {
        try {
            _isOn = !OCFUtils.getProperty(OCFDEBUG, "0").equals("0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_isOn && (_os = OCFDebug.openStream()) == null) {
            _os = System.out;
        }
        _initialised = true;
    }

    public static void debugln(String string) {
        if (!_initialised) {
            OCFDebug.init();
        }
        if (_isOn) {
            _os.println(string);
        }
    }

    public static void printStackTrace(Throwable throwable) {
        if (!_initialised) {
            OCFDebug.init();
        }
        if (_isOn) {
            throwable.printStackTrace(_os);
        }
    }

    static {
        OCFUtils.addPropertyChangeListener(propertyChangeListener);
    }

    private static class DebugPropertyChangeListener
    implements PropertyChangeListener {
        private DebugPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.startsWith(OCFDEBUG)) {
                System.out.println("DebugPropertyChangeListener : <propertyChange>" + string + " changed");
                OCFDebug.reinitialize();
            }
        }
    }
}

