/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.common;

import com.sun.opencard.common.OCFDebug;
import com.sun.opencard.common.ObjectCloseListener;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ClosableObject {
    private HashMap listeners = new HashMap();
    private boolean isActive = true;

    protected ClosableObject() {
    }

    public boolean isActive() {
        return this.isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseListener(ObjectCloseListener objectCloseListener) {
        CloseEventRegistration closeEventRegistration = new CloseEventRegistration(objectCloseListener, this);
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            if (!this.isActive) {
                return;
            }
            closeEventRegistration.activate();
            this.listeners.put(objectCloseListener, closeEventRegistration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCloseListener(ObjectCloseListener objectCloseListener) {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.remove(objectCloseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        HashMap hashMap = this.listeners;
        synchronized (hashMap) {
            this.isActive = false;
            Iterator iterator = this.listeners.values().iterator();
            while (iterator.hasNext()) {
                ((CloseEventRegistration)iterator.next()).handleEvent();
            }
        }
    }

    private class CloseEventRegistration
    implements Runnable {
        private ObjectCloseListener listener;
        private ClosableObject closableObject;
        private boolean isActive;

        CloseEventRegistration(ObjectCloseListener objectCloseListener, ClosableObject closableObject2) {
            this.listener = objectCloseListener;
            this.closableObject = closableObject2;
        }

        void activate() {
            this.isActive = true;
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CloseEventRegistration closeEventRegistration = this;
            synchronized (closeEventRegistration) {
                while (this.isActive) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        OCFDebug.printStackTrace(interruptedException);
                    }
                }
            }
            this.listener.objectClosed(this.closableObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleEvent() {
            CloseEventRegistration closeEventRegistration = this;
            synchronized (closeEventRegistration) {
                this.isActive = false;
                this.notify();
            }
        }
    }
}

