/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.cmd;

import com.sun.opencard.cmd.CmdUtils;
import com.sun.opencard.cmd.OCFGetOpt;
import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.SmartcardNoCardException;
import com.sun.smartcard.SmartcardNoSuchPropertyException;
import com.sun.smartcard.SmartcardUnauthorizedAccessException;
import com.sun.smartcard.TimeoutSpec;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class OCFAdmin {
    private String inProperty = null;
    private static ResourceBundle messages;
    private static MessageFormat msgFormatter;
    static final int ServiceArgsMissing = 1;
    static final int TerminalAddModifyArgsMissing = 2;
    static final int DebugArgsMissing = 3;
    static final int OverrideArgsMissing = 4;
    static final int PropertyTypeMissing = 5;
    static final int IllegalPropertyType = 7;
    static final int IllegalActionType = 8;
    static final int ValueAlreadyExists = 9;
    static final int ValueDoesNotExists = 10;
    static final int DeviceAlreadyExists = 11;
    static final int Usage = 12;
    static final int KeyTypeMissing = 13;
    static final int InputFileMissing = 14;
    static final int OutputFileMissing = 15;
    static final int IOError = 16;
    static final int FileNotFound = 17;
    static final int UnauthorizedAccess = 19;
    static final int RestartOCFError = 20;
    static final int NoSuchProperty = 21;
    static final int NoKeyToExport = 22;
    static final int ShouldBeRoot = 23;
    static final int TerminalDeleteArgsMissing = 24;
    static final int PropertyAlreadyExists = 25;
    static final int PropertiesMissingToModify = 26;
    static final int PropertiesAlreadyExistsToAdd = 27;
    static final int PropertiesMissingToDelete = 28;
    static final int ActionMissing = 29;
    static final int PropertyNotFound = 30;
    private boolean restartOCF = false;
    private static boolean libraryLoaded;
    public static String pad;
    private static Object monitor;

    private void parseCmdLine(String[] stringArray) throws Exception {
        Object[] objectArray;
        OCFGetOpt oCFGetOpt = new OCFGetOpt(stringArray, "j:a:d:l:n:r:t:x:i:o:k:IER");
        oCFGetOpt.optErr = true;
        int n = -1;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Smartcard smartcard = null;
        while ((n = oCFGetOpt.getopt()) != -1) {
            switch (n) {
                case 106: {
                    string = oCFGetOpt.optArgGet();
                    break;
                }
                case 97: {
                    string2 = oCFGetOpt.optArgGet();
                    smartcard = new Smartcard(string2, "1");
                    break;
                }
                case 100: {
                    string3 = oCFGetOpt.optArgGet();
                    break;
                }
                case 108: {
                    string4 = oCFGetOpt.optArgGet();
                    break;
                }
                case 110: {
                    string5 = oCFGetOpt.optArgGet();
                    break;
                }
                case 114: {
                    string6 = oCFGetOpt.optArgGet();
                    break;
                }
                case 116: {
                    string8 = oCFGetOpt.optArgGet();
                    break;
                }
                case 120: {
                    string9 = oCFGetOpt.optArgGet();
                    break;
                }
                case 105: {
                    string10 = oCFGetOpt.optArgGet();
                    break;
                }
                case 111: {
                    string11 = oCFGetOpt.optArgGet();
                    break;
                }
                case 107: {
                    string7 = oCFGetOpt.optArgGet();
                    break;
                }
                case 73: {
                    bl3 = true;
                    break;
                }
                case 69: {
                    bl4 = true;
                    break;
                }
                case 82: {
                    this.restartOCF = true;
                    break;
                }
                default: {
                    this.printError(smartcard, 12, null);
                }
            }
        }
        if (smartcard == null) {
            smartcard = new Smartcard("client1", "1.0");
        }
        if (!(string8 == null || string8.equals("terminal") || string8.equals("service") || string8.equals("debug") || string8.equals("override"))) {
            objectArray = new Object[]{new String(string8)};
            this.printError(smartcard, 7, objectArray);
        }
        if (!(string9 == null || string9.equals("add") || string9.equals("modify") || string9.equals("delete"))) {
            objectArray = new Object[]{new String(string9)};
            this.printError(smartcard, 8, objectArray);
        }
        if (string2 != null && string9 == null && oCFGetOpt.optIndexGet() >= stringArray.length && string8 == null) {
            this.listClientProperty(stringArray, oCFGetOpt.optIndexGet(), smartcard, string2);
            smartcard.cleanup();
            System.exit(0);
        }
        if (string2 != null && string8 != null) {
            this.printError(smartcard, 12, null);
        }
        if (this.restartOCF && string8 == null) {
            this.printError(smartcard, 12, null);
        }
        if (this.restartOCF && string8 != null && string8.equals("override")) {
            this.printError(smartcard, 12, null);
        }
        if (string8 != null && string8.equals("service")) {
            if (string == null || string9 == null) {
                this.printError(smartcard, 1, null);
            } else if (string9.equals("add")) {
                this.addService(string, smartcard);
            } else if (string9.equals("modify")) {
                this.modifyService(string, smartcard);
            } else if (string9.equals("delete")) {
                this.deleteService(string, smartcard);
            }
        }
        if (string8 != null && string8.equals("terminal") && string9 == null) {
            this.printError(smartcard, 2, null);
        }
        if (string8 != null && string8.equals("terminal") && (string9.equals("add") || string9.equals("modify"))) {
            if (string == null || string3 == null || string6 == null || string5 == null || string9 == null) {
                this.printError(smartcard, 2, null);
            } else if (string9.equals("add")) {
                this.addTerminal(string, string6, string3, string5, smartcard);
            } else if (string9.equals("modify")) {
                this.modifyTerminal(string, string6, string3, string5, smartcard);
            }
        }
        if (string8 != null && string8.equals("terminal") && string9.equals("delete")) {
            if (string6 == null) {
                this.printError(smartcard, 24, null);
            } else {
                this.deleteTerminal(string, string6, string3, string5, smartcard);
            }
        }
        if (string8 != null && string8.equals("debug")) {
            if (string == null || string4 == null || string9 == null) {
                this.printError(smartcard, 3, null);
            } else if (string9.equals("add")) {
                this.addDebug(string, string4, smartcard);
            } else if (string9.equals("modify")) {
                this.modifyDebug(string, string4, smartcard);
            } else if (string9.equals("delete")) {
                this.deleteDebug(string, string4, smartcard);
            }
        }
        if (string8 != null && string8.equals("override")) {
            if (string9 == null || oCFGetOpt.optIndexGet() >= stringArray.length) {
                this.printError(smartcard, 4, null);
            } else {
                if (string9.equals("add")) {
                    this.addOveride(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                }
                if (string9.equals("modify")) {
                    this.modifyOveride(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                } else if (string9.equals("delete")) {
                    this.deleteOveride(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                }
            }
        }
        if (string8 == null && (string != null || string3 != null || string6 != null || string5 != null || string4 != null)) {
            this.printError(smartcard, 12, null);
        }
        if (string8 == null) {
            if (string2 != null) {
                if (oCFGetOpt.optIndexGet() < stringArray.length) {
                    bl = false;
                    bl2 = false;
                    int n2 = oCFGetOpt.optIndexGet();
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].indexOf(61) != -1) {
                            bl = true;
                        } else {
                            bl2 = true;
                        }
                        ++n2;
                    }
                    if (bl && bl2) {
                        this.printError(smartcard, 12, null);
                    }
                    if (bl) {
                        if (string9 == null) {
                            this.printError(smartcard, 12, null);
                        }
                        if (string9.equals("add")) {
                            this.addClientProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        }
                        if (string9.equals("modify")) {
                            this.modifyClientProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        } else if (string9.equals("delete")) {
                            this.deleteClientProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        }
                    } else if (string9 != null) {
                        if (string9.equals("delete")) {
                            this.deleteClientProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        } else {
                            this.printError(smartcard, 12, null);
                        }
                    } else {
                        this.listClientProperty(stringArray, oCFGetOpt.optIndexGet(), smartcard, string2);
                    }
                } else if (string9 != null) {
                    this.printError(smartcard, 12, null);
                } else {
                    this.listClientProperty(stringArray, oCFGetOpt.optIndexGet(), smartcard, string2);
                }
            } else if (bl3 || bl4) {
                if (bl3 && bl4) {
                    this.printError(smartcard, 12, null);
                }
                if (string7 == null) {
                    this.printError(smartcard, 13, null);
                }
                if (bl3) {
                    if (string10 == null) {
                        this.printError(smartcard, 14, null);
                    } else {
                        this.importCRKey(string7, string10, smartcard);
                    }
                } else if (bl4) {
                    if (string11 == null) {
                        this.printError(smartcard, 15, null);
                    } else {
                        this.exportCRKey(string7, string11, smartcard);
                    }
                }
            } else {
                bl = false;
                bl2 = false;
                if (oCFGetOpt.optIndexGet() < stringArray.length) {
                    int n3 = oCFGetOpt.optIndexGet();
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].indexOf(61) != -1) {
                            bl = true;
                        }
                        ++n3;
                    }
                    if (bl && bl2) {
                        this.printError(smartcard, 12, null);
                    }
                    if (bl) {
                        if (string9 == null) {
                            this.printError(smartcard, 12, null);
                        }
                        if (string9.equals("add")) {
                            this.addServerProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        }
                        if (string9.equals("modify")) {
                            this.modifyServerProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        } else if (string9.equals("delete")) {
                            this.deleteServerProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        }
                    } else if (string9 != null) {
                        if (string9.equals("delete")) {
                            this.deleteServerProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                        } else {
                            this.printError(smartcard, 12, null);
                        }
                    } else {
                        this.listProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                    }
                } else if (string9 != null) {
                    this.printError(smartcard, 12, null);
                } else {
                    this.listProperties(stringArray, oCFGetOpt.optIndexGet(), smartcard);
                }
            }
        }
        smartcard.cleanup();
    }

    private void addService(String string, Smartcard smartcard) {
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.services");
            if (this.ifExists(this.inProperty, string)) {
                this.printError(smartcard, 9, null);
            }
            smartcard.setProperty("OpenCard.services", this.createValue(this.inProperty, string));
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            try {
                smartcard.setProperty("OpenCard.services", string);
                this.checkRestartServer(smartcard);
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void modifyService(String string, Smartcard smartcard) {
        boolean bl = false;
        String string2 = "";
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.services");
            if (!this.ifExists(this.inProperty, string)) {
                this.printError(smartcard, 10, null);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.inProperty, " ");
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                string2 = string2 + " " + string3;
            }
            smartcard.setProperty("OpenCard.services", string2);
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            try {
                smartcard.setProperty("OpenCard.services", string);
                this.checkRestartServer(smartcard);
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void deleteService(String string, Smartcard smartcard) {
        String string2 = "";
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.services");
            string2 = this.deleteValue(this.inProperty, string);
            if (string2.trim().equals("")) {
                smartcard.deleteProperty("OpenCard.services");
            } else {
                smartcard.setProperty("OpenCard.services", string2);
            }
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void addTerminal(String string, String string2, String string3, String string4, Smartcard smartcard) {
        String string5 = "";
        string5 = string + "|" + string2 + "|" + string4 + "|" + string3;
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.terminals");
            if (this.ifTerminalExists(this.inProperty, string2)) {
                this.printError(smartcard, 9, null);
            }
            if (this.ifDeviceExists(this.inProperty, string3)) {
                this.printError(smartcard, 11, null);
            }
            smartcard.setProperty("OpenCard.terminals", this.inProperty + " " + string5);
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            try {
                smartcard.setProperty("OpenCard.terminals", string5);
                this.checkRestartServer(smartcard);
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void modifyTerminal(String string, String string2, String string3, String string4, Smartcard smartcard) {
        boolean bl = false;
        String string5 = "";
        String string6 = "";
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.terminals");
            if (!this.ifTerminalExists(this.inProperty, string2)) {
                this.printError(smartcard, 10, null);
            }
            string6 = string + "|" + string2 + "|" + string4 + "|" + string3;
            StringTokenizer stringTokenizer = new StringTokenizer(this.inProperty, " ");
            String string7 = null;
            String string8 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string7 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string7, "|");
                while (stringTokenizer2.hasMoreTokens()) {
                    string8 = stringTokenizer2.nextToken();
                    string8 = stringTokenizer2.nextToken();
                    if (string8.equals(string2)) {
                        string7 = string6;
                        string8 = stringTokenizer2.nextToken();
                        string8 = stringTokenizer2.nextToken();
                        continue;
                    }
                    string8 = stringTokenizer2.nextToken();
                    string8 = stringTokenizer2.nextToken();
                    if (!string8.equals(string3)) continue;
                    this.printError(smartcard, 11, null);
                }
                string5 = string5 + " " + string7;
            }
            smartcard.setProperty("OpenCard.terminals", string5);
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            try {
                smartcard.setProperty("OpenCard.terminals", string6);
                this.checkRestartServer(smartcard);
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void deleteTerminal(String string, String string2, String string3, String string4, Smartcard smartcard) {
        String string5 = "";
        String string6 = "";
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.terminals");
            if (!this.ifTerminalExists(this.inProperty, string2)) {
                this.printError(smartcard, 10, null);
            }
            if ((string5 = this.deleteTerminalValue(this.inProperty, string6 = string + "|" + string2 + "|" + string4 + "|" + string3, string2)).trim().equals("")) {
                smartcard.deleteProperty("OpenCard.terminals");
            } else {
                smartcard.setProperty("OpenCard.terminals", string5);
            }
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void addDebug(String string, String string2, Smartcard smartcard) {
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.debug");
            if (this.ifExists(this.inProperty, string)) {
                this.printError(smartcard, 9, null);
            }
            smartcard.setProperty("OpenCard.debug", this.createValue(this.inProperty, string + ":" + string2));
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            try {
                smartcard.setProperty("OpenCard.debug", string + ":" + string2);
                this.checkRestartServer(smartcard);
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void modifyDebug(String string, String string2, Smartcard smartcard) {
        int n = 0;
        String string3 = "";
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.debug");
            if (!this.ifExists(this.inProperty, string)) {
                this.printError(smartcard, 10, null);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.inProperty, " ");
            String string4 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                n = string4.indexOf(58);
                if (n != -1 && string4.substring(0, n).equals(string)) {
                    string4 = string4.substring(0, n) + ":" + string2;
                }
                string3 = string3 + " " + string4;
            }
            smartcard.setProperty("OpenCard.debug", string3);
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            try {
                smartcard.setProperty("OpenCard.debug", string + ":" + string2);
                this.checkRestartServer(smartcard);
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardException smartcardException) {
                smartcardException.printStackTrace();
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void deleteDebug(String string, String string2, Smartcard smartcard) {
        String string3 = "";
        try {
            this.checkAccess();
            this.inProperty = smartcard.getProperty("OpenCard.debug");
            string3 = this.deleteValue(this.inProperty, string + ":" + string2);
            if (string3.trim().equals("")) {
                smartcard.deleteProperty("OpenCard.debug");
            } else {
                smartcard.setProperty("OpenCard.debug", string3);
            }
            this.checkRestartServer(smartcard);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private void addOveride(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        int n3 = 0;
        String string = null;
        boolean bl = false;
        try {
            this.checkAccess();
            int n4 = n;
            while (n4 < stringArray.length) {
                this.inProperty = null;
                n2 = stringArray[n4].indexOf(61);
                if (n2 != -1) {
                    string = stringArray[n4].substring(0, n2);
                    n3 = stringArray[n4].indexOf(46);
                    if (n3 != -1) {
                        if (!stringArray[n4].substring(0, n3).equals("OpenCard")) {
                            string = "OpenCard." + stringArray[n4].substring(0, n2);
                        }
                    } else {
                        string = "OpenCard." + stringArray[n4].substring(0, n2);
                    }
                    try {
                        this.inProperty = smartcard.getProperty(string);
                    }
                    catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                        smartcard.setProperty(string, stringArray[n4].substring(n2 + 1, stringArray[n4].length()));
                        smartcard.setProperty(string + ".override", "true");
                    }
                    if (this.inProperty != null) {
                        bl = true;
                    }
                }
                ++n4;
            }
            if (bl) {
                this.printError(smartcard, 27, null);
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void modifyOveride(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        int n3 = 0;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.checkAccess();
            int n4 = n;
            while (n4 < stringArray.length) {
                this.inProperty = null;
                n2 = stringArray[n4].indexOf(61);
                if (n2 != -1) {
                    string = stringArray[n4].substring(0, n2);
                    n3 = stringArray[n4].indexOf(46);
                    if (n3 != -1) {
                        if (!stringArray[n4].substring(0, n3).equals("OpenCard")) {
                            string = "OpenCard." + stringArray[n4].substring(0, n2);
                        }
                    } else {
                        string = "OpenCard." + stringArray[n4].substring(0, n2);
                    }
                    try {
                        bl = false;
                        this.inProperty = smartcard.getProperty(string);
                    }
                    catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                        bl = true;
                        bl2 = true;
                    }
                    if (!bl) {
                        smartcard.setProperty(string, stringArray[n4].substring(n2 + 1, stringArray[n4].length()));
                        smartcard.setProperty(string + ".override", "true");
                    }
                }
                ++n4;
            }
            if (bl2) {
                this.printError(smartcard, 26, null);
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void deleteOveride(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        int n3 = 0;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.checkAccess();
            int n4 = n;
            while (n4 < stringArray.length) {
                n2 = stringArray[n4].indexOf(61);
                if (n2 != -1) {
                    string = stringArray[n4].substring(0, n2);
                    n3 = stringArray[n4].indexOf(46);
                    if (n3 != -1) {
                        if (!stringArray[n4].substring(0, n3).equals("OpenCard")) {
                            string = "OpenCard." + stringArray[n4].substring(0, n2);
                        }
                    } else {
                        string = "OpenCard." + stringArray[n4].substring(0, n2);
                    }
                } else {
                    string = stringArray[n4];
                    n3 = stringArray[n4].indexOf(46);
                    if (n3 != -1) {
                        if (!stringArray[n4].substring(0, n3).equals("OpenCard")) {
                            string = "OpenCard." + stringArray[n4];
                        }
                    } else {
                        string = "OpenCard." + stringArray[n4];
                    }
                }
                try {
                    bl = false;
                    this.inProperty = smartcard.getProperty(string);
                }
                catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                    bl = true;
                    bl2 = true;
                }
                if (!bl) {
                    smartcard.deleteProperty(string);
                    smartcard.deleteProperty(string + ".override");
                }
                ++n4;
            }
            if (bl2) {
                this.printError(smartcard, 28, null);
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addClientProperties(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        try {
            int n3 = n;
            while (n3 < stringArray.length) {
                this.inProperty = null;
                n2 = stringArray[n3].indexOf(61);
                string = stringArray[n3].substring(0, n2);
                try {
                    this.inProperty = smartcard.getClientProperty(string);
                }
                catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                    smartcard.setClientProperty(string, stringArray[n3].substring(n2 + 1, stringArray[n3].length()));
                }
                if (this.inProperty != null) {
                    bl2 = true;
                }
                ++n3;
            }
            if (bl2) {
                this.printError(smartcard, 27, null);
            }
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void modifyClientProperties(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n3 = n;
            while (n3 < stringArray.length) {
                this.inProperty = null;
                n2 = stringArray[n3].indexOf(61);
                if (n2 != -1) {
                    string = stringArray[n3].substring(0, n2);
                    try {
                        bl2 = false;
                        this.inProperty = smartcard.getClientProperty(string);
                    }
                    catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                        bl2 = true;
                        bl3 = true;
                    }
                    if (!bl2) {
                        smartcard.setClientProperty(string, stringArray[n3].substring(n2 + 1, stringArray[n3].length()));
                    }
                }
                ++n3;
            }
            if (bl3) {
                this.printError(smartcard, 26, null);
            }
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void deleteClientProperties(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            int n3 = n;
            while (n3 < stringArray.length) {
                n2 = stringArray[n3].indexOf(61);
                string = n2 != -1 ? stringArray[n3].substring(0, n2) : stringArray[n3];
                try {
                    bl2 = false;
                    this.inProperty = smartcard.getClientProperty(string);
                }
                catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                    bl2 = true;
                    bl3 = true;
                }
                if (!bl2) {
                    smartcard.deleteClientProperty(string);
                }
                ++n3;
            }
            if (bl3) {
                this.printError(smartcard, 28, null);
            }
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void listClientProperty(String[] stringArray, int n, Smartcard smartcard, String string) {
        block10: {
            Enumeration enumeration = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            try {
                System.out.println("\nClient Properties:\n");
                System.out.println("  ClientName.PropertyName          Value");
                System.out.println("  -----------------------          -----");
                if (n >= stringArray.length) {
                    enumeration = smartcard.clientProperties();
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        string3 = smartcard.getClientProperty(string2);
                        this.printProperty(string + "." + string2, string3);
                    }
                    break block10;
                }
                int n2 = n;
                while (n2 < stringArray.length) {
                    string2 = stringArray[n2];
                    try {
                        string3 = smartcard.getClientProperty(string2);
                        string2 = string + "." + string2;
                        this.printProperty(string2, string3);
                    }
                    catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    this.printError(smartcard, 30, null);
                }
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                this.printError(smartcard, 21, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void addServerProperties(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        try {
            this.checkAccess();
            int n3 = n;
            while (n3 < stringArray.length) {
                this.inProperty = null;
                n2 = stringArray[n3].indexOf(61);
                string = stringArray[n3].substring(0, n2);
                try {
                    this.inProperty = smartcard.getProperty(string);
                }
                catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                    smartcard.setProperty(string, stringArray[n3].substring(n2 + 1, stringArray[n3].length()));
                }
                if (this.inProperty != null) {
                    bl2 = true;
                }
                ++n3;
            }
            if (bl2) {
                this.printError(smartcard, 27, null);
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void modifyServerProperties(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.checkAccess();
            int n3 = n;
            while (n3 < stringArray.length) {
                this.inProperty = null;
                n2 = stringArray[n3].indexOf(61);
                if (n2 != -1) {
                    string = stringArray[n3].substring(0, n2);
                    try {
                        bl2 = false;
                        this.inProperty = smartcard.getProperty(string);
                    }
                    catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                        bl2 = true;
                        bl3 = true;
                    }
                    if (!bl2) {
                        smartcard.setProperty(string, stringArray[n3].substring(n2 + 1, stringArray[n3].length()));
                    }
                }
                ++n3;
            }
            if (bl3) {
                this.printError(smartcard, 26, null);
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void deleteServerProperties(String[] stringArray, int n, Smartcard smartcard) {
        int n2 = 0;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            this.checkAccess();
            int n3 = n;
            while (n3 < stringArray.length) {
                n2 = stringArray[n3].indexOf(61);
                string = n2 != -1 ? stringArray[n3].substring(0, n2) : stringArray[n3];
                try {
                    bl2 = false;
                    this.inProperty = smartcard.getProperty(string);
                }
                catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                    bl2 = true;
                    bl3 = true;
                }
                if (!bl2) {
                    smartcard.deleteProperty(string);
                }
                ++n3;
            }
            if (bl3) {
                this.printError(smartcard, 28, null);
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean listClientProperties(Smartcard var1_1) {
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        try {
            block6: {
                var3_3 = var1_1.listClients();
                if (var3_3 == null || !var3_3.hasMoreElements()) break block6;
                System.out.println("\nClient Properties:\n");
                System.out.println("  ClientName.PropertyName          Value");
                System.out.println("  -----------------------          -----");
                if (true) ** GOTO lbl26
            }
            return false;
            do {
                if ((var2_2 = (var7_7 = new Smartcard(var6_6 = (String)var3_3.nextElement(), "1.0")).clientProperties()) != null && var2_2.hasMoreElements()) {
                    while (var2_2 != null && var2_2.hasMoreElements()) {
                        var4_4 = (String)var2_2.nextElement();
                        var5_5 = var7_7.getClientProperty(var4_4);
                        this.printProperty(var6_6 + "." + var4_4, var5_5);
                    }
                    var7_7.cleanup();
                    continue;
                }
                var7_7.cleanup();
                return false;
lbl26:
                // 2 sources

            } while (var3_3 != null && var3_3.hasMoreElements());
        }
        catch (SmartcardUnauthorizedAccessException var7_8) {
        }
        catch (Exception var8_9) {
            var8_9.printStackTrace();
        }
        return true;
    }

    private void listProperties(String[] stringArray, int n, Smartcard smartcard) {
        block9: {
            String string = null;
            String string2 = null;
            boolean bl = false;
            try {
                if (stringArray.length == 0) {
                    this.listAllProperties(smartcard);
                    break block9;
                }
                this.checkAccess();
                System.out.println("\nServer Properties:\n");
                System.out.println("  PropertyName                     Value");
                System.out.println("  ------------                     -----");
                int n2 = n;
                while (n2 < stringArray.length) {
                    try {
                        string = stringArray[n2];
                        string2 = smartcard.getProperty(string);
                        this.printProperty(string, string2);
                    }
                    catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    this.printError(smartcard, 30, null);
                }
            }
            catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
                this.printError(smartcard, 19, null);
            }
            catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
                this.printError(smartcard, 21, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void printProperty(String string, String string2) {
        int n = 30 - string.length();
        if (n < 0) {
            n = 0;
        }
        System.out.println("  " + string + pad.substring(0, n) + " = " + string2);
    }

    private void listAllProperties(Smartcard smartcard) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        try {
            bl = this.listClientProperties(smartcard);
            if (OCFAdmin.getuid(null) != 0) {
                if (!bl) {
                    System.out.println("No properties found.");
                }
                return;
            }
            Enumeration enumeration = smartcard.properties();
            Enumeration enumeration2 = smartcard.readersConfigured();
            if (enumeration == null && enumeration2 == null) {
                if (!bl) {
                    System.out.println("No properties found.");
                }
                return;
            }
            System.out.println("\nServer Properties:\n");
            System.out.println("  PropertyName                     Value");
            System.out.println("  ------------                     -----");
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    string2 = smartcard.getProperty(string);
                    this.printProperty(string, string2);
                }
            }
            if (enumeration2 != null) {
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    try {
                        Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(string3), new AIDSpec(), new TimeoutSpec(1, 0));
                        this.printProperty(card.getReaderName() + "." + card.getSlotID() + ".ATR", card.getATR());
                    }
                    catch (SmartcardNoCardException smartcardNoCardException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    private boolean ifExists(String string, String string2) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            n = string3.indexOf(58);
            if (!(n != -1 ? string3.substring(0, n).equals(string2) : string3.equals(string2))) continue;
            return true;
        }
        return false;
    }

    private boolean ifTerminalExists(String string, String string2) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|");
            while (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
                string4 = stringTokenizer2.nextToken();
                if (string4.equals(string2)) {
                    return true;
                }
                string4 = stringTokenizer2.nextToken();
                string4 = stringTokenizer2.nextToken();
            }
        }
        return false;
    }

    private boolean ifDeviceExists(String string, String string2) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "|");
            while (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken();
                string4 = stringTokenizer2.nextToken();
                string4 = stringTokenizer2.nextToken();
                string4 = stringTokenizer2.nextToken();
                if (!string4.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private String deleteTerminalValue(String string, String string2, String string3) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string4 = null;
        String string5 = null;
        String string6 = "";
        if (string.indexOf(32) != -1) {
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "|");
                while (stringTokenizer2.hasMoreTokens()) {
                    string5 = stringTokenizer2.nextToken();
                    string5 = stringTokenizer2.nextToken();
                    if (!string5.equals(string3)) {
                        string6 = string6 + " " + string4;
                    }
                    string5 = stringTokenizer2.nextToken();
                    string5 = stringTokenizer2.nextToken();
                }
            }
        }
        return string6;
    }

    private String deleteValue(String string, String string2) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string3 = null;
        String string4 = "";
        if (string.indexOf(32) != -1) {
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals(string2)) continue;
                string4 = string4 + " " + string3;
            }
        }
        return string4;
    }

    private String createValue(String string, String string2) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string3 = null;
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string4 = string4 + " " + string3;
        }
        string4 = string4 + " " + string2;
        return string4;
    }

    private void importCRKey(String string, String string2, Smartcard smartcard) {
        FileInputStream fileInputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        this.checkAccess();
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{new String(string2)};
            this.printError(smartcard, 17, objectArray);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
            }
        }
        catch (IOException iOException) {
            this.printError(smartcard, 16, null);
        }
        String string4 = new String(stringBuffer);
        try {
            smartcard.setProperty("keys." + string, string4);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 21, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.printError(smartcard, 16, null);
        }
    }

    private void exportCRKey(String string, String string2, Smartcard smartcard) {
        FileOutputStream fileOutputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = null;
        this.checkAccess();
        try {
            string3 = smartcard.getProperty("keys." + string);
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            this.printError(smartcard, 19, null);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
            this.printError(smartcard, 22, null);
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
            this.printError(smartcard, 22, null);
        }
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (IOException iOException) {
            this.printError(smartcard, 16, null);
        }
        try {
            ((OutputStream)fileOutputStream).write(string3.getBytes());
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            this.printError(smartcard, 16, null);
        }
    }

    private void checkRestartServer(Smartcard smartcard) {
        try {
            if (this.restartOCF) {
                smartcard.suspend();
                String string = "/bin/pkill -9 -x -u 0 ocfserv";
                Runtime.getRuntime().exec(string).waitFor();
                smartcard.resume();
            }
        }
        catch (IOException iOException) {
            this.printError(smartcard, 20, null);
        }
        catch (InterruptedException interruptedException) {
            this.printError(smartcard, 20, null);
        }
        catch (SmartcardException smartcardException) {
            this.printError(smartcard, 20, null);
        }
    }

    private void printError(Smartcard smartcard, int n, Object[] objectArray) {
        switch (n) {
            case 1: {
                System.out.println(messages.getString("OCFAdmin.ServiceArgsMissing"));
                break;
            }
            case 2: {
                System.out.println(messages.getString("OCFAdmin.TerminalAddModifyArgsMissing"));
                break;
            }
            case 24: {
                System.out.println(messages.getString("OCFAdmin.TerminalDeleteArgsMissing"));
                break;
            }
            case 3: {
                System.out.println(messages.getString("OCFAdmin.DebugArgsMissing"));
                break;
            }
            case 4: {
                System.out.println(messages.getString("OCFAdmin.OverrideArgsMissing"));
                break;
            }
            case 7: {
                msgFormatter.applyPattern(messages.getString("OCFAdmin.IllegalPropertyType"));
                System.out.println(msgFormatter.format(objectArray));
                break;
            }
            case 8: {
                msgFormatter.applyPattern(messages.getString("OCFAdmin.IllegalActionType"));
                System.out.println(msgFormatter.format(objectArray));
                break;
            }
            case 5: {
                System.out.println(messages.getString("OCFAdmin.PropertyTypeMissing"));
                break;
            }
            case 26: {
                System.out.println(messages.getString("OCFAdmin.PropertiesMissingToModify"));
                break;
            }
            case 28: {
                System.out.println(messages.getString("OCFAdmin.PropertiesMissingToDelete"));
                break;
            }
            case 13: {
                System.out.println(messages.getString("OCFAdmin.KeyTypeMissing"));
                break;
            }
            case 14: {
                System.out.println(messages.getString("OCFAdmin.InputFileMissing"));
                break;
            }
            case 15: {
                System.out.println(messages.getString("OCFAdmin.OutputFileMissing"));
                break;
            }
            case 17: {
                msgFormatter.applyPattern(messages.getString("OCFAdmin.FileNotFound"));
                System.out.println(msgFormatter.format(objectArray));
                break;
            }
            case 16: {
                System.out.println(messages.getString("OCFAdmin.IOError"));
                break;
            }
            case 19: {
                System.out.println(messages.getString("OCFAdmin.UnauthorizedAccess"));
                break;
            }
            case 23: {
                System.out.println(messages.getString("OCFAdmin.ShouldBeRoot"));
                break;
            }
            case 9: {
                System.out.println(messages.getString("OCFAdmin.ValueAlreadyExists"));
                break;
            }
            case 25: {
                System.out.println(messages.getString("OCFAdmin.PropertyAlreadyExists"));
                break;
            }
            case 27: {
                System.out.println(messages.getString("OCFAdmin.PropertiesAlreadyExistsToAdd"));
                break;
            }
            case 10: {
                System.out.println(messages.getString("OCFAdmin.ValueDoesNotExists"));
                break;
            }
            case 21: {
                System.out.println(messages.getString("OCFAdmin.NoSuchProperty"));
                break;
            }
            case 22: {
                System.out.println(messages.getString("OCFAdmin.NoKeyToExport"));
                break;
            }
            case 11: {
                System.out.println(messages.getString("OCFAdmin.DeviceAlreadyExists"));
                break;
            }
            case 20: {
                System.out.println(messages.getString("OCFAdmin.RestartOCFError"));
                break;
            }
            case 12: {
                System.out.println(messages.getString("OCFAdmin.Usage"));
                break;
            }
            case 29: {
                System.out.println(messages.getString("OCFAdmin.ActionMissing"));
                break;
            }
            case 30: {
                System.out.println(messages.getString("OCFAdmin.PropertyNotFound"));
                break;
            }
            default: {
                System.out.println(messages.getString("OCFAdmin.Usage"));
            }
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
        System.exit(0);
    }

    private static void initialize() {
        try {
            Locale locale = CmdUtils.initLocale();
            msgFormatter = new MessageFormat("");
            msgFormatter.setLocale(locale);
            messages = CmdUtils.getMessageBundle(locale);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(1);
        }
    }

    public void run(String[] stringArray) throws Exception {
        OCFAdmin.initialize();
        this.parseCmdLine(stringArray);
    }

    public static void main(String[] stringArray) {
        OCFAdmin oCFAdmin = new OCFAdmin();
        try {
            oCFAdmin.run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSmartcardLibrary() throws SmartcardException {
        if (libraryLoaded) {
            return;
        }
        Object object = monitor;
        synchronized (object) {
            if (libraryLoaded) {
                return;
            }
            try {
                System.loadLibrary("smartcard");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    unsatisfiedLinkError.printStackTrace();
                    System.load("/usr/lib/libsmartcard.so.1");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    unsatisfiedLinkError2.printStackTrace();
                    throw new SmartcardException("Unable to get UID");
                }
            }
            libraryLoaded = true;
        }
    }

    public static native int scadmin_getuid(String var0);

    public static int getuid(String string) throws SmartcardException {
        OCFAdmin.loadSmartcardLibrary();
        return OCFAdmin.scadmin_getuid(string);
    }

    private void checkAccess() {
        try {
            if (OCFAdmin.getuid(null) != 0) {
                this.printError(null, 23, null);
            }
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
    }

    static {
        libraryLoaded = false;
        pad = new String("                                      ");
        monitor = new Object();
    }
}

