/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.Card;
import com.sun.smartcard.scf.CardManager;
import com.sun.smartcard.scf.CardPresenceMonitor;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InternalTerminal;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.NoCardException;
import com.sun.smartcard.scf.TerminalEventDispatcher;
import com.sun.smartcard.scf.TerminalEventListener;
import com.sun.smartcard.scf.TerminalInfo;
import com.sun.smartcard.scf.TerminalManager;
import com.sun.smartcard.scf.TimeoutException;

public class Terminal {
    public static final String INFO_NAME = "name";
    public static final String INFO_TYPE = "type";
    public static final String INFO_DEVICE = "address";
    public static final int EVENT_CARDINSERTED = 1;
    public static final int EVENT_CARDREMOVED = 2;
    public static final int EVENT_TERMINALCLOSED = 4;
    public static final int EVENT_COMMUNICATIONERROR = 8;
    public static final int EVENT_CARDRESET = 16;
    public static final int EVENT_CARDPRESENT = 32;
    public static final int EVENT_CARDABSENT = 64;
    public static final int EVENT_ALL = 127;
    public static final int TIMEOUT_MAX = 2147483;
    private boolean isActive = false;
    private TerminalManager terminalManager;
    private TerminalInfo terminalInfo;
    private TerminalEventDispatcher eventDispatcher;
    private CardManager cardManager;
    private CardPresenceMonitor cardPresenceMonitor;
    private final Logger logger = Logger.createLogger("Terminal");

    Terminal() {
    }

    void init(InternalTerminal internalTerminal, TerminalManager terminalManager) {
        this.logger.log("init", "");
        this.terminalManager = terminalManager;
        this.cardManager = internalTerminal.getCardManager();
        this.cardPresenceMonitor = internalTerminal.getCardPresenceMonitor();
        this.eventDispatcher = internalTerminal.getTerminalEventDispatcher();
        this.eventDispatcher.setOwner(this);
        this.terminalInfo = internalTerminal.getTerminalInfo();
    }

    void activate() {
        this.logger.log("activate", "");
        this.cardManager.activate();
        this.cardPresenceMonitor.activate();
        this.eventDispatcher.activate();
        this.isActive = true;
    }

    public void close() {
        this.logger.log("close", "");
        if (this.isActive) {
            this.isActive = false;
            this.cardManager.passivate();
            this.cardPresenceMonitor.passivate();
            this.terminalManager.terminalClosed(this.terminalInfo.getName());
            this.eventDispatcher.notifyListeners(4);
            this.eventDispatcher.passivate();
        }
    }

    public Card getCard() throws InvalidStateException, NoCardException {
        this.logger.log("getCard", "");
        this.verifyState();
        return this.cardManager.getCard();
    }

    public void waitForCardPresent(int n) throws InvalidStateException, TimeoutException {
        this.logger.log("waitForCardPresent", "timeout=" + n);
        this.verifyState();
        this.cardPresenceMonitor.waitForCardPresenceState(n, true);
        this.verifyState();
    }

    public void waitForCardAbsent(int n) throws InvalidStateException, TimeoutException {
        this.logger.log("waitForCardAbsent", "timeout=" + n);
        this.verifyState();
        this.cardPresenceMonitor.waitForCardPresenceState(n, false);
        this.verifyState();
    }

    public void addEventListener(TerminalEventListener terminalEventListener, int n) throws InvalidStateException {
        this.logger.log("addEventListener", "");
        this.verifyState();
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException("Invalid event mask.");
        }
        if (terminalEventListener == null) {
            throw new IllegalArgumentException("Listener cannot be null.");
        }
        this.eventDispatcher.addEventListenerAndDispatchInitialStateEvent(terminalEventListener, n);
    }

    public void removeEventListener(TerminalEventListener terminalEventListener) throws InvalidStateException {
        this.logger.log("removeEventListener", "");
        this.verifyState();
        if (terminalEventListener == null) {
            return;
        }
        this.eventDispatcher.removeEventListener(terminalEventListener);
    }

    public Object getInfo(String string) throws InvalidStateException, CommException, InternalException {
        this.logger.log("getInfo", "");
        this.verifyState();
        if (string == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        return this.terminalInfo.get(string);
    }

    private void verifyState() throws InvalidStateException {
        if (!this.isActive) {
            throw new InvalidStateException();
        }
    }
}

