/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InternalTerminal;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.NoSuchTerminalException;
import com.sun.smartcard.scf.spi.SessionProvider;
import com.sun.smartcard.scf.spi.TerminalProvider;
import java.util.HashMap;
import java.util.Iterator;

class InternalTerminalManager {
    private final Logger logger = Logger.createLogger("InternalTerminalManager");
    private boolean isActive = false;
    private SessionProvider sessionProvider;
    private HashMap openTerminals;

    InternalTerminalManager() {
    }

    void init(SessionProvider sessionProvider) {
        this.logger.log("init", "");
        this.isActive = false;
        this.sessionProvider = sessionProvider;
        this.openTerminals = new HashMap();
    }

    void activate() {
        this.isActive = true;
    }

    void close() {
        this.logger.log("close", "");
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        Iterator iterator = this.openTerminals.values().iterator();
        while (iterator.hasNext()) {
            ((InternalTerminal)iterator.next()).close();
        }
        this.openTerminals = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalTerminal getInternalTerminal(String string) throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        this.logger.log("getInternalTerminal", "");
        InternalTerminal internalTerminal = null;
        HashMap hashMap = this.openTerminals;
        synchronized (hashMap) {
            block4: {
                internalTerminal = (InternalTerminal)this.openTerminals.get(string);
                if (internalTerminal == null) break block4;
                InternalTerminal internalTerminal2 = internalTerminal;
                return internalTerminal2;
            }
            internalTerminal = new InternalTerminal();
            TerminalProvider terminalProvider = this.sessionProvider.getTerminalProvider(string);
            internalTerminal.init(string, terminalProvider);
            internalTerminal.activate();
            this.openTerminals.put(string, internalTerminal);
        }
        return internalTerminal;
    }
}

