/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.PinCardService;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.TimeoutSpec;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Vector;
import sun.security.util.DerOutputStream;
import sun.security.x509.AlgorithmId;

public class SignatureCardService {
    OCFClientSocket server = new OCFClientSocket();
    Card card;

    public SignatureCardService(Card card) throws SmartcardException {
        this.card = card;
    }

    public byte[] sign(String string, String string2, byte[] byArray) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.card.getClientHandle()));
        vector.add(new Long(this.card.getCardHandle()));
        vector.add(string);
        vector.add(string2);
        vector.add(byArray);
        String string3 = OCFEncoder.encode(vector);
        String string4 = this.server.serverResponse("CardService", "SignatureCardService", "sign", string3);
        Vector vector2 = OCFDecoder.decode(string4);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        byte[] byArray2 = (byte[])vector2.elementAt(0);
        char[] cArray = new char[byArray2.length];
        int n = 0;
        while (n < byArray2.length) {
            cArray[n] = (char)byArray2[n];
            ++n;
        }
        return SignatureCardService.parseHexString(new String(cArray));
    }

    public static void main(String[] stringArray) {
        Smartcard smartcard = null;
        try {
            smartcard = new Smartcard("client1");
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec());
            System.out.println("Card inserted: " + card);
            PinCardService pinCardService = (PinCardService)card.getCardService("com.sun.smartcard.PinCardService");
            if (pinCardService.validateAndUnlock("$$$$java")) {
                System.out.println("Unlocked card");
            }
            SignatureCardService signatureCardService = (SignatureCardService)card.getCardService("com.sun.smartcard.SignatureCardService");
            String string = "Test string for sign";
            byte[] byArray = signatureCardService.sign("default", "RSA", string.getBytes());
            System.out.println("Signature from the card: ");
            System.out.println("signature length:" + byArray.length);
            SignatureCardService.printhex(byArray);
            FileInputStream fileInputStream = new FileInputStream("/tmp/rsapublic");
            byte[] byArray2 = new byte[fileInputStream.available()];
            fileInputStream.read(byArray2);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            BigInteger bigInteger = rSAPublicKey.getPublicExponent();
            BigInteger bigInteger2 = rSAPublicKey.getModulus();
            BigInteger bigInteger3 = new BigInteger(byArray);
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger, bigInteger2);
            byte[] byArray3 = bigInteger4.toByteArray();
            System.out.println("decrypted  data on host: " + byArray3.length);
            SignatureCardService.printhex(byArray3);
            byte[] byArray4 = string.getBytes();
            byte[] byArray5 = SignatureCardService.hashPadData(byArray4);
            System.out.println("padded on host: " + byArray5.length);
            SignatureCardService.printhex(byArray5);
            byte[] byArray6 = new byte[byArray5.length - 1];
            System.arraycopy(byArray5, 1, byArray6, 0, byArray5.length - 1);
            System.out.println("one short on host: " + byArray6.length);
            SignatureCardService.printhex(byArray6);
            if (Arrays.equals(byArray3, byArray6)) {
                System.out.println("Verified");
            } else {
                System.out.println("dont match");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
    }

    public static byte[] parseHexString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if ((n & 1) != 0) {
            string = "0" + string;
            ++n;
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Character.digit(string.charAt(n3++), 16);
            int n5 = Character.digit(string.charAt(n3++), 16);
            byArray[n2++] = (byte)(n4 << 4 | n5);
        }
        return byArray;
    }

    public static void printhex(byte[] byArray) {
        if (byArray == null) {
            System.out.println("array is null");
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            byte by = (byte)((byArray[n] & 0xF0) >>> 4);
            byte by2 = (byte)(byArray[n] & 0xF);
            char c = by < 10 ? (char)(48 + by) : (char)(65 + by - 10);
            System.out.print(c);
            c = by2 < 10 ? (char)(48 + by2) : (char)(65 + by2 - 10);
            System.out.print(c);
            ++n;
        }
        System.out.println("\n\n");
    }

    private static byte[] hashPadData(byte[] byArray) throws Exception {
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("SHA1");
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        System.out.println("length of hash " + byArray2.length);
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        AlgorithmId algorithmId = AlgorithmId.get("SHA1");
        byte[] byArray3 = null;
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putOctetString(byArray2);
        derOutputStream.write((byte)48, derOutputStream2);
        byArray3 = derOutputStream.toByteArray();
        return SignatureCardService.padHash(byArray3, 128);
    }

    private static byte[] padHash(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        byArray2[0] = 0;
        byArray2[1] = 1;
        int n2 = 2;
        while (n2 < n - 1 - byArray.length) {
            byArray2[n2] = -1;
            ++n2;
        }
        byArray2[byArray2.length - byArray.length] = 0;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        return byArray2;
    }
}

