/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.OCFClientSocket;
import com.sun.smartcard.OCFDecoder;
import com.sun.smartcard.OCFEncoder;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardDoubleLockException;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.TimeoutSpec;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;

public class Card {
    private Smartcard sc;
    private long cardHandle;
    private OCFClientSocket server;
    public static final String PIN_CARD_SERVICE = "com.sun.smartcard.PinCardService";
    public static final String USERINFO_CARD_SERVICE = "com.sun.smartcard.UserInfoCardService";
    public static final String KEYIMPORT_CARD_SERVICE = "com.sun.smartcard.KeyImportCardService";
    public static final String CARDLETADMIN_CARD_SERVICE = "com.sun.smartcard.CardletAdminCardService";
    public static final String SIGNATURE_CARD_SERVICE = "com.sun.smartcard.SignatureCardService";
    public static final String PASSTHRU_CARD_SERVICE = "com.sun.smartcard.PassThruCardService";

    private Card() {
    }

    protected Card(Smartcard smartcard, long l) throws SmartcardException {
        this.sc = smartcard;
        this.cardHandle = l;
        this.server = new OCFClientSocket();
    }

    public Object getCardService(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        Class[] classArray = new Class[]{Class.forName("com.sun.smartcard.Card")};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        Object[] objectArray = new Object[]{this};
        return constructor.newInstance(objectArray);
    }

    public void waitForCardRemoved() throws SmartcardException {
        this.sc.waitForCardRemoved(this);
    }

    public Enumeration properties() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        String string = OCFEncoder.encode(vector);
        String string2 = this.server.serverResponse("OCF", "OCFService", "listCardProperties", string);
        Vector vector2 = OCFDecoder.decode(string2);
        if (vector2 == null) {
            return null;
        }
        Vector vector3 = (Vector)vector2.elementAt(0);
        return vector3 == null ? null : vector3.elements();
    }

    public void setProperty(String string, String string2) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(string);
        vector.add(string2);
        String string3 = OCFEncoder.encode(vector);
        String string4 = this.server.serverResponse("OCF", "OCFService", "setCardProperty", string3);
        OCFDecoder.decode(string4);
    }

    public String getProperty(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("OCF", "OCFService", "getCardProperty", string2);
        Vector vector2 = OCFDecoder.decode(string3);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        return (String)vector2.elementAt(0);
    }

    public void deleteProperty(String string) throws SmartcardException {
        Vector<Object> vector = new Vector<Object>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(string);
        String string2 = OCFEncoder.encode(vector);
        String string3 = this.server.serverResponse("OCF", "OCFService", "deleteCardProperty", string2);
        OCFDecoder.decode(string3);
    }

    public String getCardName() throws SmartcardException {
        return this.getCardType();
    }

    public String getCardType() throws SmartcardException {
        return (String)this.getCardData("getCardType");
    }

    private Object getCardData(String string) throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.cardHandle));
        Vector vector2 = this.sc.getResponse(string, vector);
        if (vector2 == null || vector2.size() == 0) {
            return null;
        }
        return vector2.elementAt(0);
    }

    public String getReaderName() throws SmartcardException {
        return (String)this.getCardData("getReaderName");
    }

    public int getSlotID() throws SmartcardException {
        return (Integer)this.getCardData("getSlotID");
    }

    public String getATR() throws SmartcardException {
        return (String)this.getCardData("getATR");
    }

    protected long getClientHandle() {
        return this.sc.getClientHandle();
    }

    protected long getCardHandle() {
        return this.cardHandle;
    }

    public String toString() {
        return new String("Client Handle: " + this.sc.getClientHandle() + " Card Handle: " + this.cardHandle);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Card)) {
            return false;
        }
        Card card = (Card)object;
        return card.cardHandle == this.cardHandle;
    }

    public void lock(int n) throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        vector.add(new Long(n));
        this.sc.getResponse("lock", vector);
    }

    public void unlock() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        this.sc.getResponse("unlock", vector);
    }

    public void reset() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        this.sc.getResponse("reset", vector);
    }

    public void waitForCardReset() throws SmartcardException {
        Vector<Long> vector = new Vector<Long>();
        vector.add(new Long(this.sc.getClientHandle()));
        vector.add(new Long(this.cardHandle));
        this.sc.getSyncResponse("waitForCardReset", vector);
    }

    OCFClientSocket getSocket() {
        return this.server;
    }

    public static void main(String[] stringArray) {
        Smartcard smartcard = null;
        try {
            smartcard = new Smartcard();
            Card card = smartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(), new AIDSpec(), new TimeoutSpec(1, 0));
            System.out.println("cardname=" + card.getCardType());
            System.out.println("ATR=" + card.getATR());
            System.out.println("ReaderName=" + card.getReaderName());
            System.out.println("SlotID=" + card.getSlotID());
            card.lock(5);
            System.out.println("Card locked");
            try {
                card.lock(1);
            }
            catch (SmartcardDoubleLockException smartcardDoubleLockException) {
                System.out.println("Already holding a lock");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            card.unlock();
            System.out.println("Card unlocked");
            card.unlock();
        }
        catch (SmartcardException smartcardException) {
            smartcardException.printStackTrace();
        }
        if (smartcard != null) {
            smartcard.cleanup();
        }
    }
}

