/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.TerminalConfig;
import com.sun.emp.mtp.admin.data.TerminalData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class Terminal
extends BaseMBean {
    public Terminal(String string) {
        this(string, "Table BootStrap Instance", null);
    }

    public Terminal(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new TerminalData());
        this.setLocalConfig(new TerminalConfig());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("terminalType", "Type of terminal handler"));
        treeSet.add(new TMonitorAttribute("processID", "Process ID (PID) of process handling this terminal"));
        treeSet.add(new TMonitorAttribute("busy", "TRUE when terminal is busy"));
        treeSet.add(new TMonitorAttribute("inService", "TRUE when terminal is in service"));
        treeSet.add(new TMonitorAttribute("status", "Terminal status"));
        treeSet.add(new TMonitorAttribute("terminalModel", "Terminal model number"));
        treeSet.add(new TMonitorAttribute("useridName", "Userid of terminal user"));
        treeSet.add(new TMonitorAttribute("accounting", "Accounting option"));
        treeSet.add(new TMonitorAttribute("deviceName", "Terminal device name"));
        treeSet.add(new TMonitorAttribute("active", "Current activity count for remotely connected terminals"));
        treeSet.add(new TMonitorAttribute("messageSequenceNumber", "Total number of messages for TCP/IP based terminals"));
        treeSet.add(new TMonitorAttribute("hostName", "Host name of terminal handler"));
        treeSet.add(new TMonitorAttribute("port", "Port number of terminal handler"));
        treeSet.add(new TMonitorAttribute("LUName", "LU name of terminal handler"));
        treeSet.add(new TMonitorAttribute("sessionID", "Session ID"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("group", "Group assigned to this terminal", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public String getTerminalType() {
        return ((TerminalData)this.getData()).terminalType;
    }

    public int getProcessID() {
        return ((TerminalData)this.getData()).processID;
    }

    public boolean isBusy() {
        return ((TerminalData)this.getData()).busy;
    }

    public boolean isInService() {
        return ((TerminalData)this.getData()).inService;
    }

    public char getStatus() {
        return ((TerminalData)this.getData()).status;
    }

    public String getTerminalModel() {
        return ((TerminalData)this.getData()).terminalModel;
    }

    public String getUseridName() {
        return ((TerminalData)this.getData()).useridName;
    }

    public char getAccounting() {
        return ((TerminalData)this.getData()).accounting;
    }

    public String getDeviceName() {
        return ((TerminalData)this.getData()).deviceName;
    }

    public short getActive() {
        return ((TerminalData)this.getData()).active;
    }

    public int getMessageSequenceNumber() {
        return ((TerminalData)this.getData()).messageSequenceNumber;
    }

    public String getHostName() {
        return ((TerminalData)this.getData()).hostName;
    }

    public int getPort() {
        return ((TerminalData)this.getData()).port;
    }

    public String getLUName() {
        return ((TerminalData)this.getData()).LUName;
    }

    public int getSessionID() {
        return ((TerminalData)this.getData()).sessionID;
    }

    public String getGroup() {
        return ((TerminalConfig)this.getConfig()).group;
    }
}

