/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

public class Cursor {
    private int width;
    private int height;
    private int row;
    private int column;
    private int displaySize;

    public Cursor(int n, int n2) {
        this(n, n2, 1, 1);
    }

    public Cursor(int n, int n2, int n3, int n4) {
        if (n <= 0) {
            throw new IllegalArgumentException("width<0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("height<0");
        }
        this.width = n;
        this.height = n2;
        this.displaySize = n * n2;
        this.setRow(n4);
        this.setColumn(n3);
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int n) {
        if (n < 0) {
            this.decrement(-n);
        }
        int n2 = (this.row - 1) * this.width + (this.column - 1);
        n2 = (n2 + n) % this.displaySize;
        this.row = n2 / this.width + 1;
        this.column = n2 % this.width + 1;
    }

    public void incrementRow() {
        this.row = 1 + this.row % this.height;
    }

    public void decrement() {
        this.decrement(1);
    }

    public void decrement(int n) {
        if (n < 0) {
            this.increment(-n);
        }
        int n2 = (this.row - 1) * this.width + (this.column - 1);
        n2 = (n2 + this.displaySize - (n %= this.displaySize)) % this.displaySize;
        this.row = n2 / this.width + 1;
        this.column = n2 % this.width + 1;
    }

    public void setColumn(int n) {
        int n2 = n - 1;
        while (n2 < 0) {
            n2 += this.width;
        }
        this.column = (n2 %= this.width) + 1;
    }

    public void setRow(int n) {
        int n2 = n - 1;
        while (n2 < 0) {
            n2 += this.height;
        }
        this.row = (n2 %= this.height) + 1;
    }

    public int toBinary() {
        return (this.row - 1) * this.width + (this.column - 1);
    }
}

