#if defined(__cplusplus)
extern "C" {
#endif
/*     REMARKS. THIS PROGRAM IS THE FIRST INVOKED BY THE 'AC02' */
/*              TRANSACTION.  IT COMPLETES REQUESTS FOR ACCOUNT FILE */
/*              UPDATES (ADDS, MODIFIES, AND DELETES), AFTER THE USER */
/*              ENTERED THE UPDATE INFORMATION. */
#include <stdio.h>
#include <ctype.h>
#include "dfhaid.h"
#include "dfhbmsca.h"
EXEC SQL INCLUDE SQLCA;
EXEC SQL BEGIN DECLARE SECTION;
#include "ACCTSET.h"
#include "ACCTREC.h"

     /*    ACCTREC - ACCOUNT FILE RECORD */
struct new_acctrec_struct {
       char acctdo[6];
       char snamedo[19];
       char fnamedo[13];
       char mido[2];
       char ttldo[5];
       char teldo[11];
       char addr1do[25];
       char addr2do[25];
       char addr3do[25];
       char auth1do[33];
       char auth2do[33];
       char auth3do[33];
       char auth4do[33];
       char cardsdo[2];
       char imodo[3];
       char idaydo[3];
       char iyrdo[3];
       char rsndo[2];
       char ccodedo[2];
       char apprdo[4];
       char scode1do[2];
       char scode2do[2];
       char scode3do[2];
       char statdo[3];
       char limitdo[9];
       struct { 
              char bal[9];
              char bmo[3];
              char bday[3];
              char byr[3];
              char bamt[9];
              char pmo[3];
              char pday[3];
              char pyr[3];
              char pamt[9];
              }    pay_hist[3];
	} ;
struct new_acctrec_struct new_acctrec;
#define NEW_ACCTREC  new_acctrec
#define NEW_ACCTDO   new_acctrec.acctdo
#define NEW_SNAMEDO  new_acctrec.snamedo
#define NEW_FNAMEDO  new_acctrec.fnamedo
#define NEW_MIDO     new_acctrec.mido
#define NEW_TTLDO    new_acctrec.ttldo
#define NEW_TELDO    new_acctrec.teldo
#define NEW_ADDR1DO  new_acctrec.addr1do
#define NEW_ADDR2DO  new_acctrec.addr2do
#define NEW_ADDR3DO  new_acctrec.addr3do
#define NEW_AUTH1DO  new_acctrec.auth1do
#define NEW_AUTH2DO  new_acctrec.auth2do
#define NEW_AUTH3DO  new_acctrec.auth3do
#define NEW_AUTH4DO  new_acctrec.auth4do
#define NEW_CARDSDO  new_acctrec.cardsdo
#define NEW_IMODO    new_acctrec.imodo
#define NEW_IDAYDO   new_acctrec.idaydo
#define NEW_IYRDO    new_acctrec.iyrdo
#define NEW_RSNDO    new_acctrec.rsndo
#define NEW_CCODEDO  new_acctrec.ccodedo
#define NEW_APPRDO   new_acctrec.apprdo
#define NEW_SCODE1DO new_acctrec.scode1do
#define NEW_SCODE2DO new_acctrec.scode2do
#define NEW_SCODE3DO new_acctrec.scode3do
#define NEW_STATDO   new_acctrec.statdo
#define NEW_LIMITDO  new_acctrec.limitdo

#define NEW_PAY_HIST(xx) new_acctrec.pay_hist[xx]
#define NEW_BAL(xx)     new_acctrec.pay_hist[xx].bal
#define NEW_BMO(xx)     new_acctrec.pay_hist[xx].bmo
#define NEW_BDAY(xx)    new_acctrec.pay_hist[xx].bday
#define NEW_BYR(xx)     new_acctrec.pay_hist[xx].byr
#define NEW_BAMT(xx)    new_acctrec.pay_hist[xx].bamt
#define NEW_PMO(xx)     new_acctrec.pay_hist[xx].pmo
#define NEW_PDAY(xx)    new_acctrec.pay_hist[xx].pday
#define NEW_PYR(xx)     new_acctrec.pay_hist[xx].pyr
#define NEW_PAMT(xx)    new_acctrec.pay_hist[xx].pamt

      /*    ACCTREC - ACCOUNT FILE RECORD */
struct old_acctrec_struct {
       char acctdo[6];
       char snamedo[19];
       char fnamedo[13];
       char mido[2];
       char ttldo[5];
       char teldo[11];
       char addr1do[25];
       char addr2do[25];
       char addr3do[25];
       char auth1do[33];
       char auth2do[33];
       char auth3do[33];
       char auth4do[33];
       char cardsdo[2];
       char imodo[3];
       char idaydo[3];
       char iyrdo[3];
       char rsndo[2];
       char ccodedo[2];
       char apprdo[4];
       char scode1do[2];
       char scode2do[2];
       char scode3do[2];
       char statdo[3];
       char limitdo[9];
       struct { 
              char bal[9];
              char bmo[3];
              char bday[3];
              char byr[3];
              char bamt[9];
              char pmo[3];
              char pday[3];
              char pyr[3];
              char pamt[9];
              }    pay_hist[3];
       } ;
struct old_acctrec_struct old_acctrec;
#define OLD_ACCTREC  old_acctrec
#define OLD_ACCTDO   old_acctrec.acctdo
#define OLD_SNAMEDO  old_acctrec.snamedo
#define OLD_FNAMEDO  old_acctrec.fnamedo
#define OLD_MIDO     old_acctrec.mido
#define OLD_TTLDO    old_acctrec.ttldo
#define OLD_TELDO    old_acctrec.teldo
#define OLD_ADDR1DO  old_acctrec.addr1do
#define OLD_ADDR2DO  old_acctrec.addr2do
#define OLD_ADDR3DO  old_acctrec.addr3do
#define OLD_AUTH1DO  old_acctrec.auth1do
#define OLD_AUTH2DO  old_acctrec.auth2do
#define OLD_AUTH3DO  old_acctrec.auth3do
#define OLD_AUTH4DO  old_acctrec.auth4do
#define OLD_CARDSDO  old_acctrec.cardsdo
#define OLD_IMODO    old_acctrec.imodo
#define OLD_IDAYDO   old_acctrec.idaydo
#define OLD_IYRDO    old_acctrec.iyrdo
#define OLD_RSNDO    old_acctrec.rsndo
#define OLD_CCODEDO  old_acctrec.ccodedo
#define OLD_APPRDO   old_acctrec.apprdo
#define OLD_SCODE1DO old_acctrec.scode1do
#define OLD_SCODE2DO old_acctrec.scode2do
#define OLD_SCODE3DO old_acctrec.scode3do
#define OLD_STATDO   old_acctrec.statdo
#define OLD_LIMITDO  old_acctrec.limitdo

#define OLD_PAY_HIST old_acctrec.pay_hist
#define OLD_BAL(xx)     old_acctrec.pay_hist[xx].bal
#define OLD_BMO(xx)     old_acctrec.pay_hist[xx].bmo
#define OLD_BDAY(xx)    old_acctrec.pay_hist[xx].bday
#define OLD_BYR(xx)     old_acctrec.pay_hist[xx].byr
#define OLD_BAMT(xx)    old_acctrec.pay_hist[xx].bamt
#define OLD_PMO(xx)     old_acctrec.pay_hist[xx].pmo
#define OLD_PDAY(xx)    old_acctrec.pay_hist[xx].pday
#define OLD_PYR(xx)     old_acctrec.pay_hist[xx].pyr
#define OLD_PAMT(xx)    old_acctrec.pay_hist[xx].pamt

#include "NEW_ACIXREC.h"    
EXEC SQL END DECLARE SECTION;

#include "OLD_ACIXREC.h"
int yy = 0;
#define MNUI acctmnu.acctmnui
#define MNUO acctmnu.acctmnuo
#define DTLO acctdtl.acctdtlo
#define DTLI acctdtl.acctdtli
           int myresp;
           int myresp2;
	   int my_x;
	   int my_flag;
	   short menu_msgno = 0;
	   short dtl_msgno = 0;
	   short acct_lng = 383;
	   short acix_lng = 63;
	   short dtl_lng = 751;
	   short use_lng = 12;
	   char pay_init[36];
           char all_blnks[256];
#define SPACES all_blnks
/* -------------------------------------- */
	   struct {
		  char use_qid1[3];
		  char use_qid2[5];
		  } use_qid;
#define USE_QID   use_qid
#define USE_QID1  use_qid.use_qid1
#define USE_QID2  use_qid.use_qid2
/* -------------------------------------- */
	   struct {
		  char use_term[4];
		  int use_time;
		  int use_date;
		  } use_rec;
#define USE_REC   use_rec
#define USE_TERM  use_rec.use_term
#define USE_TIME  use_rec.use_time
#define USE_DATE  use_rec.use_date
/* -------------------------------------- */
	   struct {
		  char ixold_sname[12];
		  char ixold_acct[5];
		  } old_ixkey;
#define OLD_IXKEY old_ixkey
#define IXOLD_SNAME old_ixkey.ixold_sname
#define IXOLD_ACCT old_ixkey.ixold_acct

   struct commarea {
		  char reqc;
		  char acctc[5];
		  } ;
   struct commarea *comptr;
#define REQC comptr->reqc
#define ACCTC comptr->acctc


/* MESSAGES DISPLAYED ON MENU SCREEN */
static struct {
         char *txtx;
          } msgx_text[5] =
	{
	{""},
	{"PREVIOUS REQUEST CANCELLED AS REQUESTED                     "},
	{"REQUESTED ADDITION COMPLETED                                "},
	{"REQUESTED MODIFICATION COMPLETED                            "},
	{"REQUESTED DELETION COMPLETED                                "}
	};
#define MNU_MESG msgx_text[menu_msgno].txtx
/* MESSAGES DISPLAYED ON DETAIL SCREEN */
static struct {
         char *txt;
          } msg_text[6] =
	{
	{""},
	{"EITHER ENTER 'Y' TO CONFIRM OR 'CLEAR' TO CANCEL            "},
	{"YOUR REQUEST WAS INTERRUPTED; PLEASE CANCEL AND RETRY       "},
	{"CORRECT HIGHLIGHTED ITEMS (STARS MEAN ITEM REQUIRED)        "},
	{"USE ONLY 'ENTER' (TO PROCEED) OR 'CLEAR' (TO CANCEL)        "},
	{"MAKE SOME ENTRIES AND 'ENTER' OR 'CLEAR' TO CANCEL          "}
	};
#define DTL_MESG msg_text[dtl_msgno].txt

static struct {
	char fil1[25];
	char mod_name[6];
	char mod_tele[5];
	char mod_addr[6];
	char mod_auth[6];
	char mod_card[6];
	char mod_code[5];
	} mod_line;
#define MOD_LINE mod_line
#define MOD_NAME mod_line.mod_name
#define MOD_TELE mod_line.mod_tele
#define MOD_ADDR mod_line.mod_addr
#define MOD_AUTH mod_line.mod_auth
#define MOD_CARD mod_line.mod_card
#define MOD_CODE mod_line.mod_code
static struct {
	char fil1[30];
	char updt_term[4];
	char fil2[6];
	char updt_time[7];
	char fil3[6];
	char updt_date[7];
	} updt_line;
#define UPDT_LINE updt_line
#define UPDT_TERM updt_line.updt_term
#define UPDT_TIME updt_line.updt_time
#define UPDT_DATE updt_line.updt_date
	struct cics_eib *prm1;

#if defined(__STDC__) || defined(__cplusplus)
int is_it_alpha(char *p1,int p2)
#else
int is_it_alpha(p1,p2)
char *p1;
int p2;
#endif
{
	int i;

	for ( i=0; i < p2; i++)
	   {
	   if (!isalpha(*(p1 + i)) && *(p1 +i) != ' ') return(0);
	   }
	return(1);
}
#if defined(__STDC__) || defined(__cplusplus)
int is_it_digit(char *p1,int p2)
#else
int is_it_digit(p1,p2)
char *p1;
int p2;
#endif
{
	int i;

	for ( i=0; i < p2; i++)
	   {
	   if (!isdigit(*(p1 + i)) && *(p1 +i) != ' ') return(0);
	   }
	return(1);
}
int main()
{
    memset ((char *)&old_acctrec, '\0', sizeof(old_acctrec));
    memset ((char *)&new_acctrec, '\0', sizeof(new_acctrec));
    EXEC SQL WHENEVER NOT FOUND goto srch_done;
    EXEC SQL WHENEVER SQLERROR goto srch_done;
    EXEC SQL WHENEVER SQLWARNING goto srch_done;
    memset((char *)&SPACES,' ',sizeof(SPACES));
    memcpy(pay_init,"    0.00000000    0.00000000    0.00",36);
    memset((char *)&MOD_LINE,' ',sizeof(MOD_LINE));
    memcpy(MOD_LINE.fil1,"==========> CHANGES TO:  ",25);
    memset((char *)&UPDT_LINE,' ',sizeof(UPDT_LINE));
    memcpy(UPDT_LINE.fil1,"==========> UPDATED AT TERM:  ",30);
    memcpy(UPDT_LINE.fil2,"  AT  ",6);
    memcpy(UPDT_LINE.fil3,"  ON  ",6);
    memcpy(USE_QID1,"BC0",sizeof(USE_QID1));
    EXEC CICS ADDRESS EIB(prm1) COMMAREA(comptr);
    memset((char *)&DTLI,0,sizeof(DTLI));
    memset((char *)&OLD_ACCTREC,'\0',sizeof(OLD_ACCTREC));
    memset((char *)&NEW_ACCTREC,'\0',sizeof(NEW_ACCTREC));
    memset((char *)&OLD_X_ACIXREC,' ',sizeof(OLD_X_ACIXREC));
    memset((char *)&NEW_X_ACIXREC,' ',sizeof(NEW_X_ACIXREC));
    /* GET INPUT AND BUILD NEW RECORD */
    memcpy (old_acctrec.acctdo, ACCTC, 5);
    old_acctrec.acctdo[5] = '\0';
    EXEC CICS RECEIVE MAP("acctdtl")
		      MAPSET("ACCTSET")
		      RESP(myresp);

    if (myresp == DFHRESP(MAPFAIL)) goto no_map;
    if (REQC != 'A')
       {
/* Commented by dv133961 */
    /*   EXEC CICS READ DATASET("ACCTFIL")  */
    /*		      INTO(OLD_ACCTREC)     */
    /*		      RIDFLD(ACCTC)         */
    /*		      UPDATE                */
    /*		      LENGTH(acct_lng);     */
  EXEC SQL
           SELECT nvl (doacct, ' '), 
                  nvl (dosname, ' '), 
                  nvl (dosfname, ' '),
                  nvl (domi, ' '), 
                  nvl (dottl, ' '),
                  nvl (dotel, ' '),
                  nvl (doaddr1, ' '),
                  nvl (doaddr2, ' '),
                  nvl (doaddr3, ' '),
                  nvl (doauth1, ' '),
                  nvl (doauth2, ' '),
                  nvl (doauth3, ' '),
                  nvl (doauth4, ' '),
                  nvl (docards, ' '),
                  nvl (doimo, ' '),
                  nvl (doiday, ' '),
                  nvl (doiyr, ' '),
                  nvl (dorsn, ' '),
                  nvl (doccode, ' '),
                  nvl (doappr, ' '),
                  nvl (doscode1, ' '),
                  nvl (doscode2, ' '),
                  nvl (dosode3, ' '), 
                  nvl (dostat, ' '),
                  nvl (dolimit, ' ')   
                 INTO :old_acctrec.acctdo, :old_acctrec.snamedo,
                 :old_acctrec.fnamedo,
                 :old_acctrec.mido, :old_acctrec.ttldo,
                 :old_acctrec.teldo, :old_acctrec.addr1do,
                 :old_acctrec.addr2do, :old_acctrec.addr3do,
                 :old_acctrec.auth1do, :old_acctrec.auth2do,
                 :old_acctrec.auth3do, :old_acctrec.auth4do,
                 :old_acctrec.cardsdo, :old_acctrec.imodo,
                 :old_acctrec.idaydo, :old_acctrec.iyrdo,
                 :old_acctrec.rsndo, :old_acctrec.ccodedo,
                 :old_acctrec.apprdo, :old_acctrec.scode1do,
                 :old_acctrec.scode2do, :old_acctrec.scode3do,
                 :old_acctrec.statdo, :old_acctrec.limitdo  
           FROM ACTREC
           WHERE doacct = :old_acctrec.acctdo;  
/* added by dv133961 to set nulls at end of each field 

       old_acctrec.snamedo[sizeof(old_acctrec.snamedo)-1] = '\0';
       old_acctrec.fnamedo[sizeof(old_acctrec.fnamedo)-1] = '\0';
       old_acctrec.ttldo[sizeof(old_acctrec.ttldo)-1] = '\0';
       old_acctrec.teldo[sizeof(old_acctrec.teldo)-1] = '\0';
       old_acctrec.addr1do[sizeof(old_acctrec.addr1do)-1] = '\0';
       old_acctrec.addr2do[sizeof(old_acctrec.addr2do)-1] = '\0';
       old_acctrec.addr3do[sizeof(old_acctrec.addr3do)-1] = '\0';
       old_acctrec.auth1do[sizeof(old_acctrec.auth1do)-1] = '\0';
       old_acctrec.auth2do[sizeof(old_acctrec.auth2do)-1] = '\0';
       old_acctrec.auth3do[sizeof(old_acctrec.auth3do)-1] = '\0';
       old_acctrec.auth4do[sizeof(old_acctrec.auth4do)-1] = '\0';
       old_acctrec.imodo[sizeof(old_acctrec.imodo)-1] = '\0';
       old_acctrec.idaydo[sizeof(old_acctrec.idaydo)-1] = '\0';
       old_acctrec.iyrdo[sizeof(old_acctrec.iyrdo)-1] = '\0';
       old_acctrec.apprdo[sizeof(old_acctrec.apprdo)-1] = '\0';
       old_acctrec.statdo[sizeof(old_acctrec.statdo)-1] = '\0';
       old_acctrec.limitdo[sizeof(old_acctrec.limitdo)-1] = '\0';
    */ 
/* end add   */
       memcpy((char *)&NEW_ACCTREC,(char *)&OLD_ACCTREC,sizeof(OLD_ACCTREC));
       memcpy(IXOLD_SNAME,OLD_SNAMEDO,sizeof(OLD_SNAMEDO));
       memcpy(IXOLD_ACCT,ACCTC,sizeof(ACCTC));
       }
     
    if (REQC == 'X')
       {
       if (DTLI.vfydi == 'Y') goto ck_own;
       else
	  {
	  DTLI.vfydl = -1;
	  DTLO.vfyda = DFHUNIMD;
	  dtl_msgno = 1;
	  goto input_redisplay;
	  }
       }

    if (DTLI.snamedl > 0)
       memcpy(NEW_SNAMEDO,DTLI.snamedi,sizeof(DTLI.snamedi));
    if (DTLI.fnamedl > 0)
       memcpy(NEW_FNAMEDO,DTLI.fnamedi,sizeof(DTLI.fnamedi));
    if (DTLI.midl > 0)
       NEW_MIDO[0] = DTLI.midi;
    if (DTLI.ttldl > 0)
       memcpy(NEW_TTLDO,DTLI.ttldi,sizeof(DTLI.ttldi));
    if (DTLI.teldl > 0)
       memcpy(NEW_TELDO,DTLI.teldi,sizeof(DTLI.teldi));
    if (DTLI.addr1dl > 0)
       memcpy(NEW_ADDR1DO,DTLI.addr1di,sizeof(DTLI.addr1di));
    if (DTLI.addr2dl > 0)
       memcpy(NEW_ADDR2DO,DTLI.addr2di,sizeof(DTLI.addr2di));
    if (DTLI.addr3dl > 0)
       memcpy(NEW_ADDR3DO,DTLI.addr3di,sizeof(DTLI.addr3di));
    if (DTLI.auth1dl > 0)
       memcpy(NEW_AUTH1DO,DTLI.auth1di,sizeof(DTLI.auth1di));
    if (DTLI.auth2dl > 0)
       memcpy(NEW_AUTH2DO,DTLI.auth2di,sizeof(DTLI.auth2di));
    if (DTLI.auth3dl > 0)
       memcpy(NEW_AUTH3DO,DTLI.auth3di,sizeof(DTLI.auth3di));
    if (DTLI.auth4dl > 0)
       memcpy(NEW_AUTH4DO,DTLI.auth4di,sizeof(DTLI.auth4di));
    if (DTLI.cardsdl > 0)
       NEW_CARDSDO[0] = DTLI.cardsdi;
    if (DTLI.imodl > 0)
       memcpy(NEW_IMODO,DTLI.imodi,sizeof(DTLI.imodi));
    if (DTLI.idaydl > 0)
       memcpy(NEW_IDAYDO,DTLI.idaydi,sizeof(DTLI.idaydi));
    if (DTLI.iyrdl > 0)
       memcpy(NEW_IYRDO,DTLI.iyrdi,sizeof(DTLI.iyrdi));
    if (DTLI.rsndl > 0)
       NEW_RSNDO[0] = DTLI.rsndi;
    if (DTLI.ccodedl > 0)
       NEW_CCODEDO[0] = DTLI.ccodedi; 
    if (DTLI.apprdl > 0)
       memcpy(NEW_APPRDO,DTLI.apprdi,sizeof(DTLI.apprdi));
    if (DTLI.scode1dl > 0)
       NEW_SCODE1DO[0] = DTLI.scode1di;
    if (DTLI.scode2dl > 0)
       NEW_SCODE2DO[0] = DTLI.scode2di;
    if (DTLI.scode3dl > 0)
       NEW_SCODE3DO[0] = DTLI.scode3di;

    if (REQC == 'A')
       {
       goto edit_0;
       }

    if (DTLI.snamedf == 0x80)
       memset(NEW_SNAMEDO,' ',sizeof(NEW_SNAMEDO));
    if (DTLI.fnamedf == 0x80)
       memset(NEW_FNAMEDO,' ',sizeof(NEW_FNAMEDO));
    if (DTLI.midf == 0x80)
       memset (NEW_MIDO,  ' ', sizeof(NEW_MIDO));
    if (DTLI.ttldf == 0x80)
       memset(NEW_TTLDO,' ',sizeof(NEW_TTLDO));
    if (DTLI.teldf == 0x80)
       memset(NEW_TELDO,' ',sizeof(NEW_TELDO));
    if (DTLI.addr1df == 0x80)
       memset(NEW_ADDR1DO,' ',sizeof(NEW_ADDR1DO));
    if (DTLI.addr2df == 0x80)
       memset(NEW_ADDR2DO,' ',sizeof(NEW_ADDR2DO));
    if (DTLI.addr3df == 0x80)
       memset(NEW_ADDR3DO,' ',sizeof(NEW_ADDR3DO));
    if (DTLI.auth1df == 0x80)
       memset(NEW_AUTH1DO,' ',sizeof(NEW_AUTH1DO));
    if (DTLI.auth2df == 0x80)
       memset(NEW_AUTH2DO,' ',sizeof(NEW_AUTH2DO));
    if (DTLI.auth3df == 0x80)
       memset(NEW_AUTH3DO,' ',sizeof(NEW_AUTH3DO));
    if (DTLI.auth4df == 0x80)
       memset(NEW_AUTH4DO,' ',sizeof(NEW_AUTH4DO));
    if (DTLI.cardsdf == 0x80)
       memset (NEW_CARDSDO, ' ', sizeof(NEW_CARDSDO));
    if (DTLI.imodf == 0x80)
       memset(NEW_IMODO,' ',sizeof(NEW_IMODO));
    if (DTLI.idaydf == 0x80)
       memset(NEW_IDAYDO,' ',sizeof(NEW_IDAYDO));
    if (DTLI.iyrdf == 0x80)
       memset(NEW_IYRDO,' ',sizeof(NEW_IYRDO));
    if (DTLI.rsndf == 0x80)
       memset (NEW_RSNDO, ' ', sizeof(NEW_RSNDO));
    if (DTLI.ccodedf == 0x80)
       memset (NEW_CCODEDO, ' ', sizeof(NEW_CCODEDO));
    if (DTLI.apprdf == 0x80)
       memset(NEW_APPRDO,' ',sizeof(NEW_APPRDO));
    if (DTLI.scode1df == 0x80)
       memset (NEW_SCODE1DO, ' ', sizeof(NEW_SCODE1DO));
    if (DTLI.scode2df == 0x80)
       memset (NEW_SCODE2DO, ' ', sizeof(NEW_SCODE2DO));
    if (DTLI.scode3df == 0x80)
       memset (NEW_SCODE3DO, ' ', sizeof(NEW_SCODE3DO));

    if (memcmp
       ((char *)&OLD_ACCTREC,(char *)&NEW_ACCTREC,sizeof(NEW_ACCTREC)) == 0)
       {
       dtl_msgno = 5;
       goto input_redisplay;
       }

	/* EDIT INPUT */
edit_0:
    memset((char *)&DTLI,0,sizeof(DTLI));
    if (memcmp((char *)&NEW_SNAMEDO,SPACES,(sizeof(NEW_SNAMEDO)-1)) == 0)
       {
       memset(DTLI.snamedi,'*',sizeof(DTLI.snamedi));
       }
    else
    if (is_it_alpha(NEW_SNAMEDO,(sizeof(NEW_SNAMEDO)-1)))
       {
       goto edit_1;
       }
    DTLO.snameda = DFHUNIMD;
    DTLI.snamedl = -1;

edit_1:
    if (memcmp((char *)&NEW_FNAMEDO,SPACES,(sizeof(NEW_FNAMEDO)-1)) == 0)
       {
       memset(DTLI.fnamedi,'*',sizeof(DTLI.fnamedi));
       }
    else
    if (is_it_alpha(NEW_FNAMEDO,(sizeof(NEW_FNAMEDO)-1)))
       {
       goto edit_2;
       }
    DTLO.fnameda = DFHUNIMD;
    DTLI.fnamedl = -1;

edit_2:
    if ((isalpha(NEW_MIDO[0])) || (isspace(NEW_MIDO[0])) || 
                (NEW_MIDO[0] == '\0'))
       goto edit_2a;
    DTLO.mida = DFHUNIMD;
    DTLI.midl = -1;

edit_2a:
    if (!is_it_alpha(NEW_TTLDO,(sizeof(NEW_TTLDO)-1)))
       {
       DTLO.ttlda = DFHUNIMD;
       DTLI.ttldl = -1;
       }
    if ((memcmp((char *)&NEW_TELDO,SPACES,(sizeof(NEW_TELDO)-1)) != 0) &&
        (!is_it_digit(NEW_TELDO,(sizeof(NEW_TELDO)-1))))
       {
       DTLO.telda = DFHUNIMD;
       DTLI.teldl = -1;
       }
    if (memcmp((char *)&NEW_ADDR1DO,SPACES,(sizeof(NEW_ADDR1DO)-1)) == 0)
       {
       memset(DTLI.addr1di,'*',sizeof(DTLI.addr1di));
       DTLO.addr1da = DFHBMBRY;
       DTLI.addr1dl = -1;
       }
    if (memcmp((char *)&NEW_ADDR2DO,SPACES,(sizeof(NEW_ADDR2DO)-1)) == 0)
       {
       memset(DTLI.addr2di,'*',sizeof(DTLI.addr2di));
       DTLO.addr2da = DFHBMBRY;
       DTLI.addr2dl = -1;
       }

    if (NEW_CARDSDO[0] == ' ')
       {
       NEW_CARDSDO[0] = '*';
       }
    else
    if ((NEW_CARDSDO[0] > '0') && (NEW_CARDSDO[0] <= '9'))
       {
       goto edit_3;
       }

       DTLO.cardsda = DFHUNIMD;
       DTLI.cardsdl = -1;

edit_3:
    if (memcmp((char *)&NEW_IMODO,SPACES,(sizeof(NEW_IMODO)-1)) == 0)
       {
       memset(DTLI.imodi,'*',sizeof(DTLI.imodi));
       }
    else
    if ((is_it_digit(NEW_IMODO,(sizeof(NEW_IMODO)-1))) &&
       ((((int)NEW_IMODO[0] - 0x30) * 10)+ ((int)NEW_IMODO[1] - 0x30) > 0) &&
       ((((int)NEW_IMODO[0] - 0x30) * 10)+ ((int)NEW_IMODO[1] - 0x30) < 13))
       {
       goto edit_4;
       }

       DTLO.imoda = DFHUNIMD;
       DTLI.imodl = -1;

edit_4:
    if (memcmp((char *)&NEW_IDAYDO,SPACES,(sizeof(NEW_IDAYDO)-1)) == 0)
       {
       memset(DTLI.idaydi,'*',sizeof(DTLI.idaydi));
       }
    else
    if ((is_it_digit(NEW_IDAYDO,(sizeof(NEW_IDAYDO)-1))) &&
       ((((int)NEW_IDAYDO[0] - 0x30) * 10)+ ((int)NEW_IDAYDO[1] - 0x30) > 0) &&
       ((((int)NEW_IDAYDO[0] - 0x30) * 10)+ ((int)NEW_IDAYDO[1] - 0x30) < 32))
       {
       goto edit_5;
       }

       DTLO.idayda = DFHUNIMD;
       DTLI.idaydl = -1;
edit_5:
    if (memcmp((char *)&NEW_IYRDO,SPACES,(sizeof(NEW_IYRDO)-1)) == 0)
       {
       memset(DTLI.iyrdi,'*',sizeof(DTLI.iyrdi));
       }
    else
    if (is_it_digit(NEW_IYRDO,(sizeof(NEW_IYRDO)-1))) 
       {
       goto edit_6;
       }
       DTLO.iyrda = DFHUNIMD;
       DTLI.iyrdl = -1;

edit_6:
    if (NEW_RSNDO[0] == ' ')
       {
       NEW_RSNDO[0] = '*';
       }

edit_7:
    if (NEW_CCODEDO[0] == ' ')
       {
       DTLI.ccodedi = '*';
       DTLO.ccodeda = DFHBMBRY;
       DTLI.ccodedl = -1;
       }
    if (memcmp((char *)&NEW_APPRDO,SPACES,(sizeof(NEW_APPRDO)-1)) == 0)
       {
       memset(DTLI.apprdi,'*',sizeof(DTLI.apprdi));
       DTLO.apprda = DFHBMBRY;
       DTLI.apprdl = -1;
       }
    my_flag = 0;
    for (my_x = 0; my_x < sizeof(DTLI); my_x++)
       if ((char)*((char*)&DTLI + my_x) != 0) my_flag = 1;

    if (my_flag)
       {
       dtl_msgno = 3;
       goto input_redisplay;
       }

    if (REQC == 'A')
       {
       memcpy(NEW_ACCTDO,ACCTC,sizeof(NEW_ACCTDO));
       memcpy(NEW_STATDO,"N ",sizeof(NEW_STATDO));
       memcpy(NEW_LIMITDO," 1000.00",sizeof(NEW_LIMITDO));
       memcpy(&NEW_PAY_HIST(0),pay_init,sizeof(pay_init));
       memcpy(&NEW_PAY_HIST(1),pay_init,sizeof(pay_init));
       memcpy(&NEW_PAY_HIST(2),pay_init,sizeof(pay_init));
       }
    memcpy(NEW_X_SNAMEDO,NEW_SNAMEDO,sizeof(NEW_SNAMEDO));
    memcpy(NEW_X_ACCTDO,NEW_ACCTDO,sizeof(NEW_ACCTDO));
    memcpy(NEW_X_FNAMEDO,NEW_FNAMEDO,sizeof(NEW_FNAMEDO));
    NEW_X_MIDO = NEW_MIDO[0];
    memcpy(NEW_X_TTLDO,NEW_TTLDO,sizeof(NEW_TTLDO));
    memcpy(NEW_X_ADDR1DO,NEW_ADDR1DO,sizeof(NEW_ADDR1DO));
    memcpy(NEW_X_STATDO,NEW_STATDO,sizeof(NEW_STATDO));
    memcpy(NEW_X_LIMITDO,NEW_LIMITDO,sizeof(NEW_LIMITDO));

ck_own:
	memcpy(USE_QID2,ACCTC,sizeof(USE_QID2));
	EXEC CICS READQ TS
		  QUEUE(&USE_QID)
		  INTO(&USE_REC)
		  LENGTH(use_lng)
		  ITEM(1)
		  RESP(myresp);
    if (myresp == DFHRESP(LENGERR))
	{
	goto no_own;
	}
    if (myresp == DFHRESP(QIDERR))
	{
	goto no_own;
	}
	if ((memcmp(USE_TERM,prm1->eibtrmid,sizeof(prm1->eibtrmid)) != 0) ||
	    (use_lng != 12)) {
	       goto no_own;
        }
        if ((prm1->eibaid == DFHCLEAR) ||
	    (menu_msgno == 5))  {
	       goto release_acct;
        }
    /* WRITE HARDCOPY LOG RECORDS */
    memset((char *)&DTLO,0,sizeof(DTLO));
    DTLO.histtlda = DFHBMDAR;
    DTLO.stattlda = DFHBMDAR;
    DTLO.statda = DFHBMDAR;
    DTLO.limttlda = DFHBMDAR;
    DTLO.limitda = DFHBMDAR;

    if (REQC == 'A')
       {
       memcpy(DTLO.titledo,"NEW RECORD",10);
       goto log_1;
       }
    memcpy(DTLO.acctdo,OLD_ACCTDO,sizeof(DTLO.acctdo));
    memcpy(DTLO.snamedo,OLD_SNAMEDO,sizeof(DTLO.snamedo));
    memcpy(DTLO.fnamedo,OLD_FNAMEDO,sizeof(DTLO.fnamedo));
    DTLO.mido = OLD_MIDO[0];
    memcpy(DTLO.ttldo,OLD_TTLDO,sizeof(DTLO.ttldo));
    memcpy(DTLO.teldo,OLD_TELDO,sizeof(DTLO.teldo));
    memcpy(DTLO.addr1do,OLD_ADDR1DO,sizeof(DTLO.addr1do));
    memcpy(DTLO.addr2do,OLD_ADDR2DO,sizeof(DTLO.addr2do));
    memcpy(DTLO.addr3do,OLD_ADDR3DO,sizeof(DTLO.addr3do));
    memcpy(DTLO.auth1do,OLD_AUTH1DO,sizeof(DTLO.auth1do));
    memcpy(DTLO.auth2do,OLD_AUTH2DO,sizeof(DTLO.auth2do));
    memcpy(DTLO.auth3do,OLD_AUTH3DO,sizeof(DTLO.auth3do));
    memcpy(DTLO.auth4do,OLD_AUTH4DO,sizeof(DTLO.auth4do));
    DTLO.cardsdo = OLD_CARDSDO[0];
    memcpy(DTLO.imodo,OLD_IMODO,sizeof(DTLO.imodo));
    memcpy(DTLO.idaydo,OLD_IDAYDO,sizeof(DTLO.idaydo));
    memcpy(DTLO.iyrdo,OLD_IYRDO,sizeof(DTLO.iyrdo));
    DTLO.rsndo = OLD_RSNDO[0];
    DTLO.ccodedo = OLD_CCODEDO[0];
    memcpy(DTLO.apprdo,OLD_APPRDO,sizeof(DTLO.apprdo));
    DTLO.scode1do = OLD_SCODE1DO[0];
    DTLO.scode2do = OLD_SCODE2DO[0];
    DTLO.scode3do = OLD_SCODE3DO[0];
    memcpy(DTLO.statdo,OLD_STATDO,sizeof(DTLO.statdo));
    memcpy(DTLO.limitdo,OLD_LIMITDO,sizeof(DTLO.limitdo));

    if (REQC == 'X')
       {
       memcpy(DTLO.titledo,"DELETION  ",10);
       goto log_2;
       }

    memcpy(DTLO.titledo,"BEFORE CHANGE",13);

    if ((memcmp((char *)&NEW_SNAMEDO,OLD_SNAMEDO,sizeof(NEW_SNAMEDO)) != 0) ||
	(memcmp((char *)&NEW_FNAMEDO,OLD_FNAMEDO,sizeof(NEW_FNAMEDO)) != 0) ||
        (memcmp((char *)&NEW_MIDO, OLD_MIDO, sizeof(NEW_MIDO)) !=0) ||
        (memcmp((char *)&NEW_TTLDO,OLD_TTLDO,sizeof(NEW_TTLDO)) != 0))
	{
	memcpy(MOD_NAME,"NAME  ",sizeof(MOD_NAME));
	}

    if (memcmp((char *)&NEW_TELDO,OLD_TELDO,sizeof(NEW_TELDO)) != 0)
	{
	memcpy(MOD_TELE,"TELE ",sizeof(MOD_TELE));
	}

    if ((memcmp((char *)&NEW_ADDR1DO,OLD_ADDR1DO,sizeof(NEW_ADDR1DO)) != 0) ||
	(memcmp((char *)&NEW_ADDR2DO,OLD_ADDR2DO,sizeof(NEW_ADDR2DO)) != 0) ||
        (memcmp((char *)&NEW_ADDR3DO,OLD_ADDR3DO,sizeof(NEW_ADDR3DO)) != 0))
	{
	memcpy(MOD_ADDR,"ADDR  ",sizeof(MOD_ADDR));
	}

    if ((memcmp((char *)&NEW_AUTH1DO,OLD_AUTH1DO,sizeof(NEW_AUTH1DO)) != 0) ||
	(memcmp((char *)&NEW_AUTH2DO,OLD_AUTH2DO,sizeof(NEW_AUTH2DO)) != 0) ||
	(memcmp((char *)&NEW_AUTH3DO,OLD_AUTH3DO,sizeof(NEW_AUTH3DO)) != 0) ||
        (memcmp((char *)&NEW_AUTH4DO,OLD_AUTH4DO,sizeof(NEW_AUTH4DO)) != 0))
	{
	memcpy(MOD_AUTH,"AUTH  ",sizeof(MOD_AUTH));
	}

    if ((NEW_CARDSDO != OLD_CARDSDO)||
	(memcmp((char *)&NEW_IMODO,OLD_IMODO,sizeof(NEW_IMODO))       != 0)||
	(memcmp((char *)&NEW_IDAYDO,OLD_IDAYDO,sizeof(NEW_IDAYDO))    != 0)||
	(memcmp((char *)&NEW_IYRDO,OLD_IYRDO,sizeof(NEW_IYRDO))       != 0)||
	(NEW_RSNDO != OLD_RSNDO)||
	(NEW_CCODEDO != OLD_CCODEDO)||
        (memcmp((char *)&NEW_APPRDO,OLD_APPRDO,sizeof(NEW_APPRDO))    != 0))
	{
	memcpy(MOD_CARD,"CARD  ",sizeof(MOD_CARD));
	}

    if ((NEW_SCODE1DO != OLD_SCODE1DO)||
	(NEW_SCODE2DO != OLD_SCODE2DO)||
        (NEW_SCODE3DO != OLD_SCODE3DO))
	{
	memcpy(MOD_CODE,"CODES",sizeof(MOD_CODE));
	}

    memcpy(DTLO.msgdo,(char *)&MOD_LINE,sizeof(MOD_LINE));
    EXEC CICS WRITEQ TS
	      QUEUE("ACCTLOG")
	      FROM(&DTLO)
	      LENGTH(dtl_lng);
    memcpy(DTLO.titledo,"AFTER CHANGE",12);
log_1:
    memcpy(DTLO.acctdo,NEW_ACCTDO,sizeof(DTLO.acctdo));
    memcpy(DTLO.snamedo,NEW_SNAMEDO,sizeof(DTLO.snamedo));
    memcpy(DTLO.fnamedo,NEW_FNAMEDO,sizeof(DTLO.fnamedo));
    DTLO.mido = NEW_MIDO[0];
    memcpy(DTLO.ttldo,NEW_TTLDO,sizeof(DTLO.ttldo));
    memcpy(DTLO.teldo,NEW_TELDO,sizeof(DTLO.teldo));
    memcpy(DTLO.addr1do,NEW_ADDR1DO,sizeof(DTLO.addr1do));
    memcpy(DTLO.addr2do,NEW_ADDR2DO,sizeof(DTLO.addr2do));
    memcpy(DTLO.addr3do,NEW_ADDR3DO,sizeof(DTLO.addr3do));
    memcpy(DTLO.auth1do,NEW_AUTH1DO,sizeof(DTLO.auth1do));
    memcpy(DTLO.auth2do,NEW_AUTH2DO,sizeof(DTLO.auth2do));
    memcpy(DTLO.auth3do,NEW_AUTH3DO,sizeof(DTLO.auth3do));
    memcpy(DTLO.auth4do,NEW_AUTH4DO,sizeof(DTLO.auth4do));
    DTLO.cardsdo = NEW_CARDSDO[0];
    memcpy(DTLO.imodo,NEW_IMODO,sizeof(DTLO.imodo));
    memcpy(DTLO.idaydo,NEW_IDAYDO,sizeof(DTLO.idaydo));
    memcpy(DTLO.iyrdo,NEW_IYRDO,sizeof(DTLO.iyrdo));
    DTLO.rsndo = NEW_RSNDO[0];
    DTLO.ccodedo = NEW_CCODEDO[0];
    memcpy(DTLO.apprdo,NEW_APPRDO,sizeof(DTLO.apprdo));
    DTLO.scode1do = NEW_SCODE1DO[0];
    DTLO.scode2do = NEW_SCODE2DO[0];
    DTLO.scode3do = NEW_SCODE3DO[0];
    memcpy(DTLO.statdo,NEW_STATDO,sizeof(DTLO.statdo));
    memcpy(DTLO.limitdo,NEW_LIMITDO,sizeof(DTLO.limitdo));
log_2:
    memcpy(UPDT_TERM,prm1->eibtrmid,sizeof(prm1->eibtrmid));
    memcpy(UPDT_TIME,prm1->eibtime,sizeof(prm1->eibtime));
    memcpy(UPDT_DATE,prm1->eibdate,sizeof(prm1->eibdate));
    memcpy(DTLO.msgdo,(char *)&UPDT_LINE,sizeof(UPDT_LINE));
    EXEC CICS WRITEQ TS
	      QUEUE("ACCTLOG")
	      FROM(&DTLO)
	      LENGTH(dtl_lng);
    /* UPDATE THE FILES FOR ADD REQUESTS */
    if (REQC == 'X') goto updt_delete;
    if (REQC == 'M') goto updt_modify;
updt_add:
    menu_msgno = 2;
/* commentec by dv133961 */ 
     /*  EXEC CICS WRITE DATASET("ACCTFIL")  */
	/*	    FROM(NEW_ACCTREC)        */
	/*	    RIDFLD(ACCTC)            */
	/*	    LENGTH(acct_lng);        */
/*    EXEC CICS WRITE DATASET("ACCTIX")      */
/*		    FROM(NEW_X_ACIXREC)      */
/*		    RIDFLD(NEW_X_SNAMEDO)    */
/*		    LENGTH(acix_lng);        */
 /* added by dv133961 to set nulls at end of each field */

       new_acctrec.snamedo[sizeof(new_acctrec.snamedo)-1] = '\0';
       new_acctrec.fnamedo[sizeof(new_acctrec.fnamedo)-1] = '\0';
       new_acctrec.ttldo[sizeof(new_acctrec.ttldo)-1] = '\0';
       new_acctrec.teldo[sizeof(new_acctrec.teldo)-1] = '\0';
       new_acctrec.addr1do[sizeof(new_acctrec.addr1do)-1] = '\0';
       new_acctrec.addr2do[sizeof(new_acctrec.addr2do)-1] = '\0';
       new_acctrec.addr3do[sizeof(new_acctrec.addr3do)-1] = '\0';
       new_acctrec.auth1do[sizeof(new_acctrec.auth1do)-1] = '\0';
       new_acctrec.auth2do[sizeof(new_acctrec.auth2do)-1] = '\0';
       new_acctrec.auth3do[sizeof(new_acctrec.auth3do)-1] = '\0';
       new_acctrec.auth4do[sizeof(new_acctrec.auth4do)-1] = '\0';
       new_acctrec.imodo[sizeof(new_acctrec.imodo)-1] = '\0';
       new_acctrec.idaydo[sizeof(new_acctrec.idaydo)-1] = '\0';
       new_acctrec.iyrdo[sizeof(new_acctrec.iyrdo)-1] = '\0';
       new_acctrec.apprdo[sizeof(new_acctrec.apprdo)-1] = '\0';
       new_acctrec.statdo[sizeof(new_acctrec.statdo)-1] = '\0';
       new_acctrec.limitdo[sizeof(new_acctrec.limitdo)-1] = '\0';
     
/* end add   */
  
 EXEC SQL
                 INSERT INTO ACTREC
                     (DOSNAME, DOSFNAME, DOMI, DOTTL, DOTEL, DOADDR1, 
                      DOADDR2, DOADDR3, DOAUTH1, DOAUTH2, DOAUTH3, 
                      DOAUTH4, DOCARDS, DOIMO, DOIDAY, DOIYR,
                      DORSN, DOCCODE, DOAPPR, DOSCODE1, DOSCODE2,
		      DOSODE3, DOSTAT, DOLIMIT, DOACCT)
                   VALUES
                     (:new_acctrec.snamedo,
                      :new_acctrec.fnamedo,
                      :new_acctrec.mido,
                      :new_acctrec.ttldo,
                      :new_acctrec.teldo,
                      :new_acctrec.addr1do,
                      :new_acctrec.addr2do,
                      :new_acctrec.addr3do,
                      :new_acctrec.auth1do,
                      :new_acctrec.auth2do,
                      :new_acctrec.auth3do,
                      :new_acctrec.auth4do,
                      :new_acctrec.cardsdo,
                      :new_acctrec.imodo,
                      :new_acctrec.idaydo,
                      :new_acctrec.iyrdo,
                      :new_acctrec.rsndo,
                      :new_acctrec.ccodedo,
                      :new_acctrec.apprdo,
                      :new_acctrec.scode1do,
                      :new_acctrec.scode2do,
                      :new_acctrec.scode3do,
                      :new_acctrec.statdo,
                      :new_acctrec.limitdo,
                      :old_acctrec.acctdo);
    goto release_acct;

updt_modify:
    menu_msgno = 3;
/* commented by dv133961 */
/*    EXEC CICS REWRITE DATASET("ACCTFIL")   */
/*		    FROM(NEW_ACCTREC)      */
/*		    LENGTH(acct_lng);      */

/*  if (memcmp((char *)&NEW_SNAMEDO,OLD_SNAMEDO,sizeof(NEW_SNAMEDO)) != 0)  */
/*      {   */
/*         EXEC CICS DELETE DATASET("ACCTIX")      */
/*		     RIDFLD(OLD_IXKEY);        */
/*      EXEC CICS WRITE DATASET("ACCTIX")       */
/*		    FROM(NEW_X_ACIXREC)        */
/*		    RIDFLD(NEW_X_SNAMEDO)      */
/*		    LENGTH(acix_lng);          */
/*      }   */
/*   else  */
/*    if ((memcmp((char *)&NEW_FNAMEDO,OLD_FNAMEDO,sizeof(NEW_FNAMEDO)) != 0) ||  */
/*        (NEW_MIDO != OLD_MIDO) ||  */
/*        (memcmp((char *)&NEW_TTLDO,OLD_TTLDO,sizeof(NEW_TTLDO)) != 0) ||  */
/*        (memcmp((char *)&NEW_ADDR1DO,OLD_ADDR1DO,sizeof(NEW_ADDR1DO)) != 0))  */
/*       {  */
/*       EXEC CICS READ DATASET("ACCTIX")         */
/*		      INTO(OLD_X_ACIXREC)         */
/*		      RIDFLD(OLD_IXKEY)           */
/*		      UPDATE                      */
/*		      LENGTH(acix_lng);           */
/*       EXEC CICS REWRITE DATASET("ACCTIX")      */
/*		      FROM(NEW_X_ACIXREC)         */
/*		      LENGTH(acix_lng);           */
/*   end comment     */
old_acctrec.acctdo[5] = '\0';
 /* added by dv133961 to set nulls at end of each field */

       new_acctrec.snamedo[sizeof(new_acctrec.snamedo)-1] = '\0';
       new_acctrec.fnamedo[sizeof(new_acctrec.fnamedo)-1] = '\0';
       new_acctrec.ttldo[sizeof(new_acctrec.ttldo)-1] = '\0';
       new_acctrec.teldo[sizeof(new_acctrec.teldo)-1] = '\0';
       new_acctrec.addr1do[sizeof(new_acctrec.addr1do)-1] = '\0';
       new_acctrec.addr2do[sizeof(new_acctrec.addr2do)-1] = '\0';
       new_acctrec.addr3do[sizeof(new_acctrec.addr3do)-1] = '\0';
       new_acctrec.auth1do[sizeof(new_acctrec.auth1do)-1] = '\0';
       new_acctrec.auth2do[sizeof(new_acctrec.auth2do)-1] = '\0';
       new_acctrec.auth3do[sizeof(new_acctrec.auth3do)-1] = '\0';
       new_acctrec.auth4do[sizeof(new_acctrec.auth4do)-1] = '\0';
       new_acctrec.imodo[sizeof(new_acctrec.imodo)-1] = '\0';
       new_acctrec.idaydo[sizeof(new_acctrec.idaydo)-1] = '\0';
       new_acctrec.iyrdo[sizeof(new_acctrec.iyrdo)-1] = '\0';
       new_acctrec.apprdo[sizeof(new_acctrec.apprdo)-1] = '\0';
       new_acctrec.statdo[sizeof(new_acctrec.statdo)-1] = '\0';
       new_acctrec.limitdo[sizeof(new_acctrec.limitdo)-1] = '\0';
     
/* end add   */

EXEC SQL
                 UPDATE ACTREC
                 SET DOSNAME = :new_acctrec.snamedo,
                     DOSFNAME = :new_acctrec.fnamedo,
                     DOMI = :new_acctrec.mido,
                     DOTTL = :new_acctrec.ttldo,
                     DOTEL = :new_acctrec.teldo,
                     DOADDR1 = :new_acctrec.addr1do,
                     DOADDR2 = :new_acctrec.addr2do,
                     DOADDR3 = :new_acctrec.addr3do,
                     DOAUTH1 = :new_acctrec.auth1do,
                     DOAUTH2 = :new_acctrec.auth2do,
                     DOAUTH3 = :new_acctrec.auth3do,
                     DOAUTH4 = :new_acctrec.auth4do,
                     DOCARDS = :new_acctrec.cardsdo,
                     DOIMO   = :new_acctrec.imodo,
                     DOIDAY  = :new_acctrec.idaydo,
                     DOIYR  = :new_acctrec.iyrdo,
                     DORSN   = :new_acctrec.rsndo,
                     DOCCODE = :new_acctrec.ccodedo,
                     DOAPPR = :new_acctrec.apprdo,
                     DOSCODE1 = :new_acctrec.scode1do,
                     DOSCODE2 = :new_acctrec.scode2do,
                     DOSODE3 = :new_acctrec.scode3do,
                     DOSTAT  = :new_acctrec.statdo,
                     DOLIMIT  = :new_acctrec.limitdo 
                 WHERE DOACCT = :old_acctrec.acctdo;
    goto release_acct;
updt_delete:
    menu_msgno = 4;
/*  commented by dv133961    */
/*  EXEC CICS DELETE DATASET("ACCTFIL");        */
/*  EXEC CICS DELETE DATASET("ACCTIX")          */
/*		     RIDFLD(OLD_IXKEY);         */
/*  end comment                                 */
    old_acctrec.acctdo[5] = '\0';
    EXEC SQL DELETE ACTREC 
		where DOACCT = :old_acctrec.acctdo;
/* RELEASE OWNERSHIP OF ACCOUNT NUMBER */
release_acct:
    EXEC CICS DELETEQ TS
	      QUEUE(USE_QID);

menu_refresh:
    /* SEND MENU MAP BACK TO TERMINAL */
    memset((char *)&MNUO,0,sizeof(MNUO));
    memcpy((char *)&MNUO.msgmo,MNU_MESG,strlen(MNU_MESG));
    EXEC CICS SEND MAP("acctmnu")
		   MAPSET("acctset")
		   ERASE
		   FREEKB;
   EXEC CICS RETURN
	     TRANSID("AC01");
input_redisplay:
    /* FOR INPUT ERRORS, RESEND DETAIL MAP */
    memcpy(DTLO.msgdo,DTL_MESG,strlen(DTL_MESG));
    if ((dtl_msgno == 2) || (dtl_msgno == 4) || (dtl_msgno == 5))
       DTLI.snamedl = -1;

    EXEC CICS SEND MAP("acctdtl")
		   MAPSET("ACCTSET")
		   DATAONLY
		   CURSOR
		   FREEKB;
   EXEC CICS RETURN
	     TRANSID("AC02")
	     COMMAREA(*comptr)
	     LENGTH(6);
no_own:
    /* PROCESSING FOR RECOVERABLE ERRORS */
    if ((prm1->eibaid == DFHCLEAR) || (menu_msgno == 5)) goto menu_refresh;
    dtl_msgno = 2;
    goto input_redisplay;
no_map:
    if (prm1->eibaid == DFHENTER)
       {
       dtl_msgno = 5;
       goto input_redisplay;
       }
    menu_msgno = 5;
    goto ck_own;
no_good:
pa_key:
    dtl_msgno = 4;
    goto input_redisplay;
srch_done:
yy = 0;
}
#if defined(__cplusplus)
}
#endif
