package scouser;

import javax.jms.*;
import com.ibm.cics.server.Program;
import com.sun.emp.mtp.util.*;

public class GetAliasJMSListener implements MessageListener
{
	byte[]  buf2 = new byte[80];
	char inline[] = null;
	int length = 0;
	String name = null;

	public void onMessage(Message message)
	{
	try     {
		if (message instanceof BytesMessage) {

		// BytesMessage Format:
		// Created by the 'kixmqtst' queue loading program
		do {
                   length = ((BytesMessage)message).readBytes(buf2);
                   if (length != -1)    
		      {
		      inline = new char[length];
                      for (int i = 0; i < length; i++) {
                        inline[i] = (char)buf2[i];
                        }
                      }
                   } while (length >= 80);
		name = String.copyValueOf(inline);
		}
		else if (message instanceof TextMessage) {

		// TextMessage Format:
		// Created by the 'amqsputc' queue loading program
		name = ((TextMessage)message).getText();
		}
  
		// The following code prepares a COMMAREA with
		// name and passes it on a JCICS A.P.I. link
		// to another program that will find and return
		// the corresponding alias

		Program theProgram = new Program();
		theProgram.setName("JMQGTAL");	// = DPL version of GetAlias
		GetAliasCommAreaRecord ca = new GetAliasCommAreaRecord();
		
		// populate the COMMAREA with the name to lookup
		ca.CA.setValue("name", name);
		
		// Do the JCICS api link
		theProgram.link( ca );

		// retrieve alias from the COMMAREA
		String alias = ca.CA.getValue("alias").trim();	
		String msg = "Alias for " + name + " = " + alias;

		// Output the message to the log
		Log.setName("GetAliasJMSListener");
		Log.kxprte(msg);
		} catch (JMSException e) {e.printStackTrace();}
		  catch (Exception e) {e.printStackTrace();}
	}	
}
