/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/


/* $Date:   21 Sep 2001 19:02:42  $ */
/* $Modtime:   21 Sep 2001 17:11:12  $ */

/* $Workfile:   kixmqerr.c  $ $Revision:   1.0  $ */

/*
 * $Log:   /unikix/source2/NEW80/unikixsrc/test/mq/cobol/PVCS/kixmqerr.c_v  $
 * 
 *    Rev 1.0   21 Sep 2001 19:02:42   unikix
 * Initial 8.0
 * 
 *    Rev 1.0   30 Jan 2000 11:45:20   unikix
 * Initial 7.0
 * 
 *    Rev 1.0   15 Mar 1999 19:57:50   unikix
 * Initial 6.0
 * 
 *    Rev 1.0   05/22/97 17:10:52   unikix
 * Initial 5.1
 * 
 *    Rev 1.0   08/26/96 16:32:00   rick
 * Initial revision.
*/

#include <stdio.h>
#include <cmqc.h>
#include "kixmqerr.h"

/************************************************************************/
/* There are 3 sets of reason strings for 3 the different number	*/
/* ranges that MQSeries errors can be					*/
/************************************************************************/
static char *ReasonStrings0[]=
{
    "MQRC_NONE"
};



static char *ReasonStrings1[]=
{
    "*** Empty ***",
    "MQRC_ALIAS_BASE_Q_TYPE_ERROR",
    "MQRC_ALREADY_CONNECTED",
    "MQRC_BACKED_OUT",
    "MQRC_BUFFER_ERROR",
    "MQRC_BUFFER_LENGTH_ERROR",
    "MQRC_CHAR_ATTR_LENGTH_ERROR",
    "MQRC_CHAR_ATTRS_ERROR",
    "MQRC_CHAR_ATTRS_TOO_SHORT",
    "MQRC_CONNECTION_BROKEN",
    "MQRC_DATA_LENGTH_ERROR",
    "MQRC_DYNAMIC_Q_NAME_ERROR",
    "MQRC_ENVIRONMENT_ERROR",
    "MQRC_EXPIRY_ERROR",
    "MQRC_FEEDBACK_ERROR",
    "*** Empty ***",
    "MQRC_GET_INHIBITED",
    "MQRC_HANDLE_NOT_AVAILABLE",
    "MQRC_HCONN_ERROR",
    "MQRC_HOBJ_ERROR",
    "MQRC_INHIBIT_VALUE_ERROR",
    "MQRC_INT_ATTR_COUNT_ERROR",
    "MQRC_INT_ATTR_COUNT_TOO_SMALL",
    "MQRC_INT_ATTRS_ARRAY_ERROR",
    "MQRC_SYNCPOINT_LIMIT_REACHED",
    "MQRC_MAX_CONNS_LIMIT_REACHED",
    "MQRC_MD_ERROR",
    "MQRC_MISSING_REPLY_TO_Q",
    "*** Empty ***",
    "MQRC_MSG_TYPE_ERROR",
    "MQRC_MSG_TOO_BIG_FOR_Q",
    "MQRC_MSG_TOO_BIG_FOR_Q_MGR",
    "*** Empty ***",
    "MQRC_NO_MSG_AVAILABLE",
    "MQRC_NO_MSG_UNDER_CURSOR",
    "MQRC_NOT_AUTHORIZED",
    "MQRC_NOT_OPEN_FOR_BROWSE",
    "MQRC_NOT_OPEN_FOR_INPUT",
    "MQRC_NOT_OPEN_FOR_INQUIRE",
    "MQRC_NOT_OPEN_FOR_OUTPUT",
    "MQRC_NOT_OPEN_FOR_SET",
    "MQRC_OBJECT_CHANGED",
    "MQRC_OBJECT_IN_USE",
    "MQRC_OBJECT_TYPE_ERROR",
    "MQRC_OD_ERROR",
    "MQRC_OPTION_NOT_VALID_FOR_TYPE",
    "MQRC_OPTIONS_ERROR",
    "MQRC_PERSISTENCE_ERROR",
    "MQRC_PERSISTENT_NOT_ALLOWED",
    "MQRC_PRIORITY_EXCEEDS_MAXIMUM",
    "MQRC_PRIORITY_ERROR",
    "MQRC_PUT_INHIBITED",
    "MQRC_Q_DELETED",
    "MQRC_Q_FULL",
    "*** Empty ***",
    "MQRC_Q_NOT_EMPTY",
    "MQRC_Q_SPACE_NOT_AVAILABLE",
    "MQRC_Q_TYPE_ERROR",
    "MQRC_Q_MGR_NAME_ERROR",
    "MQRC_Q_MGR_NOT_AVAILABLE",
    "*** Empty ***",
    "MQRC_REPORT_OPTIONS_ERROR",
    "*** Empty ***",
    "MQRC_SECURITY_ERROR",
    "*** Empty ***",
    "MQRC_SELECTOR_COUNT_ERROR",
    "MQRC_SELECTOR_LIMIT_EXCEEDED",
    "MQRC_SELECTOR_ERROR",
    "MQRC_SELECTOR_NOT_FOR_TYPE",
    "MQRC_SIGNAL_OUTSTANDING",
    "MQRC_SIGNAL_REQUEST_ACCEPTED",
    "MQRC_STORAGE_NOT_AVAILABLE",
    "MQRC_SYNCPOINT_NOT_AVAILABLE",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_TRIGGER_CONTROL_ERROR",
    "MQRC_TRIGGER_DEPTH_ERROR",
    "MQRC_TRIGGER_MSG_PRIORITY_ERR",
    "MQRC_TRIGGER_TYPE_ERROR",
    "MQRC_TRUNCATED_MSG_ACCEPTED",
    "MQRC_TRUNCATED_MSG_FAILED",
    "*** Empty ***",
    "MQRC_UNKNOWN_ALIAS_BASE_Q",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_UNKNOWN_OBJECT_NAME",
    "MQRC_UNKNOWN_OBJECT_Q_MGR",
    "MQRC_UNKNOWN_REMOTE_Q_MGR",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_WAIT_INTERVAL_ERROR",
    "MQRC_XMIT_Q_TYPE_ERROR",
    "MQRC_XMIT_Q_USAGE_ERROR",
    "MQRC_NOT_OPEN_FOR_PASS_ALL",
    "MQRC_NOT_OPEN_FOR_PASS_IDENT",
    "MQRC_NOT_OPEN_FOR_SET_ALL",
    "MQRC_NOT_OPEN_FOR_SET_IDENT",
    "MQRC_CONTEXT_HANDLE_ERROR",
    "MQRC_CONTEXT_NOT_AVAILABLE",
    "MQRC_SIGNAL1_ERROR",
    "MQRC_OBJECT_ALREADY_EXISTS",
    "MQRC_OBJECT_DAMAGED",
    "MQRC_RESOURCE_PROBLEM",
    "MQRC_ANOTHER_Q_MGR_CONNECTED",
    "MQRC_UNKNOWN_REPORT_OPTION",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_FORMAT_ERROR",
    "MQRC_SOURCE_CCSID_ERROR",
    "MQRC_SOURCE_INTEGER_ENC_ERROR",
    "MQRC_SOURCE_DECIMAL_ENC_ERROR",
    "MQRC_SOURCE_FLOAT_ENC_ERROR",
    "MQRC_TARGET_CCSID_ERROR",
    "MQRC_TARGET_INTEGER_ENC_ERROR",
    "MQRC_TARGET_DECIMAL_ENC_ERROR",
    "MQRC_TARGET_FLOAT_ENC_ERROR",
    "MQRC_NOT_CONVERTED",
    "MQRC_CONVERTED_MSG_TOO_BIG",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_ADAPTER_STORAGE_SHORTAGE",
    "*** Empty ***",
    "MQRC_ADAPTER_CONN_LOAD_ERROR",
    "MQRC_ADAPTER_SERV_LOAD_ERROR",
    "MQRC_ADAPTER_DEFS_ERROR",
    "MQRC_ADAPTER_DEFS_LOAD_ERROR",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_ADAPTER_DISC_LOAD_ERROR",
    "*** Empty ***",
    "MQRC_CICS_WAIT_FAILED",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_SOURCE_LENGTH_ERROR",
    "MQRC_TARGET_LENGTH_ERROR",
    "MQRC_SOURCE_BUFFER_ERROR",
    "MQRC_TARGET_BUFFER_ERROR",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_DBCS_ERROR",
    "MQRC_TRUNCATED",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_ASID_MISMATCH",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_CONN_ID_IN_USE",
    "MQRC_Q_MGR_QUIESCING",
    "MQRC_Q_MGR_STOPPING",
    "MQRC_DUPLICATE_RECOV_COORD",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_PMO_ERROR",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_API_EXIT_NOT_FOUND",
    "MQRC_API_EXIT_LOAD_ERROR",
    "MQRC_REMOTE_Q_NAME_ERROR",
    "*** Empty ***",
    "MQRC_GMO_ERROR",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_PAGESET_FULL",
    "MQRC_PAGESET_ERROR",
    "MQRC_NAME_NOT_VALID_FOR_TYPE",
    "MQRC_UNEXPECTED_ERROR",
    "MQRC_UNKNOWN_XMIT_Q",
    "MQRC_UNKNOWN_DEF_XMIT_Q",
    "MQRC_DEF_XMIT_Q_TYPE_ERROR",
    "MQRC_DEF_XMIT_Q_USAGE_ERROR",
    "*** Empty ***",
    "MQRC_NAME_IN_USE",
    "MQRC_CONNECTION_QUIESCING",
    "MQRC_CONNECTION_STOPPING",
    "MQRC_ADAPTER_NOT_AVAILABLE",
    "*** Empty ***",
    "MQRC_MSG_ID_ERROR",
    "MQRC_CORREL_ID_ERROR",
    "MQRC_FILE_SYSTEM_ERROR",
    "MQRC_NO_MSG_LOCKED",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "*** Empty ***",
    "MQRC_CONNECTION_NOT_AUTHORIZED",
    "MQRC_MSG_TOO_BIG_FOR_CHANNEL",
    "MQRC_CALL_IN_PROGRESS",
    "*** Empty ***",
    "MQRC_Q_MGR_CHANGE",
    "MQRC_Q_MGR_ACTIVE",
    "MQRC_Q_MGR_NOT_ACTIVE",
    "MQRC_Q_DEPTH_HIGH",
    "MQRC_Q_DEPTH_LOW",
    "MQRC_Q_SERVICE_INTERVAL_HIGH",
    "MQRC_Q_SERVICE_INTERVAL_OK",
    "MQRC_CHANNEL_NOT_AVAILABLE",
    "MQRC_CHANNEL_EXIT_FAIL",
    "MQRC_CHANNEL_ERROR"
};



static char *ReasonStrings2[]=
{
    "MQRC_HCONFIG_ERROR",
    "MQRC_FUNCTION_ERROR",
    "MQRC_CHANNEL_STARTED",
    "MQRC_CHANNEL_STOPPED",
    "MQRC_CHANNEL_CONV_ERROR",
    "MQRC_SERVICE_NOT_AVAILABLE",
    "MQRC_INITIALIZATION_FAILED",
    "MQRC_TERMINATION_FAILED",
    "MQRC_UNKNOWN_Q_NAME",
    "MQRC_SERVICE_ERROR",
    "MQRC_Q_ALREADY_EXISTS",
    "MQRC_USER_ID_NOT_AVAILABLE"
};

/************************************************************************/
/* ReasonToString() - This function converts an MQSeries Reason code	*/
/*		      into a printable string.				*/
/************************************************************************/
#ifdef __STDC__
char *ReasonToString( MQLONG Reason )
#else
char *ReasonToString( Reason )
MQLONG Reason;
#endif
{
    char *Str;			/* The return value			*/

    if ( Reason<2000 )
    {
	Str=ReasonStrings0[Reason];
    }
    else if ( Reason<2280 )
    {
	Str=ReasonStrings1[Reason-2000];
    }
    else
    {
	Str=ReasonStrings2[Reason-2280];
    }
    return(Str);
}
