/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.ipc;

import com.sun.emp.mtp.util.Constants;
import com.sun.emp.mtp.util.Log;
import com.sun.emp.mtp.util.Permission;

public class MessageQueue
implements Constants {
    private int msqid;

    public synchronized boolean create(String string, int n, Permission permission, boolean bl) {
        this.msqid = this.open(string, n, permission.getUser(), permission.getGroup(), permission.getOther(), true, bl);
        if (this.msqid == -1) {
            Log.kxerrorstr3(4575, 1, "MessageQueue[create]", n + "", string, permission.toString());
            return false;
        }
        return true;
    }

    public synchronized boolean open(String string, int n, Permission permission) {
        this.msqid = this.open(string, n, permission.getUser(), permission.getGroup(), permission.getOther(), false, false);
        if (this.msqid == -1) {
            if (n != 6) {
                Log.kxerrorstr3(4575, 1, "MessageQueue[open]", n + "", string, permission.toString());
            } else {
                System.out.println("*** MessageQueue[open] Failed to open print queue, path=" + string + ", perm=" + permission.toString());
            }
            return false;
        }
        return true;
    }

    public synchronized int receive(byte[] byArray, int n, boolean bl) {
        if (this.msqid <= 0) {
            Log.kxerror(4578, 1, "MessageQueue[receive]");
            return -1;
        }
        int n2 = this.receive(this.msqid, byArray, n, bl);
        if (n2 == -1) {
            Log.kxerror2str(4576, 1, "MessageQueue[receive]", bl + "", this.msqid, n);
            return -1;
        }
        return n2;
    }

    public synchronized boolean send(byte[] byArray, boolean bl) {
        if (this.msqid <= 0) {
            Log.kxerror(4578, 1, "MessageQueue[send]");
            return false;
        }
        if (!this.send(this.msqid, byArray, bl)) {
            Log.kxerror1str(4577, 1, "MessageQueue[send]", bl + "", this.msqid);
            return false;
        }
        return true;
    }

    public synchronized boolean destroy() {
        if (this.msqid <= 0) {
            Log.kxerror(4578, 1, "MessageQueue[destroy]");
            return false;
        }
        if (!this.destroy(this.msqid)) {
            Log.kxerror1(4579, 1, "MessageQueue[destroy]", this.msqid);
            return false;
        }
        this.msqid = 0;
        return true;
    }

    private native int open(String var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    private native int receive(int var1, byte[] var2, int var3, boolean var4);

    private native boolean send(int var1, byte[] var2, boolean var3);

    private native boolean destroy(int var1);

    static {
        System.loadLibrary("ipc");
    }
}

