/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.RegionPerformanceData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class RegionPerformance
extends BaseMBean {
    public RegionPerformance(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new RegionPerformanceData());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("txTotal", "Total number of transactions executed"));
        treeSet.add(new TMonitorAttribute("txRate", "Current transaction rate per second"));
        treeSet.add(new TMonitorAttribute("txMaxRate", "Peak transaction rate per second"));
        treeSet.add(new TMonitorAttribute("txAbort", "Total number of transactions aborted"));
        treeSet.add(new TMonitorAttribute("txWaiting", "Current number of transactions waiting to be processed"));
        treeSet.add(new TMonitorAttribute("txMaxWaiting", "Maximum number of transactions forced to wait for a transaction processor"));
        treeSet.add(new TMonitorAttribute("txDeadlock", "Total number of transactions that encountered a deadlock"));
        treeSet.add(new TMonitorAttribute("serverRestarts", "Total number of transaction processor restarts"));
        treeSet.add(new TMonitorAttribute("txStartsWaiting", "Current number of transaction START requests waiting"));
        treeSet.add(new TMonitorAttribute("txSystemProcessorTime", "Total system processor (CPU) time for all transaction processors (secs)"));
        treeSet.add(new TMonitorAttribute("txUserProcessorTime", "Total user processor (CPU) time for all transaction processors (secs)"));
        treeSet.add(new TMonitorAttribute("numUsersLoggedOn", "Current number of users connected to the region"));
        treeSet.add(new TMonitorAttribute("memSize", "Size of region shared memory segment (K)"));
        treeSet.add(new TMonitorAttribute("activeTransactions", "Active Transaction Information"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("txServers", "Total number of transaction processors configured at the region", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTxTotal() {
        return ((RegionPerformanceData)this.getData()).txTotal;
    }

    public float getTxRate() {
        return ((RegionPerformanceData)this.getData()).txRate;
    }

    public float getTxMaxRate() {
        return ((RegionPerformanceData)this.getData()).txMaxRate;
    }

    public int getTxAbort() {
        return ((RegionPerformanceData)this.getData()).txAbort;
    }

    public int getTxWaiting() {
        return ((RegionPerformanceData)this.getData()).txWaiting;
    }

    public int getTxMaxWaiting() {
        return ((RegionPerformanceData)this.getData()).txMaxWaiting;
    }

    public int getTxDeadlock() {
        return ((RegionPerformanceData)this.getData()).txDeadlock;
    }

    public int getServerRestarts() {
        return ((RegionPerformanceData)this.getData()).serverRestarts;
    }

    public int getTxStartsWaiting() {
        return ((RegionPerformanceData)this.getData()).txStartsWaiting;
    }

    public int getTxSystemProcessorTime() {
        return ((RegionPerformanceData)this.getData()).txSystemProcessorTime;
    }

    public int getTxUserProcessorTime() {
        return ((RegionPerformanceData)this.getData()).txUserProcessorTime;
    }

    public int getNumUsersLoggedOn() {
        return ((RegionPerformanceData)this.getData()).numUsersLoggedOn;
    }

    public int getMemSize() {
        return ((RegionPerformanceData)this.getData()).memSize / 1024;
    }

    public RegionPerformanceData.TransactionPerformanceData[] getActiveTransactions() {
        return ((RegionPerformanceData)this.getData()).activeTransactions;
    }

    public short getTxServers() {
        return ((RegionPerformanceData)this.getData()).txServers;
    }
}

