/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.jcics;

import com.sun.emp.mtp.jcics.ByteAreaElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ByteAreaLayout {
    private Hashtable byteAreaHashtable = new Hashtable();
    private Vector byteAreaVector = new Vector();
    private int iByteAreaLength;
    private byte[] bByteArea;
    private boolean bDebug = false;

    public ByteAreaLayout(String[] stringArray, byte[] byArray) {
        this.printMsg("Creating byte area layout, was given a byte area");
        this.parseByteLayout(stringArray);
        if (byArray.length != this.iByteAreaLength) {
            System.out.println("The byte area length does not match the specified layout");
        }
        this.bByteArea = byArray;
    }

    public ByteAreaLayout(String[] stringArray) {
        this.printMsg("Creating a byte area layout, will create the byte area");
        this.parseByteLayout(stringArray);
        this.printMsg("Getting new byte area");
        this.bByteArea = new byte[this.iByteAreaLength];
        this.printMsg("Setting default values");
        this.resetToDefaultValues();
    }

    private void printMsg(String string) {
        if (this.bDebug) {
            System.out.println(string);
        }
    }

    private void parseByteLayout(String[] stringArray) {
        this.printMsg("Parsing byte area layout description");
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        do {
            String string;
            if (!(string = stringArray[n]).equals("END-OF-ITEMS")) {
                this.byteAreaVector.addElement(string);
                int n3 = Integer.valueOf(stringArray[n + 2]);
                this.byteAreaHashtable.put(string, new ByteAreaElement(string, stringArray[n + 1], n3, stringArray[n + 3], n2));
                n += 4;
                n2 += n3;
                continue;
            }
            bl = false;
        } while (bl);
        this.iByteAreaLength = n2;
        this.byteAreaVector.trimToSize();
    }

    public String toString() {
        System.out.println("ByteArea length = " + this.iByteAreaLength);
        Enumeration enumeration = this.byteAreaVector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(((ByteAreaElement)this.byteAreaHashtable.get(enumeration.nextElement())).toString(this.bByteArea));
        }
        return "";
    }

    public void resetToDefaultValues() {
        this.printMsg("Reseting Default values");
        Enumeration enumeration = this.byteAreaVector.elements();
        while (enumeration.hasMoreElements()) {
            ((ByteAreaElement)this.byteAreaHashtable.get(enumeration.nextElement())).setToDefaultValue(this.bByteArea);
        }
    }

    public byte[] theByteArea() {
        this.printMsg("Returning a reference to the byte area");
        return this.bByteArea;
    }

    public void resetByteAreaValues(byte[] byArray) {
        int n;
        this.printMsg("Will copy byte area specified to my byte area");
        if (byArray.length != this.iByteAreaLength) {
            System.out.println("The supplied byte area length is different than layout");
            System.out.println("The supplied byte area length=" + byArray.length + ", the ByteArea length=" + this.iByteAreaLength);
        }
        if (this.iByteAreaLength < (n = byArray.length)) {
            n = this.iByteAreaLength;
        }
        int n2 = 0;
        while (n2 < n) {
            this.bByteArea[n2] = byArray[n2];
            ++n2;
        }
    }

    public int getLength() {
        this.printMsg("The length of the entire byte area layout is " + this.iByteAreaLength);
        return this.iByteAreaLength;
    }

    public int getLength(String string) {
        this.printMsg("Getting the length for " + string);
        return ((ByteAreaElement)this.byteAreaHashtable.get(string)).getLength();
    }

    public int getIValue(String string) {
        this.printMsg("Getting the integer value for " + string);
        return ((ByteAreaElement)this.byteAreaHashtable.get(string)).getIValue(this.bByteArea);
    }

    public String getValue(String string) {
        this.printMsg("Getting the string value for " + string);
        return ((ByteAreaElement)this.byteAreaHashtable.get(string)).getValue(this.bByteArea);
    }

    public byte[] getByteValue(String string) {
        this.printMsg("Getting the byte value for " + string);
        return ((ByteAreaElement)this.byteAreaHashtable.get(string)).getByteValue(this.bByteArea);
    }

    public int getDisplacement(String string) {
        this.printMsg("Getting the displacement for " + string);
        return ((ByteAreaElement)this.byteAreaHashtable.get(string)).getDisplacement();
    }

    public String setValue(String string, String string2) {
        this.printMsg("Setting the string value for " + string);
        ((ByteAreaElement)this.byteAreaHashtable.get(string)).setValue(this.bByteArea, string2);
        return this.getValue(string);
    }

    public byte[] setValue(String string, byte[] byArray) {
        this.printMsg("Setting the byte value for " + string);
        ((ByteAreaElement)this.byteAreaHashtable.get(string)).setValue(this.bByteArea, byArray);
        return byArray;
    }

    public int setValue(String string, int n) {
        this.printMsg("Setting the integer value for " + string);
        ((ByteAreaElement)this.byteAreaHashtable.get(string)).setValue(this.bByteArea, n);
        return n;
    }

    public void setToDefaultValue(String string) {
        this.printMsg("Reseting the default value for " + string);
        ((ByteAreaElement)this.byteAreaHashtable.get(string)).setToDefaultValue(this.bByteArea);
    }
}

