/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMPreeditEvent;
import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.AttributedCharacterIterator;

class PreeditPane
extends Canvas {
    private String composedString;
    private int caret;
    private static final int TEXT_ORIGIN_X = 5;
    private static final int TEXT_ORIGIN_Y = 15;
    private int width;
    private int height;
    FontMetrics metrics;

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.composedString.length() > 0) {
            graphics.setColor(this.getForeground());
            graphics.drawString(this.composedString, 5, 15);
        }
        Rectangle rectangle = this.getCaretRectangle();
        graphics.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
    }

    private Rectangle getCaretRectangle() {
        int n = 0;
        if (this.caret > 0) {
            char[] cArray = new char[this.caret];
            this.composedString.getChars(0, this.caret, cArray, 0);
            n = this.metrics.charsWidth(cArray, 0, this.caret);
        }
        return new Rectangle(5 + n, 15 - this.metrics.getAscent(), 0, this.metrics.getAscent() + this.metrics.getDescent());
    }

    void handleEvent(IIIMPreeditEvent iIIMPreeditEvent) {
        if (this.metrics == null) {
            this.metrics = this.getGraphics().getFontMetrics();
        }
        this.composedString = new String();
        AttributedCharacterIterator attributedCharacterIterator = iIIMPreeditEvent.getIterator();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            this.composedString = this.composedString + c;
            c = attributedCharacterIterator.next();
        }
        this.width = this.metrics.stringWidth(this.composedString);
        this.height = this.metrics.getHeight();
        this.caret = iIIMPreeditEvent.getCaret();
        this.repaint();
    }

    int width() {
        return this.width;
    }

    int height() {
        return this.height;
    }
}

