/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMActionEvent;
import com.sun.iiim.IIIMLookupEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import sun.awt.im.iiimp.FocusLabel;
import sun.awt.im.iiimp.LookupWindow;
import sun.awt.im.iiimp.Manager;

class LookupPane
extends Panel {
    private int master;
    private int choicePerWindow;
    private Dimension rowColumn;
    private int direction;
    private int labelOwner;
    private int firstCandidate;
    private int lastCandidate;
    private int currentCandidate;
    private String[] candidates;
    private String[] labelList;
    private int processType;
    private int indexPage;
    private String title;
    private FocusLabel[] awtLabels = new FocusLabel[this.cacheSize];
    private int cacheSize = 32;
    private static final int CANDIDATE_GAP = 5;
    private int oldCandidate;
    private String[] oldCandidates;
    private AttributedCharacterIterator[] candidateIterator;
    private AttributedCharacterIterator[] labelIterator;
    private AttributedCharacterIterator[] oldCandidateIterator;
    private Component target;
    private LookupWindow window;

    public LookupPane() {
        int n = 0;
        while (n < this.awtLabels.length) {
            this.awtLabels[n] = new FocusLabel();
            ++n;
        }
        this.enableInputMethods(false);
    }

    private void checkCache(int n) {
        if (n > this.cacheSize) {
            FocusLabel[] focusLabelArray = new FocusLabel[n];
            System.arraycopy(this.awtLabels, 0, focusLabelArray, 0, this.cacheSize);
            int n2 = this.cacheSize;
            while (n2 < n) {
                focusLabelArray[n2] = new FocusLabel();
                ++n2;
            }
            this.awtLabels = focusLabelArray;
            this.cacheSize = n;
        }
    }

    private boolean same(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean same(CharacterIterator[] characterIteratorArray, CharacterIterator[] characterIteratorArray2) {
        if (characterIteratorArray == null || characterIteratorArray2 == null || characterIteratorArray.length != characterIteratorArray2.length) {
            return false;
        }
        int n = 0;
        while (n < characterIteratorArray.length) {
            char c = characterIteratorArray[n].first();
            char c2 = characterIteratorArray2[n].first();
            while (c != '\uffff') {
                if (c != c2) {
                    return false;
                }
                c = characterIteratorArray[n].next();
                c2 = characterIteratorArray2[n].next();
            }
            ++n;
        }
        return true;
    }

    void handleEvent(IIIMLookupEvent iIIMLookupEvent) {
        switch (iIIMLookupEvent.getType()) {
            case 0: {
                this.start(iIIMLookupEvent);
                break;
            }
            case 2: {
                if (Manager.COLOR_SUPPORT) {
                    this.draw2(iIIMLookupEvent);
                    break;
                }
                this.draw(iIIMLookupEvent);
                break;
            }
            case 3: {
                this.process(iIIMLookupEvent);
                break;
            }
        }
    }

    private void start(IIIMLookupEvent iIIMLookupEvent) {
        this.master = 1;
        this.choicePerWindow = iIIMLookupEvent.getChoicePerWindow();
        this.rowColumn = iIIMLookupEvent.getRowColum();
        this.direction = iIIMLookupEvent.getDirection();
        this.labelOwner = iIIMLookupEvent.getLabelOwner();
        this.oldCandidates = null;
        this.oldCandidate = -1;
        GridLayout gridLayout = new GridLayout(this.rowColumn.width, this.rowColumn.height);
        gridLayout.setHgap(5);
        this.setLayout(gridLayout);
    }

    private void draw(IIIMLookupEvent iIIMLookupEvent) {
        block6: {
            block4: {
                block5: {
                    this.currentCandidate = iIIMLookupEvent.getCurrentCandidate();
                    this.candidates = iIIMLookupEvent.getCandidates();
                    this.labelList = iIIMLookupEvent.getLabelList();
                    if (this.candidates.length != this.labelList.length) {
                        throw new IllegalArgumentException(" Lookup Error.");
                    }
                    if (this.master != 1) break block4;
                    if (this.same(this.candidates, this.oldCandidates)) break block5;
                    this.removeAll();
                    this.checkCache(this.candidates.length);
                    int n = 0;
                    while (n < this.candidates.length) {
                        FocusLabel focusLabel = this.awtLabels[n];
                        focusLabel.setText(this.labelList[n] + " : " + this.candidates[n]);
                        this.add(focusLabel);
                        focusLabel.setTarget(this, n);
                        if (n == this.currentCandidate) {
                            focusLabel.setFocus(true);
                        }
                        ++n;
                    }
                    this.repaint();
                    this.awtLabels[this.currentCandidate].requestFocus();
                    break block6;
                }
                if (this.currentCandidate == this.oldCandidate) break block6;
                this.awtLabels[this.currentCandidate].setFocus(true);
                this.awtLabels[this.currentCandidate].repaint();
                if (this.oldCandidate < 0) break block6;
                this.awtLabels[this.oldCandidate].setFocus(false);
                this.awtLabels[this.oldCandidate].repaint();
                break block6;
            }
            this.firstCandidate = iIIMLookupEvent.getFirstCandidate();
            this.lastCandidate = iIIMLookupEvent.getLastCandidate();
            this.checkCache(this.lastCandidate - this.firstCandidate);
            int n = this.firstCandidate;
            while (n < this.lastCandidate) {
                this.awtLabels[n - this.firstCandidate].setText(this.labelList[n] + " : " + this.candidates[n]);
                this.add(this.awtLabels[n - this.firstCandidate]);
                this.awtLabels[n - this.firstCandidate].setTarget(this, n);
                ++n;
            }
        }
        this.oldCandidate = this.currentCandidate;
        this.oldCandidates = this.candidates;
    }

    private void draw2(IIIMLookupEvent iIIMLookupEvent) {
        this.candidateIterator = iIIMLookupEvent.getCandidateIterator();
        this.labelIterator = iIIMLookupEvent.getLabelIterator();
        if (this.candidateIterator.length != this.labelIterator.length || this.master != 1) {
            throw new IllegalArgumentException(" Lookup Error.");
        }
        if (!this.same(this.candidateIterator, this.oldCandidateIterator)) {
            this.checkCache(this.candidateIterator.length);
            int n = 0;
            while (n < this.candidateIterator.length) {
                FocusLabel focusLabel = this.awtLabels[n];
                focusLabel.setIterator(this.labelIterator[n], this.candidateIterator[n]);
                this.add(focusLabel);
                focusLabel.setTarget(this, n);
                if (n == this.currentCandidate) {
                    focusLabel.setFocus(true);
                }
                this.repaint();
                this.awtLabels[this.currentCandidate].requestFocus();
                ++n;
            }
        } else {
            this.awtLabels[this.currentCandidate].setFocus(true);
            this.awtLabels[this.currentCandidate].repaint();
            if (this.oldCandidate >= 0) {
                this.awtLabels[this.oldCandidate].setFocus(false);
                this.awtLabels[this.oldCandidate].repaint();
            }
        }
        this.oldCandidate = this.currentCandidate;
        this.oldCandidateIterator = this.candidateIterator;
    }

    private void process(IIIMLookupEvent iIIMLookupEvent) {
        this.processType = iIIMLookupEvent.getProcessType();
        this.indexPage = iIIMLookupEvent.getProcessIndexPage();
        this.repaint();
    }

    void forwardEvent(AWTEvent aWTEvent) {
        this.target.dispatchEvent(aWTEvent);
    }

    void changeFocus(int n) {
        if (this.currentCandidate != n) {
            this.awtLabels[this.currentCandidate].setFocus(false);
            this.awtLabels[this.currentCandidate].repaint();
            this.currentCandidate = n;
        }
    }

    void clicked(int n) {
        IIIMActionEvent iIIMActionEvent = new IIIMActionEvent(2, (Object)this.awtLabels[n].getText());
        this.window.dispatchActionEvent(iIIMActionEvent);
    }

    void setTarget(Component component) {
        this.target = component;
    }

    void setLookupWindow(LookupWindow lookupWindow) {
        this.window = lookupWindow;
    }
}

