/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMActionEvent;
import com.sun.iiim.IIIMCommittedEvent;
import com.sun.iiim.IIIMEvent;
import com.sun.iiim.IIIMPreeditEvent;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.im.iiimp.InvalidSyntaxException;
import sun.awt.im.iiimp.Manager;

public class LWESyntax
implements Cloneable {
    static final String COMMENT = "#";
    static final String DEFMODE = "defmode";
    static final String INITIALMODE = "initialmode";
    static final String MODE = "mode";
    static final String STATUS_KEY = "_STATUS_";
    static final String FALLTHROUGH = "fallthrough";
    static final String FALLTHROUGH_KEY = "_FALLTHROUGH_";
    static final String MODE_SWITCH = "goto";
    static final String CONVERT = "convert";
    static final String BACKSPACE = "backspace";
    static final String CONVERT_S = "convert-s";
    static final String UNCONVERT = "unconvert";
    static final String NEXT = "next";
    static final String NEXT_S = "next-s";
    static final String PREVIOUS = "previous";
    static final String PREVIOUS_S = "previous-s";
    static final String FORWARD = "forward";
    static final String BACKWARD = "backward";
    static final String MOVE_TOP = "move-top";
    static final String MOVE_BOTTOM = "move-bottom";
    static final String CLEAR = "clear";
    static final String EXPAND = "expand";
    static final String EXPAND_S = "expand-s";
    static final String SHRINK = "shrink";
    static final String SHRINK_S = "shrink-s";
    static final String EXPAND_NOCONV = "expand-noconv";
    static final String EXPAND_NOCONV_S = "expand-noconv-s";
    static final String SHRINK_NOCONV = "shrink-noconv";
    static final String SHRINK_NOCONV_S = "shrink-noconv-s";
    static final String FIX = "fix";
    private Hashtable modeTable;
    private Hashtable firstTable;
    private Hashtable currentTable;
    private static int[] masks = new int[]{1, 2, 4};
    private static String[] maskStrings = new String[]{"shift", "control", "mod1"};
    private StringBuffer context = new StringBuffer();

    public LWESyntax(String string) throws InvalidSyntaxException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        this.readRule(bufferedReader);
    }

    public LWESyntax(InputStreamReader inputStreamReader) throws InvalidSyntaxException {
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.readRule(bufferedReader);
    }

    private void readRule(BufferedReader bufferedReader) throws InvalidSyntaxException {
        this.modeTable = new Hashtable();
        int n = 0;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.parseRule(string);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new InvalidSyntaxException(n);
        }
    }

    LWESyntax getCopy() {
        try {
            return (LWESyntax)this.clone();
        }
        catch (Exception exception) {
            if (Manager.DEBUG) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private void parseRule(String string) throws InvalidSyntaxException {
        String string2 = string.trim();
        if (string2.startsWith(COMMENT)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(DEFMODE)) {
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                this.modeTable.put(string4, new Hashtable());
            }
            return;
        }
        if (string3.equals(INITIALMODE)) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new InvalidSyntaxException();
            }
            String string5 = stringTokenizer.nextToken();
            this.firstTable = (Hashtable)this.modeTable.get(string5);
            if (this.firstTable == null) {
                throw new InvalidSyntaxException();
            }
            return;
        }
        if (string3.equals(MODE)) {
            try {
                String string6;
                String string7 = stringTokenizer.nextToken();
                this.currentTable = (Hashtable)this.modeTable.get(string7);
                if (this.currentTable == null) {
                    throw new InvalidSyntaxException();
                }
                String string8 = stringTokenizer.nextToken();
                this.currentTable.put(STATUS_KEY, string8);
                if (stringTokenizer.hasMoreTokens() && (string6 = stringTokenizer.nextToken()).equals(FALLTHROUGH)) {
                    String string9 = stringTokenizer.nextToken();
                    Hashtable hashtable = (Hashtable)this.modeTable.get(string9);
                    if (hashtable == null) {
                        throw new InvalidSyntaxException();
                    }
                    this.currentTable.put(FALLTHROUGH_KEY, hashtable);
                }
            }
            catch (Exception exception) {
                throw new InvalidSyntaxException();
            }
            return;
        }
        if (string3.equals("endmode")) {
            return;
        }
        try {
            Hashtable hashtable;
            String string10 = stringTokenizer.nextToken();
            if (this.currentTable.containsKey(string10)) {
                hashtable = (Hashtable)this.currentTable.get(string10);
            } else {
                hashtable = new Hashtable();
                this.currentTable.put(string10, hashtable);
            }
            ActionList actionList = new ActionList();
            while (stringTokenizer.hasMoreTokens()) {
                actionList.addAction(stringTokenizer.nextToken());
            }
            hashtable.put(string3, actionList);
        }
        catch (Exception exception) {
            throw new InvalidSyntaxException();
        }
    }

    public IIIMEvent[] getEventList(IIIMEvent iIIMEvent) throws InvalidSyntaxException {
        AWTEvent aWTEvent = iIIMEvent.getAWTEvent();
        if (aWTEvent instanceof KeyEvent) {
            iIIMEvent.consume();
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            int n = keyEvent.getID();
            if (n == 402) {
                return null;
            }
            if (n == 400 && LWESyntax.unprintable(keyEvent.getKeyChar())) {
                return null;
            }
            if (n == 401 && LWESyntax.printable(keyEvent.getKeyCode()) && keyEvent.getModifiers() == 0) {
                return null;
            }
            String string = null;
            String string2 = null;
            if (n == 400) {
                string2 = String.valueOf(keyEvent.getKeyChar());
                string = "'" + string2 + "'";
            } else {
                string2 = string = LWESyntax.makeKeyString(KeyEvent.getKeyText(keyEvent.getKeyCode()), keyEvent.getModifiers());
            }
            Hashtable hashtable = (Hashtable)this.firstTable.get(string);
            if (hashtable == null) {
                ActionList actionList;
                Hashtable hashtable2 = (Hashtable)this.firstTable.get(FALLTHROUGH_KEY);
                if (hashtable2 != null && (hashtable = (Hashtable)hashtable2.get(string)) != null && (actionList = this.searchResult(hashtable, this.context)) != null) {
                    return this.processActions(actionList, this.context);
                }
                if (!Character.isISOControl(keyEvent.getKeyChar()) && string.startsWith("'")) {
                    this.context.append(string2);
                }
                return this.makePreeditEvent(this.context.toString());
            }
            ActionList actionList = this.searchResult(hashtable, this.context);
            if (actionList == null) {
                Hashtable hashtable3 = (Hashtable)this.firstTable.get(FALLTHROUGH_KEY);
                if (hashtable3 != null && (hashtable = (Hashtable)hashtable3.get(string)) != null && (actionList = this.searchResult(hashtable, this.context)) != null) {
                    return this.processActions(actionList, this.context);
                }
                if (!Character.isISOControl(keyEvent.getKeyChar()) && string.startsWith("'")) {
                    this.context.append(string2);
                }
                return this.makePreeditEvent(this.context.toString());
            }
            return this.processActions(actionList, this.context);
        }
        return null;
    }

    private ActionList searchResult(Hashtable hashtable, StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        while (true) {
            String string2;
            Object v;
            if ((v = hashtable.get(string2 = "\"" + string + "\"")) != null) {
                int n = stringBuffer.length();
                int n2 = string.length();
                if (n > 0) {
                    stringBuffer.delete(n - n2, n);
                }
                return (ActionList)v;
            }
            if (string.length() < 1) {
                return null;
            }
            string = string.substring(1, string.length());
        }
    }

    private IIIMEvent[] processActions(ActionList actionList, StringBuffer stringBuffer) throws InvalidSyntaxException {
        Object object;
        Object object2;
        String[] stringArray = actionList.getActions();
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < stringArray.length) {
            object2 = stringArray[n];
            if (!((String)object2).equals("")) {
                IIIMEvent[] iIIMEventArray;
                if (((String)object2).startsWith("\"")) {
                    object = ((String)object2).substring(1, ((String)object2).length() - 1);
                    stringBuffer.append((String)object);
                    iIIMEventArray = this.makePreeditEvent(stringBuffer.toString());
                    if (iIIMEventArray != null) {
                        vector.add(iIIMEventArray[0]);
                    }
                } else if (((String)object2).equals(MODE_SWITCH)) {
                    if (stringArray.length <= n + 1) {
                        throw new InvalidSyntaxException(0);
                    }
                    object = stringArray[++n];
                    this.firstTable = (Hashtable)this.modeTable.get(object);
                    if (this.firstTable == null) {
                        throw new InvalidSyntaxException(0);
                    }
                    vector.add(new IIIMCommittedEvent(stringBuffer.toString()));
                    stringBuffer.setLength(0);
                } else if (((String)object2).equals(CONVERT)) {
                    object = new IIIMActionEvent(1, (Object)new String[]{object2, stringBuffer.toString()});
                    System.out.println(" make a event = " + (String)object2);
                    vector.add(object);
                    stringBuffer.setLength(0);
                } else if (((String)object2).equals(BACKSPACE)) {
                    if (stringBuffer.length() > 0) {
                        object = stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                        iIIMEventArray = this.makePreeditEvent(((StringBuffer)object).toString());
                        vector.add(iIIMEventArray[0]);
                    }
                } else {
                    this.debug(" action = " + (String)object2 + " is not supported yet.");
                }
            }
            ++n;
        }
        object2 = vector.toArray();
        object = new IIIMEvent[((Object[])object2).length];
        int n2 = 0;
        while (n2 < ((Object)object2).length) {
            object[n2] = (IIIMEvent)object2[n2];
            ++n2;
        }
        return object;
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }

    String getCurrentContext() {
        return this.context.toString();
    }

    private IIIMEvent[] makePreeditEvent(String string) {
        AttributedString attributedString = new AttributedString(string);
        if (string.length() > 0) {
            attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT, 0, string.length());
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        IIIMPreeditEvent iIIMPreeditEvent = new IIIMPreeditEvent(1, attributedCharacterIterator, 0);
        IIIMEvent[] iIIMEventArray = new IIIMEvent[]{iIIMPreeditEvent};
        return iIIMEventArray;
    }

    private static String makeKeyString(String string, int n) {
        String string2 = "";
        int n2 = 0;
        while (n2 < masks.length) {
            if ((masks[n2] & n) != 0) {
                string2 = string2 + maskStrings[n2] + "-";
            }
            ++n2;
        }
        String string3 = string2;
        string3 = string.equals("Backspace") ? "'^H'" : (string2.equals("control-") && string.length() == 1 ? "'^" + string + "'" : string3 + string);
        return string3;
    }

    private static boolean printable(int n) {
        switch (n) {
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 160: 
            case 161: 
            case 162: 
            case 192: 
            case 222: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: {
                return true;
            }
        }
        return false;
    }

    private static boolean unprintable(char c) {
        return c >= '\u0000' && c <= '\u0019' || c == '\u007f';
    }

    class ActionList {
        Vector vector = new Vector();

        ActionList() {
        }

        void addAction(String string) {
            this.vector.add(string);
        }

        int size() {
            return this.vector.size();
        }

        String[] getActions() {
            Object[] objectArray = this.vector.toArray();
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = (String)objectArray[n];
                ++n;
            }
            return stringArray;
        }
    }
}

