/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.IOException;
import sun.awt.im.iiimp.IIIMPInputStream;
import sun.awt.im.iiimp.IIIMPOutputStream;
import sun.awt.im.iiimp.IIIMProtocol;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.ProtocolData;
import sun.awt.im.iiimp.ProtocolHeader;

class Protocol
implements IIIMProtocol {
    ProtocolHeader header = null;
    ProtocolData data;

    Protocol() {
        this.data = new ProtocolData();
    }

    Protocol(int n, ProtocolData protocolData) {
        try {
            if (protocolData != null) {
                protocolData.pad();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.data = protocolData;
        if (protocolData != null) {
            this.calculateHeader(n);
        }
    }

    void calculateHeader(int n) {
        int n2 = ProtocolData.paddings(this.data.count);
        int n3 = this.data.count + n2;
        int n4 = 0;
        n4 = n3 < (int)Math.pow(2.0, 24.0) ? 0 : 1;
        this.header = new ProtocolHeader(n4, n, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IIIMPInputStream iIIMPInputStream) {
        this.header = new ProtocolHeader();
        IIIMPInputStream iIIMPInputStream2 = iIIMPInputStream;
        synchronized (iIIMPInputStream2) {
            this.header.read(iIIMPInputStream);
            this.data.read(iIIMPInputStream, this.header.packetLength);
        }
    }

    public void write(IIIMPOutputStream iIIMPOutputStream) {
        if (this.header == null) {
            this.debug("error");
        } else {
            this.header.write(iIIMPOutputStream);
        }
        this.data.write(iIIMPOutputStream);
    }

    int getOpCode() {
        return this.header.getOpCode();
    }

    ProtocolHeader getHeader() {
        return this.header;
    }

    ProtocolData getData() {
        return this.data;
    }

    static String toString(int n) {
        switch (n) {
            case 0: {
                return "IM_NO_PROTOCOL";
            }
            case 1: {
                return "IM_CONNECT";
            }
            case 2: {
                return "IM_CONNECT_REPLY";
            }
            case 3: {
                return "IM_DISCONNECT";
            }
            case 4: {
                return "IM_DISCONNECT_REPLY";
            }
            case 5: {
                return "IM_REGISTER_TRIGGER_KEYS";
            }
            case 6: {
                return "IM_TRIGGER_NOTIFY";
            }
            case 7: {
                return "IM_TRIGGER_NOTIFY_REPLY";
            }
            case 8: {
                return "IM_SETIMVALUES";
            }
            case 9: {
                return "IM_SETIMVALUES_REPLY";
            }
            case 10: {
                return "IM_GETIMVALUES";
            }
            case 11: {
                return "IM_GETIMVALUES_REPLY";
            }
            case 12: {
                return "IM_FORWARD_EVENT";
            }
            case 13: {
                return "IM_FORWARD_EVENT_REPLY";
            }
            case 14: {
                return "IM_COMMIT_STRING";
            }
            case 15: {
                return "IM_FORWARD_EVENT_WITH_OPERATIONS";
            }
            case 16: {
                return "IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY";
            }
            case 20: {
                return "IM_CREATEIC";
            }
            case 21: {
                return "IM_CREATEIC_REPLY";
            }
            case 22: {
                return "IM_DESTROYIC";
            }
            case 23: {
                return "IM_DESTROYIC_REPLY";
            }
            case 24: {
                return "IM_SETICVALUES";
            }
            case 25: {
                return "IM_SETICVALUES_REPLY";
            }
            case 26: {
                return "IM_GETICVALUES";
            }
            case 27: {
                return "IM_GETICVALUES_REPLY";
            }
            case 28: {
                return "IM_SETICFOCUS";
            }
            case 29: {
                return "IM_SETICFOCUS_REPLY";
            }
            case 30: {
                return "IM_UNSETICFOCUS";
            }
            case 31: {
                return "IM_UNSETICFOCUS_REPLY";
            }
            case 32: {
                return "IM_RESETIC";
            }
            case 33: {
                return "IM_RESETIC_REPLY";
            }
            case 40: {
                return "IM_PREEDIT_START";
            }
            case 41: {
                return "IM_PREEDIT_START_REPLY";
            }
            case 42: {
                return "IM_PREEDIT_DRAW";
            }
            case 43: {
                return "IM_PREEDIT_DRAW_REPLY";
            }
            case 46: {
                return "IM_PREEDIT_DONE";
            }
            case 47: {
                return "IM_PREEDIT_DONE_REPLY";
            }
            case 50: {
                return "IM_STATUS_START";
            }
            case 51: {
                return "IM_STATUS_START_REPLY";
            }
            case 52: {
                return "IM_STATUS_DRAW";
            }
            case 53: {
                return "IM_STATUS_DRAW_REPLY";
            }
            case 54: {
                return "IM_STATUS_DONE";
            }
            case 55: {
                return "IM_STATUS_DONE_REPLY";
            }
            case 70: {
                return "IM_LOOKUP_CHOICE_START";
            }
            case 71: {
                return "IM_LOOKUP_CHOICE_START_REPLY";
            }
            case 72: {
                return "IM_LOOKUP_CHOICE_DRAW";
            }
            case 73: {
                return "IM_LOOKUP_CHOICE_DRAW_REPLY";
            }
            case 74: {
                return "IM_LOOKUP_CHOICE_DONE";
            }
            case 75: {
                return "IM_LOOKUP_CHOICE_DONE_REPLY";
            }
            case 76: {
                return "IM_LOOKUP_CHOICE_PROCESS";
            }
            case 77: {
                return "IM_LOOKUP_CHOICE_PROCESS_REPLY";
            }
            case 90: {
                return "IM_AUX_START";
            }
            case 91: {
                return "IM_AUX_START_REPLY";
            }
            case 92: {
                return "IM_AUX_DRAW";
            }
            case 93: {
                return "IM_AUX_DRAW_REPLY";
            }
            case 94: {
                return "IM_AUX_DONE";
            }
            case 95: {
                return "IM_AUX_DONE_REPLY";
            }
            case 96: {
                return "IM_AUX_SETVALUES";
            }
            case 97: {
                return "IM_AUX_SETVALUES_REPLY";
            }
        }
        return "Unknown Protocol";
    }

    public String toString() {
        int n = this.getOpCode();
        return Protocol.toString(n);
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }
}

