package Revision;
use strict;
use System;
use Util;
use Matrix;
use PDM::ConfigFile;
use Agent::BROCADE;
use Agent::TAPE;

#
#  returns: [type, rc, curr_version, expected_version, current_patch, expected_patch, desc]
#  rc = PASS , DOWNREV, UPREV, NI, (Not installed), ERR
use vars qw ($ERR);

use vars qw ($ERR);

sub baseRev {
  my($class, $patch) = @_;
  my($base, $req_rev);
  if ($patch =~ /-/) {
      ($base, $req_rev) = split (/-/, $patch);
   } else {
      $base = $patch;
      $req_rev = "";
   }
  return ($base, $req_rev);
}

#
# uses the matrix to verify if the right patch is present for a certain version of
# software, see SDS, SEVM in matrix.db for example
# 'SDS' => {
#   '4.2.1' => [ '108693-04', 'Solstice DiskSuite' ]
# },
#

sub checkSoftPatch {
  my($class, $category, $Matrix, $InstalledP, $curr_version) = @_;

  my $x = $Matrix->{$category};
  my (@R);
  foreach my $version (keys %$x) {
      next if ($version ne $curr_version);

      my $entry = $x->{$version};
      my $req_patch = $entry->[0];
      my $desc      = $entry->[1];
      my($req_base, $req_rev) = $class->baseRev($req_patch);

      if ($InstalledP->{patch}{$req_patch}) {
         push(@R, [$category, undef,'PASS',$curr_version, undef, $req_patch, $req_patch, $desc]);
         last;
      } elsif ($req_rev) {
         my $rev = $InstalledP->{base}{$req_base};
         if (!$rev) {
            push(@R, [$category, undef,'NI', $curr_version, undef, undef, $req_patch, $desc]);
            last;
         } elsif ($rev eq $req_rev) {
            push(@R, [$category, undef,'PASS', $curr_version, undef, "$req_base-$rev", $req_patch, $desc]);
         } elsif ($rev < $req_rev) {
            push(@R, [$category, undef,'DOWNREV', $curr_version, undef, "$req_base-$rev", $req_patch, $desc]);
            last;
         } else {
            push(@R, [$category, undef,'UPREV', $curr_version, undef, "$req_base-$rev", $req_patch, $desc] );
            last;
         }
     }
  }
  if ($#R < 0) {
    push(@R, [$category, undef,'ERR',$curr_version,undef, undef,undef,"No patches available for current version" ]);
  }
  return \@R;
}

#
# uses the matrix to verify if all required patches are present on the host
# see HOST in matrix.db
# 'PCI' => {
#      '109189-02' => [ 1, 'ifp' ],
#      '109399-03' => [ '0', 'PCI FC100 fcode' ]
#    },
#    'DEFAULT' => {
#      '108983-08' => [ 1, 'leadville fcip' ],
#      '108982-09' => [ 1, 'leadville fctl, fc & fp' ],
#      '109529-04' => [ 1, 'luxadm' ],
#

sub checkHostPatch {
  my($class, $section, $category, $Matrix, $InstalledP) = @_;

  my $x = $Matrix->{$section}{$category};
  my (@R);
  foreach my $req_patch (keys %$x) {  # read all req. patches

      my $entry = $x->{$req_patch};
      my $present = $entry->[0];
      my $desc    = $entry->[1];
      my($req_base, $req_rev) = $class->baseRev($req_patch);

      if ($present == 0) { # patch not present, probably t3 patch etc..
         push(@R, [$category, undef, 'PASS', undef, undef, $req_patch, $req_patch, $desc]);

      } elsif ($InstalledP->{patch}{$req_patch}) {
         push(@R, [$category, undef, 'PASS', undef, undef, $req_patch, $req_patch, $desc]);

      } elsif ($req_rev) {
         my $rev = $InstalledP->{base}{$req_base};
         if (!$rev) {
            push(@R, [$category,undef, 'NI', undef,undef, undef, $req_patch, $desc]);
         } elsif ($rev eq $req_rev) {
            push(@R, [$category, undef, 'PASS', undef, undef,"$req_base-$rev", $req_patch, $desc]);
         } elsif ($rev < $req_rev) {
            push(@R, [$category, undef, 'DOWNREV', undef, undef,"$req_base-$rev", $req_patch, $desc]);
         } else {
            push(@R, [$category, undef, 'UPREV', undef, undef,"$req_base-$rev", $req_patch, $desc]);
         }
      }
  }
  return \@R;
}

sub readInstalledPatches {
  my($class) = @_;
  my($l,%PATCHES);
  $ERR = undef;
  my($err, $sr) = Util->run_command("/bin/showrev -p", "installed_patches.text");
  if ($err) {
    $ERR = $err;
    return undef;
  }
  foreach $l (@$sr) {
     chop($l);
     my($head, $a,$b,$obs) = split(/\s+/, $l);
     if ($a =~ /\-/) {
       my($base, $rev) = split(/\-/, $a);
       $PATCHES{base}{$base} = $rev if ($rev >  $PATCHES{base}{$base});
     } else {
       $PATCHES{patch}{$a} = 1;
     }
  }
  return \%PATCHES;
}
my $A3500 = undef;

sub a3500Present {
    my($class) = @_;
    my($l);
    return $A3500 if defined($A3500);
    $A3500 = 0;
    
    $ERR = undef;
    my($err, $com) = Util->run_command("/usr/lib/osa/bin/lad","lad1.txt");

   if ("@$com" =~ /No RAID devices found/) {
        return undef;
   }
   elsif ($err){
        $ERR = $err;
        return undef;
   }
   foreach $l (@$com) {
         if ( $l =~ /LUNS:/) {
            $A3500 = 1;
            last;
         }
   }
   return $A3500; 
}


my $A5 = undef;

sub a5kPresent {
  my($class) = @_;
  my($l);
  return $A5 if (defined($A5));
  $A5= 0;

  $ERR = undef;
  my($err, $lp) = Util->run_command("/usr/sbin/luxadm probe", "lux_probe.txt");
  if ($err) {
     $ERR = $err;
     return undef;
  }
  foreach $l (@$lp) {
     if ($l =~ /SENA/) {
        $A5 = 1;
        last;
     }
  }
  return $A5;

}

sub checkAllDrivers {
  my($class) = @_;

  my @LD_ALL_PORTS = split(/\n/, `/usr/sbin/luxadm -e port | grep CONN`);

  my($text, %S);

  $ERR = undef;
  my($err, $mi) = Util->run_command("/usr/sbin/modinfo", "modinfo.text");
  if ($err) {
     $ERR = $err;
     return undef;
  }
  my $mod = "@$mi";

  foreach my $port (@LD_ALL_PORTS) {
     if ($port =~ /socal/) {
        $S{socal} = 1; $S{sf} = 1;

     } elsif ($port =~ /usoc/) {
        $S{usoc} = 1; $S{fp} = 1;

     } elsif ($port =~ /qlc/) {
        $S{qlc} = 1; $S{fp} = 1;

     } elsif ($port =~ /ifp/) {
        $S{ifp} = 1;
     }
  }
  foreach my $k (keys %S) {
    if ($mod !~ / $k /) {
       $err++;
       $text .= "  $k driver not configured\n";
    }
  }
  return ($err, $text);

}

my $DI  = undef;

sub runDiskInquiry {
  my($class, $test) = @_;
  my($l, @L);
  if ($test) {
     open(O,  System->get_home() . "/Test/di.txt");
     while ($l = <O>) {
       push(@L, $l);
     }
     close(O);
     return \@L;
  }
  return $DI if ($DI);

  my $F = System->get_home() . "/bin/disk_inquiry";
  open(O, "$F 2>&1|");
  while ($l = <O>) {
    push(@L, $l);
  }
  close(O);
  $DI = \@L;
  return $DI;
}


#0: c0t0d0      SEAGATE    ST34371W SUN4.2G     7462    9716D29086##    primary                /sbus@1f,0/SUNW,fas@e,8800000/sd@0,0
# 3: c1t1d1      SUN        T300                 0111    0000098111##    alternate

sub checkA5kIB {
   my($class, $Matrix, $InstalledP, $yu_box_list) = @_; 
   my @L;
   my $category="IB_FIRMWARE";
   my $key;
   foreach my $box (@$yu_box_list){
       my $file = "luxadm display $box";
       my $line_num =0;
       if (open(OT, "$file 2>&1|")) {
           my $l;
           while ($l = <OT>){
              $line_num++;
              next if  (($line_num<=4)|| ($line_num >20) || ($l =~ /Not{2}/));
              chop($l);
              my ($first,$rest)= split(/\s+/,$l);
              if ($first =~ /FW/ ) {
                  my ($var1, $var2, $var3, $var4, $var5) = split(/\s+/, $l);
                  #  var2 has contents like:  Revision:1.09
                  my ($rn, $curr_fw) = split(/:/,$var2);

                  if ( $curr_fw =~ /\d/){
                       if ($line_num > 16) {
                         $key = 5200;
                       }
                       if ($line_num < 16) {
                         $key = 5000;
                       }
                     
                       my $ib_fw = $Matrix->{IB_FIRMWARE}; 
                       if ($ib_fw->{$key}){
                             my $d =$ib_fw->{$key};
                             my $req_fw = $d->[0];
                             my $comp = $class->compareFwLevels($curr_fw, $req_fw);      
                            if ( $comp==0) {
                              push(@L, [$category, $box,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                            }
                            elsif ($comp>0) {
                               push(@L, [$category, $box,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                            }
                            elsif ($comp<0){
                               push(@L, [$category, $box,'DOWNREV',$curr_fw, $req_fw, undef,undef,undef]);
                            }
                      }else{
                              push(@L, [$category, $box, 'ERR', undef, undef,undef,undef, "No Key in Matrix/Vicom"]); 
                      } 
                       
               } 
           }
        }
        close(OT);
      }
   }     
   return \@L;
}

sub checkDiskFirmware_t3 {
     my($class,$Matrix, $InstalledP,$vendor, $model, $val, $dev,$elem,$type) = @_;
     my $disk_fw = $Matrix->{DISK_FW};
     my $category = "T3_DISK_FW"; 
     my $key = "$vendor:$model:T3";
     my $curr_fw = $val;
     my $cp = ($dev->{name} || $dev->{ip});
     
     if ($disk_fw->{$key}) {
            my $d = $disk_fw->{$key};
            my $req_fw = $d->[0];
            my $req_patch = $d->[2];
            my $desc =  "$vendor:$model";
            my($req_base, $req_rev) = $class->baseRev($req_patch);
            if ($curr_fw < 0){
           return [$category, "$cp.$type.$elem", 'ERR', undef, $req_fw, undef, $req_patch, "Unable to get the  device firmware level, please contact you SUN representative"];
            }
            my $comp = $class->compareFwLevels($curr_fw, $req_fw);
            if ($comp == 0) {
               return [$category, "$cp.$type.$elem", 'PASS', $curr_fw, $req_fw, undef, $req_patch, $desc];
            } elsif ($comp > 0) {
               return [$category,"$cp.$type.$elem", 'UPREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
            } elsif ($comp < 0) {
               return [$category, "$cp.$type.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
            }
            else {
               return [$category, "$cp.$type.$elem", 'ERR', $curr_fw, $req_fw, undef, $req_patch, "Unable to check $vendor device, please contact your SUN representative and update the device firmware"];
            }
    } else {
           return [$category, "$cp.$type.$elem", 'ERR', $curr_fw, undef, undef, undef, "Unable to check the $vendor device, please see sunsolve online for potential patch information or contact your SUN representative"];
    }

}


sub checkDiskFirmware {
  my($class, $Matrix, $InstalledP, $a5k_list) = @_;
  my($line, @L);
  
  my $di = $class->runDiskInquiry(0);

  my $disk_fw = $Matrix->{DISK_FW};
  my $category = "A5K_DISK_FW";
  my $cnt= 0;
  my $found=0;
  foreach $line (@$di) {
       next if ($line =~ /No such device/) ;
       next if ($cnt++ < 6) ;
       my($dev, $vp,  $vp2) = split(/\t+/, Util->ltrim($line));
       if ( is_dev_a5k($dev,$a5k_list) ) {
          $found = 1;
          my($vendor, $prod) = split(/\s+/, $vp, 2);
          my($curr_fw, $serial) = split(/\s+/, $vp2, 2);
          $prod = Util->rtrim($prod);
          my $desc = $prod;

          next if ($prod eq "T3");
          next if ($prod eq "StorEdgeA3500FCd");
          my $key = "$vendor:$prod:A5000";
          if ($disk_fw->{$key}) {
            my $d = $disk_fw->{$key};
            my $req_fw = $d->[0];
            my $req_patch = $d->[2];
            my($req_base, $req_rev) = $class->baseRev($req_patch);
            my $comp = $class->compareFwLevels($curr_fw, $req_fw);
            if ($comp == 0) {
             push(@L, [$category, $dev, 'PASS', $curr_fw, $req_fw, undef, $req_patch, $desc]);
	    } elsif ($comp > 0) {
             push(@L, [$category, $dev, 'UPREV', $curr_fw, $req_fw, undef, $req_patch, $desc]);
	    } elsif ($comp < 0) {
             push(@L, [$category, $dev, 'DOWNREV', $curr_fw, $req_fw, undef, $req_patch, $desc]);
   	    }
	    else {
             push(@L, [$category, $dev, 'ERR', $curr_fw, $req_fw, undef, $req_patch, "Unable to check device, please see sunsolve online for potential patch information or contact your SUN representative "]);
	   }
         }
         else {
            push(@L, [$category, $dev, 'ERR', $curr_fw,undef,undef,undef,"Unable to check the $vendor device, please see sunsolve online for potential patch information or contact your SUN representative"]); 
         } 
      }
   }
   if ($found ==0)
   {
          push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No A5k device are present, please check system"]);
   }
   return \@L;
}

sub is_dev_a5k {
      my ($device, $a5k_ctr_arr) = @_;
      my $where1 = index($device,"c");
      my $where2 = index($device,"t");
      my $num= substr($device,$where1, $where2-$where1);

      foreach my $x (@$a5k_ctr_arr){
         if ($num eq $x){
            return 1; 
         }
      }       
      return 0;
}

sub checkFirmware_3500 {
        my($class, $Matrix, $InstalledP) = @_;
        my ($line, @L);
        my $category = " A3500FC_Firmware";
        my $key ="firm";
        my $disk_fw = $Matrix->{A3500FC};
        my $d = $disk_fw->{$key};
        my $req_fw = $d->[0];
        # my($err, $com) = Util->run_command("/usr/lib/osa/bin/lad","lad_temp.txt");
        my $di = $class->runDiskInquiry(0);
        foreach $line (@$di) {
                      next if ($line !~ /A3500/);
                      my ($ctd_dev, $restpart) = split(/\t+/,Util->ltrim($line));
                      my($err1, $result) = Util->run_command("/usr/lib/osa/bin/raidutil -c $ctd_dev -i", "raid_temp.txt");
                      my $l;
                      if ( $err1){
                         push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "Can not run /usr/lib/osa/bin/raid util cmd, please install SUNWosar package or contact your SUN representative"]);
                      }
                      foreach $l (@$result) {
                             next if ( $l !~ /Firmware Level/) ;
                             my ( $tem1, $tem2, $curr_fw ) = split (/\s+/, $l);
                             my ( $comp) = $class->compareFwLevels($curr_fw, $req_fw);

                             if ( $comp ==0) {
                                   push(@L, [$category, $ctd_dev,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                             } elsif ( $comp >0) {
                                   push(@L, [$category, $ctd_dev,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                             } elsif ( $comp <0){
                                   push(@L, [$category, $ctd_dev,'DOWNREV',$curr_fw, $req_fw,undef,undef,"please check SUNWosar package installed and use Raid Manager 6 to update the firmware, or contact your SUN representative"]);
                             }
                      }
        }
        return \@L;
}





sub checkDiskFirmware_3500 {
        my($class, $Matrix, $InstalledP) = @_;
        my($line, @L);
         
        my $di = $class->runDiskInquiry(0);
        my $disk_fw = $Matrix->{A3500FC};
        my $category = "A3500FC_Product_Revision";
        my $found=0;
        foreach $line (@$di) {
            next if ($line !~ /A3500/);
            $found =1;
            my($dev,$vp,$vp2) = split(/\t+/,Util->ltrim($line));
            my($vendor,$prod) = split(/\s+/,$vp,2); 
            my($curr_fw,$serial) = split(/\s+/,$vp2,2);
            $prod = Util->rtrim($prod);
            my $key ="ctrl";
            if ($disk_fw->{$key}) {
                 my $d = $disk_fw->{$key};
                 my $req_fw = $d->[0];
                 my $comp = $class->compareFwLevels($curr_fw, $req_fw);
                 if ( $comp ==0) {
                     push(@L, [$category, $dev,'PASS',$curr_fw, $req_fw,undef,undef,undef]);    
                 }
                 if ( $comp >0) {
                     push(@L, [$category, $dev,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                 }
                 elsif ( $comp <0){
                     push(@L, [$category, $dev,'DOWNREV',$curr_fw, $req_fw,undef,undef,undef]);
                 } 
            } else {
              push(@L, [$category, $dev, 'ERR', undef, undef,undef,undef, "No Key in Matrix/DISK_FW"]);
            }
       }
       if ($found==0)
       {
           push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No A3500FC device are present, please check system"]);
       }
       return \@L; 
}

sub checkSilkWormFirmware {
    my($class, $Matrix, $InstalledP) = @_;
    my $switch_fw = $Matrix->{Brocade}; 
    my $category = "SilkWorm";
    my $key_1 = "OS_1";
    my $key_2 = "OS_2";
    my $d;
    my $req_fw;

    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $found=0; 
    my $desc = "Please contact your SUN representative to install the expected level firmware";

    foreach my $dev (@$devs){
          if ( $dev->{class} =~ /brocade/) {
          
             my $ip_num = $dev->{ipno};
             # my $curr_fw = Agent::BROCADE->getVersion('172.20.67.167');


	      
             ###############################################
             # need to differentiate 1Gb and 2Gb brocade   #
             ###############################################  

             my $brocade_switch_type = $class->getBrocadeType($ip_num);
             print "$brocade_switch_type\n";
             
             $found =1;             

             if (($brocade_switch_type == 2) || ($brocade_switch_type == 3)){
                  $d = $switch_fw->{$key_1};
                  $req_fw = $d->[0];
             } 
             elsif (($brocade_switch_type == 9) || ($brocade_switch_type == 10)){
                  $d = $switch_fw->{$key_2};
                  $req_fw = $d->[0];
             }
             elsif ($brocade_switch_type == -1) {
                  push(@L, [$category, $ip_num, 'ERR', undef, undef,undef,undef, "Can not get the switch version, please contact your SUN representative"]);
                  next;
             }







             my $curr_fw = Agent::BROCADE->getVersion($ip_num);
             my $comp = $class->compareBrocadeFwLevels($curr_fw, $req_fw);
             if ( $comp==0) {
                   push(@L, [$category, $ip_num,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp>0) {
                   push(@L, [$category, $ip_num,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp<0){
	      push(@L, [$category, $ip_num,'DOWNREV',$curr_fw, $req_fw, undef,undef,$desc]);
             }
 
          }
    } 
    if ($found ==0)
    {
              push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No SilkWorm device are present, please check system"]);
    }
  
    return \@L;
}

sub checkVicomFirmware {

    my($class, $Matrix, $InstalledP) = @_;
    my $disk_fw = $Matrix->{Vicom}; 
    my $category = "Vicom";
    my $key ="ctrl";
    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $found=0;
    my $note ="No vicom device present, please check system setup";
    foreach my $dev (@$devs){
       if ( $dev->{class} =~ /ve/)
       {
           $found =1;
           my($e,$curr_fw) = $class->GetFW($dev->{initiator},$dev->{login});
           if ($e){
               push(@L, [$category, $dev->{name},'ERR',undef,undef,undef,undef,$note]);
           }
           elsif ($disk_fw->{$key}) {
              my $d = $disk_fw->{$key};
              my $req_fw = $d->[0];
              my $comp = $class->compareFwLevels($curr_fw, $req_fw);
              if ( $comp ==0) {
                     push(@L, [$category, $dev->{name},'PASS',$curr_fw, $req_fw,undef,undef,undef]);
              }
              elsif ($comp >0) {
                    push(@L, [$category, $dev->{name},'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
              }
              elsif ( $comp <0){
                  push(@L, [$category, $dev->{name},'DOWNREV',$curr_fw, $req_fw,undef,undef,undef]);
              }
           }else {
                  push(@L, [$category, $dev->{name}, 'ERR', undef, undef,undef,undef, "No Key in Matrix/VE"]);
           }
        }
  }
  if ($found ==0)
  {
              push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No VE devices are present, please check system"]);
  }
  return \@L;

}

sub checkTapeFirmware {
    my($class, $Matrix, $InstalledP) = @_;
    my $tape_fw = $Matrix->{Tape};
    my $category = "FC_TAPE";
    my $key = "drv";
    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $d = $tape_fw->{$key};
    my $req_fw = $d->[0];
    my $found =0;
    my $tape_drive = "Tape Drive F/W";
    foreach my $dev (@$devs){
          if ( $dev->{type} =~ /tape/) {
             $found =1;
             my $tape_wwn = $dev->{wwn};
             my $curr_fw = $class->getTapeFirmware($tape_wwn);
             my $comp;
             if ($curr_fw =~ /^E/){
                  # add character is because luxadm display chop R
                  # for example, it only shows E.28 instead of RE.28 
                  $curr_fw ="R".$curr_fw;
                  my ($tem1,$new_curr_fw) = split(/\./,$curr_fw);
                  my ($tem2,$new_req_fw) = split(/\./,$req_fw);
                  $comp = $class->compareFwLevels($new_curr_fw, $new_req_fw);  
             } elsif ($curr_fw =~ /1\.28/){
                  $comp =-1;    
             }else {
              $comp = $class->compareFwLevels($curr_fw, $req_fw);
             }
             if ( $comp==0) {
                   push(@L, [$category, $tape_wwn,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp>0) {
                   push(@L, [$category, $tape_wwn,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
             }
             elsif ($comp<0){
                   push(@L, [$category, $tape_wwn,'DOWNREV',$curr_fw, $req_fw,"N/A","N/A","No patch available, please contact your SUN representative"]);
             }

          }
    }
    if ($found == 0)
    {
            push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No tape device are present, please check system"]);
    }

    return \@L;
}

sub getTapeFirmware {
      my ($class, $wwn) = @_;
      my($lux) = System->find_luxadm;
      my $TO= 60;
      my($err,$com) = Util->run_command("$lux display $wwn 2>&1", "luxadm.txt" , $TO);
      return ("",$err, undef) if ($err);
      foreach my $l (@$com) {
          if ($l =~ /^ *Error:/) {
               return ("",$l, undef);
          } 
          my($h1, $h2);
          if ($l =~ /(.*):\s+(.*)/) {
              $h1 = $1; $h2 = $2;
              if ($h1 =~ /Revision/) {
                    my $rev = $h2; 
                    return ($rev); 
              }
          }
      }         
}

################################################################################
#sub GetFW
#returns (vicomFWlevel, error)
################################################################################
sub GetFW{
        (my $this, my $yu, my $login)= @_;

        my($renv) = System->get_renv();
        my($sve_path) = $renv->{GSV_SVE_PKGDIR};

        if ($sve_path = 'undef') {
          $sve_path = '/opt/svengine';
        }


        my $command;
        my $err;
        if( -x "$sve_path/sduc/showmap"){
          $command="$sve_path/sduc/showmap -d $login";
          print $command."\n";
        }
        else{ my $note= "cannot run $sve_path/sduc/showmap";return($note,undef);}
        ($err, my $result) = Util->run_command($command,"/tmp/test.txt");
        if ($#$result < 3) {
          return($result, undef);
        }
        foreach my $line (@$result){
          if($line =~ $yu){
            my @fields = split(/\s+/, $line);
            if((!defined($fields[3])) && (!defined($result))){
              $err.="Unable to determine FW level\n";
              return($err,$result);
            }

            if((defined($fields[3]))){
              $result = $fields[3];
            }
          }
       }
       return($err,$result);
}


 # Given two hex numbers (usually 4 digits) #
 # simply compare them. A dot is a wildcard #
 # and matches automatically.               #
 # if $drive is > $matrix then return 1    #
 # if $drive is < $matrix then return -1    #

sub compareFwLevels {
    my ($class, $drive, $matrix) = @_;
    my (@matrix, @drive, $indx);

    @matrix = split(//, $matrix); # separate characters
    @drive = split(//, $drive); # separate characters
    $indx = 0;
    my ($m, $d);
    foreach my $char (@matrix) {
        if ($char ne ".") {
            $m .= $char;
            $d .= $drive[$indx];
        }
        $indx++;
    }

    if (hex($d) > hex($m)) {
        return 1;
    } elsif (hex($d) < hex($m)) {
        return -1;
    } else {
        return 0;
    }
}

sub compareBrocadeFwLevels{
     my ($class, $drive, $matrix) = @_;
    my (@matrix, @drive, $indx);

     @matrix = split(//, $matrix); # separate characters
    @drive = split(//, $drive); # separate characters
    $indx = 0;
    my ($m, $d);
    foreach my $char (@matrix) {
        if ($char ne ".") {
            $m .= $char;
            $d .= $drive[$indx];
        }
        if ( $d gt $m) {
              return 1;
        } elsif ( $d lt $m ) {
          return -1;
        }
        $indx++;
    }
    return 0;

}

sub devCompare {
   my($class, $key, $elem, $val, $dev, $mat, $type) = @_;

   my $el  = $mat->{$type};

   my $rev   = $el->[0];
   my $patch = $el->[1];
   my $desc  = $el->[2];
   my $comp = ($dev->{name} || $dev->{ip});
   if (!$el) {
       return [$key, "$comp.$type", 'ERR' , undef, undef, undef , $patch, 
          "No entry in Matrix for $key.$type" ];
   }
   if ($val < 0) {
        return [$key, "$comp.$type.$elem", 'ERR' , undef, undef, undef , $patch, "Device Revision is not available" ]; 
   }

   my $cp = $class->compareFwLevels($val, $rev);
   if ($val eq $rev) {
       if ( ($type eq "enc") || ($type eq "firmrev")){
        return [$key, "$comp.$type",'PASS' , $val, $rev, undef , $patch,undef];
       }
       else {
        return [$key, "$comp.$type.$elem", 'PASS' , $val, $rev, undef , $patch, undef];
       }
   } elsif ($cp > 0) {
       if ( ($type eq "enc") || ($type eq "firmrev")){
        return [$key, "$comp.$type", 'UPREV' , $val, $rev, undef , $patch,
undef];}
       else {
        return [$key, "$comp.$type.$elem", 'UPREV' , $val, $rev, undef , $patch, undef];
       }
   } elsif ($cp < 0) {
       if (($type eq "enc") || ($type eq "firmrev"))
       {
         return [$key, "$comp.$type",'DOWNREV' , $val, $rev, undef , $patch,undef]; 
       }
       else{
         return [$key, "$comp.$type.$elem", 'DOWNREV' , $val, $rev, undef , $patch, undef];
       }
   } else {
       if ($type eq "enc"){
         return [$key, "$comp.$type",'PASS' , $val, $rev, undef , $patch,undef];
       }
       else {
         return [$key, "$comp.$type.$elem", 'PASS' , $val, $rev, undef , $patch, undef];
       }
   }
}



sub version_ok {
    my ($class, $spec, $installed) = @_;

    my $return_value = 0;

    my ($spec_major_num, $spec_minor_num, $spec_increment) = $spec
        =~ /(\d+)\D*(\d*)\D*(\d*)/;

    my ($installed_major_num, $installed_minor_num, $installed_increment)
        = $installed =~ /(\d+)\D*(\d*)\D*(\d*)/;

    # Assign some default values if the minor number
    # or increment didn't match in the regular expression
    $spec_minor_num = 0 if (! $spec_minor_num);
    $spec_increment = 0 if (! $spec_increment);
    $installed_minor_num = 0 if (! $installed_minor_num);
    $installed_increment = 0 if (! $installed_increment);
    
    if ($installed_major_num > $spec_major_num) {
        return 2;
    }elsif ($installed_major_num < $spec_major_num) {
        return 0;
    } else { # Check minor number
        if ($installed_minor_num > $spec_minor_num) {
            return 2;
        } elsif ($installed_minor_num < $spec_minor_num) {
            return 0;
        } else { #Check increment
            if ($installed_increment > $spec_increment) {
                return 2;
            }  elsif ($installed_increment < $spec_increment) {
                return 0;
            } else {
                return 1;
            }
        }
    }
    Debug->err(TEXT => "version_ok: Logic error in version_ok subroutine!\n");
    return 0;
}

#
#  ($Present ...) = $class->hba_present();
#

sub hbas_present {
   my($class) = @_;
   my($l);
   my $PRESENT = {};
   my($err, $sr) = Util->run_command("/usr/sbin/luxadm -e port", "luxadme.text");
   $ERR = $err;
   return () if ($ERR);

   my(@luxdiag_on_ports, @luxdiag_off_ports);
   my(%LD_ORIG_PORTS, %socpp, %portnum, %phys_path, %TEST);
   my(@LD_OFF_PORTS);

   foreach my $cur_port (@$sr) {
      next if ($cur_port !~ /CONN/);
      my @cur_port_info = split(/\s+/, $cur_port);
      if ($cur_port =~ /^(.*socal.*):(\d+)(\s+.*)$/ ) {
          $cur_port = "$1/sf\@$2,0:devctl$3";
          $LD_ORIG_PORTS{"$1/sf\@$2,0:devctl"} =  $cur_port_info[0];
      } else {
          $LD_ORIG_PORTS{$cur_port_info[0]} = $cur_port_info[0];
      }
      if ($cur_port =~ /^(\S+)\s+NOT\s+CONNECTED/) {
          # allow offline ports to trigger storstat firmware checks #

          push @luxdiag_off_ports, $1;

          $PRESENT->{SOCAL} = 1 if ($cur_port =~ /^(.*socal.*)\/sf\@(\d+)/);
          $PRESENT->{USOC} = 1 if ($cur_port =~ /^(.*usoc.*)\/fp\@(\d+)/);
          $PRESENT->{QLC}  = 1 if ($cur_port =~ /^(.*qlc.*)\/fp\@(\d+)/);
          $PRESENT->{IFP}  = 1 if ($cur_port =~ /^(.*pci.*ifp\@)(\d+)/);

      } elsif ($cur_port =~ /^(\S+)\s+CONNECTED/) {
          push @luxdiag_on_ports, $1;
      }
    }
    @LD_OFF_PORTS = @luxdiag_off_ports;

    return () if (@luxdiag_on_ports == -1);


    # convert luxdiag output to match disklist and path-to-inst

    foreach my $ldprt (@luxdiag_on_ports) {
        chomp $ldprt;
        if ($ldprt =~ /^(.*socal.*)\/sf\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex con";
            $PRESENT->{SOCAL} = 1;

        } elsif ($ldprt =~ /^(.*usoc.*)\/fp\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex con";
            $PRESENT->{USOC} = 1;

        } elsif ($ldprt =~ /^(.*qlc.*)\/fp\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex";
            $PRESENT->{QLC} = 1;

        } elsif ($ldprt =~ /^(.*pci.*ifp\@)(\d+)/) {
            $socpp{$ldprt} = "$1";
            #$portnum{$ldprt} = $2;
            $portnum{$ldprt} = 0;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "dex con";
            $PRESENT->{IFP}= 1;

        } elsif ($ldprt =~ /^(.*pci.*)\/scsi\@(\d+)/) {
            $socpp{$ldprt} = "$1";
            $portnum{$ldprt} = $2;
            $phys_path{$ldprt} = $ldprt;
            $phys_path{$ldprt} =~ s/\/devices//;
            $phys_path{$ldprt} =~ s/:devctl//;
            $TEST{$ldprt} = "lbf dex con";
            $PRESENT->{IFP} = 1;
        } else {
            print "Error: unknown Host Adapter port $ldprt\n";
        }
    }

    return ($PRESENT, \@luxdiag_on_ports, \@luxdiag_off_ports,
            \%LD_ORIG_PORTS, \%socpp, \%portnum, \%phys_path, \%TEST);
}


  

sub getBrocadeType{
     my ($class, $ipnum) = @_;
     my $bro_cmd = "/opt/SUNWstade/bin/snmpwalk -r 0 -t 30 -m all -Os -M /opt/SUNWstade/snmp/mibs/ $ipnum public swFabricMemType";
     my $version=0;
     my $tem1;
     if (open(tem_f, "$bro_cmd 2>&1|")) {
          while (my $l = <tem_f>) {
                print $l;
                if (( $l =~ /swFabricMemType/) && ( $l !~ /Unknown Object/) ){
                     ($tem1,$version) = split(/=/, $l);
                     $version =~ s/^\s+//;
                } elsif ( ($l =~ /Unknown Object/) || ( $l =~ /Node not found/)) {
                     $version = -1;
                } 
         }
     } 
     close (tem_f);
     if (!$version){
        return (-1);
     }

     return ($version);
}


1;

