package Health::Brocade;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Brocade.pm,v 1.11 2002/03/04 16:18:38 mckenney Exp $


use base 'Health';
use NWS::Brocade;
use Ilist;
use Message;
use Report;
use Catalog;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.11 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Brocade');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_BROCADE});
  return $self;
}

#####################################################

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  my($oreport) = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  my($name)    = $report->name;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my($log)     = $report->log();
  if (!$wwn) {
     Debug->err(ERROR => "This Switch \"$name\" ($ip) cannot be identified");
     return;
  }

  CIM->version("1.1");
  $DB::single = 1;

  return if ($hm->connectionEvent($wwn, $report, {method => 2} ));
  my($audit); 
  my($freq) = System->get_renv()->{audit_freq} || 7;
  if (!$oreport || ($audit = Timer->isXdays("Audit$wwn", $freq)) eq "YES" ) {  # new t300 or audit time.
     my($etype) = $audit ? "brocade.AuditEvent" : "brocade.DiscoveryEvent";
     my($title) = $audit ? "Auditing a":"Discovered a new";
     my($dt)    = "A" if (!$audit);
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype ],
                  [ Target      => $wwn ],
                  [ SourceIP    => $ip  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title Brocade Switch called $id"],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::Brocade->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);

     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd,  @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
     if ($audit) {  # dump stats.

        $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => 'brocade.Statistics'  ],
                  [ Target      => $wwn ],
                  [ SourceIP    => $ip  ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "Statistics about Brocade Switch $id :"],
                  [ Data        => Util->nnl($rep->toStringP('port.\d+.stats'))],
                         ]);

        $sd = Events->sourceDetector({ event => $ev });

        my($system_key) = CIM::Key->new( ['NWS_System', 
                    'Name'            =>$rep->get('id.wwn'), 
                    CreationClassName => 'NWS_System']);

        $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $system_key ],
                    ]);

        $ed = Message->new( { id        => $report->id,
                            instances => [$ev, @$sd, $pertains ],
                            severity  => Message::SEVERITY_NORMAL});

        $pdm->saveMessage($ed);

     }
  }
  return if (!$oreport);


  $orep = $oreport->content;
  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  my($PORTS) = $rep->get('port.count');

# check if port state has changed

  my($comp);
  for ($x=0; $x <= $PORTS; $x++) {
     $comp = "port.$x"; # . sprintf("%3.3d", $x);
     $hm->stateEvent($comp, $report, $rep, $orep, 'CIM_Card', $comp, $wwn);
  }
#
# check sensors for changes
#
  my($type, $status, $ostatus, $val, $oval);
  foreach my $el ('temperature','fan', 'power-supply') {
    for ($x=1; $x <= 20; $x++) {
      $type    = $rep->get("sensor.$el.$x.info");
      last if (!$type);
      $hm->alarm($report, $orep, "BROCADE", "sensor.$el.$x", "status", 
                 $id, $id, $wwn, "sensor.$el.status");
    }
  }

#
#  generate events for the important error counters 
#
  my($port);
  my($data);
  for ($x=0; $x <= $PORTS; $x++) {
     $port = "port.$x"; 
     my($rep1) = $rep->subset("$port.error");
     foreach my $val (keys %$rep1) {
         my($old) = $orep->get("$port.error.$val");
         my($new) = $rep->get("$port.error.$val");
         if ($new > $old) {
           my($dif) = $new - $old;
           my($tx)  = "Error-counter $val increased by $dif on port $x";
           $data .= "$tx\n";
         }
     }
  }
  if ($data) {
      chop($data);
      $hm->logEvent($data, $report,  $wwn, undef, Message::SEVERITY_WARNING,
                  "PortStatistics");
  }

  for ($x=0; $x <= $PORTS; $x++) {
     $port = "port.$x"; 
     my($old) = $orep->get("$port.state.PhyState");
     my($new) = $rep->get("$port.state.PhyState");
     if ($old ne $new) {
        $hm->logEvent("PhysicalState of port $x changed from '$old to '$new",
                  $report,  $wwn, undef, Message::SEVERITY_WARNING);
     }
  }
      
}

  
sub status {
   my($hm, $rep, $orep, $comp) = @_;
   my($pdm) = $hm->{pdm};
   my($map) = $pdm->getDeviceStateMap("brocade.availability");
   Debug->print3("brocade: $comp");

   my($status)  = $rep->getState("$comp.state.OpStatus");
   my($ostatus) = $orep->getState("$comp.state.OpStatus");
   $status      =~ s/\(\d+\)$//;
   $ostatus     =~ s/\(\d+\)$//;

   my($old)     = $map->get("state.OpStatus.$ostatus");
   my($new)     = $map->get("state.OpStatus.$status");

   return ("$ostatus", "$status",$old, $new );

}


1;

