package Agent::SAN;

#  $Name:  $
#  $Id: SAN.pm,v 1.12 2002/01/17 23:14:18 ccadieux Exp $
use strict;
use Agent;
use base 'Agent';
use Agent::SWITCH;
use Agent::A5K;
use Agent::T3;
use Agent::SWITCH;
use Agent::VE;
use vars qw( %RAID);

sub isSelectable {"FC Counters"}

sub revision {'$Revision: 1.12 $'}


sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SAN');
  return $self;
}

sub RUN {
  my($agent, $ras_flag) = @_;
  my($mod, @mods, $x, @writes, @reads, $report);
  my($a5, $t3, $sw, $sum, @fc, $l);

  my($cache) = 0;
  my($pdm) = $agent->{pdm};

  my ($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  $report = {};

  $DB::single=1;

  my($logfile)   = $agent->{renv}->{logfile};

  return if (!-r $logfile);
  Timelapse->start(ref($agent));

  my($log_err, $lines) = $agent->read_log_file($logfile,'NEW');
  my $skip;
  my $powercycle;

  for ($x=0; $x<= $#$lines; $x++ ){
    $l = $lines->[$x];

    if ($l =~ /(scsi parity error)/) {
      push(@writes, $l);

    } elsif ($l =~ /Copyright .+ Sun Microsystems/) {
      $powercycle = 1;
      Debug->print2("SAN module: reason: Power-Cycle");
      #return;

    } elsif ($l =~ /SCSI transport failed/) {
      push(@reads, $l);

    }

  }
#  push(@reads, "TEST MESSAGE ");

  my $master  = Util->findMaster;
  my($ib, $ob);
  my $save;
  if ($#reads >= 0 || $#writes >= 0) {
     Debug->print2("SAN:". ($#reads+1) . " READ and " . ($#writes+1) . " WRITES");
     $ib = 1;
     my $key = time;
     $report->{"reads"} = \@reads;
     $report->{"writes"} = \@writes;
     open(O, ">" . System->get_home() . "/DATA/MessLog");
     print O "[$key]\n";
     for ($x=0; $x <= 5; $x++) {
        print O " $reads[$x]\n";
     }
     for ($x=0; $x <= 5; $x++) {
        print O " $writes[$x]\n";
     }
     close(O);

     if ($master) {
         Util::Http->appendFile($master, "FC", "$renv->{hostname}:$key", 10);
     } else {
         $save = "$renv->{hostname}:$key";
         $ob = 1;
     }
     foreach my $h (@$hosts) {  # alert SP's
        if ($h->{solution} eq "Y") {
          if ($h->{hostname} eq $renv->{hostname}) {
             $save .= "$renv->{hostname}:$key" if (!$save);
          } else {
             Util::Http->appendFile($h->{ipno}, "FC", "$renv->{hostname}:$key", 10);
          }
        }
     }
           
  }
  my $F =  System->get_home() . "/DATA/FC";

  if (-r $F) {  # master or SP's
     Debug->print2("SAN: found FC file, reading counters");
     open(O, $F); my @L = <O>; close(O); unlink $F; 
     push(@L, $save) if ($save);
     $report->{INFO} = \@L;
     $ob = 1;
  } elsif ($save) {
     $report->{INFO} = [$save];
  }
  my $freq = $renv->{fc_frequency} + 0;
  $freq = 60 if (!$freq);
  if (Timer->isXmins('fcic_counters', $freq)) {
     Debug->print2("SAN: get counters hourly");
     $ib = 1;
     $ob = 1; # if (!$master || $renv->{solution} eq "Y");
  }
  return if (!$ib && !$ob);
  
  if ($ib) {  # master or slave
     $a5 = Agent::A5K->FCCounters();
     $report->{FC_a5k} = $a5;

     $t3 = Agent::T3->FCCounters();
     $report->{FC_t3} = $t3;
  }
  if ($ob) {  # master or SP's
     $sw = Agent::SWITCH->FCCounters({ responsibleOnly => 1} );
     $report->{FC_switch} = $sw;

     $sw = Agent::BROCADE->FCCounters({ responsibleOnly => 1} );
     $report->{FC_brocade} = $sw;

     $sw = Agent::VE->FCCounters( { responsibleOnly => 1} );
     $report->{FC_vicom} = $sw;
  }
     
  my($id) = {  accessName  => "san",
           deviceName  => "san",
           name        => "san",
           category    => Report::CAT_SAN,
           ip          => "",
           };

  $pdm->saveReport( Report->new($id, $report , undef) , {skip_health => $skip} );
  Timelapse->stop(ref($agent));
}



1;



