/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Edge
extends Selectable
implements Serializable {
    public int multi = 1;
    char severity;
    Vertex start;
    Vertex end;
    VertexApplet applet;
    String label;
    String label2;
    String label3;
    public char type;
    static int edgecnt;
    int edgeno;
    int w1;
    int startPos;
    int endPos;
    Point lastP1;
    Point lastP2;

    public Edge(VertexApplet applet0, String type0, Vertex directedvertex, int pos, Vertex directedvertex1, int pos1, String label_0, String label2_0, String label3_0, String label4_0) {
        this.applet = applet0;
        this.start = directedvertex;
        this.startPos = pos;
        this.label = label_0;
        if (label2_0.length() > 0) {
            int n = 2;
        }
        this.label2 = label2_0;
        this.label3 = label3_0;
        this.severity = (char)32;
        if (label4_0.length() == 1) {
            this.severity = label4_0.charAt(0);
        }
        this.endPos = pos1;
        this.edgeno = edgecnt++;
        this.type = type0.charAt(0);
        this.end = directedvertex1;
        this.lastP1 = new Point(0, 0);
        this.lastP2 = new Point(0, 0);
        this.revalidate();
    }

    public void reset() {
        this.lastP2.y = 0;
        this.lastP2.x = 0;
        this.lastP1.y = 0;
        this.lastP1.x = 0;
    }

    public String inside(int i, int j) {
        Point P1 = new Point();
        Point P2 = new Point();
        this.calcEdge(P1, P2);
        int w = 15;
        int h = 8;
        if (this.applet.zoom >= 2) {
            w = 10;
            h = 6;
        } else {
            int w2 = this.label.length() * 7;
            if (w2 > w) {
                w = w2;
            }
        }
        int rx = (P1.x + P2.x) / 2 - w / 2;
        int ry = (P1.y + P2.y) / 2 - h / 2;
        if (i < rx || i > rx + w + 4) {
            return null;
        }
        if (j < ry || j > ry + h + 1) {
            return null;
        }
        return "E";
    }

    public String info() {
        System.out.println("1=" + this.label + ",2=" + this.label2 + ",3=" + this.label3 + ",4=" + this.severity);
        if (this.label2.length() > 0) {
            return String.valueOf(this.label) + " " + this.label2 + " " + this.label3;
        }
        String s2 = String.valueOf(this.start.label) + ":" + this.startPos + " <-> " + this.end.label + ":" + this.endPos;
        return String.valueOf(this.label) + " " + s2;
    }

    public final void defaultLabel() {
        this.revalidate();
        Point3 off1 = this.start.portOffset(this.startPos, 0, 0, 0, null, null, null, null);
        Point3 off2 = this.end.portOffset(this.endPos, 0, 0, 0, null, null, null, null);
        int i = this.start.position.x + off1.x + this.end.position.x + off2.x >> 1;
        int j = this.start.position.y + off1.y + this.end.position.y + off2.y >> 1;
        this.moveLabel(i, j);
    }

    public final void moveRelative(double d, double d1) {
        this.moveLabelRelative((int)d, (int)d1);
    }

    public final boolean nearEnd(int i, int j) {
        int k = 10 + this.size + this.end.size;
        return this.end.near(i, j, k);
    }

    public final boolean nearStart(int i, int j) {
        int k = 10 + this.size + this.start.size;
        return this.start.near(i, j, k);
    }

    public final void paint(Graphics g) {
        this.paintLine(g);
    }

    public final void paintArrows(Graphics g) {
        this.revalidate();
        this.paintEndArrow(g);
    }

    public final void paintEndArrow(Graphics g) {
    }

    public final void calcEdge(Point P1, Point P2) {
        Point position = this.start.position;
        Point position1 = this.end.position;
        Point3 off1 = this.start.portOffset(this.startPos, 0, 0, 0, null, null, null, null);
        Point3 off2 = this.end.portOffset(this.endPos, 0, 0, 0, null, null, null, null);
        P1.x = (int)(this.applet.scale * (float)position.x + (float)off1.x + (float)(this.start.portSize / 2));
        P2.x = (int)(this.applet.scale * (float)position1.x + (float)off2.x + (float)(this.end.portSize / 2));
        P1.y = (int)(this.applet.scale * (float)position.y + (float)off1.y + (float)(this.start.portSize / 2));
        P2.y = (int)(this.applet.scale * (float)position1.y + (float)off2.y + (float)(this.end.portSize / 2));
    }

    public final void paintXOR(Graphics g) {
        Point P1 = new Point(0, 0);
        Point P2 = new Point(0, 0);
        this.calcEdge(P1, P2);
        g.drawLine(P1.x, P1.y, P2.x, P2.y);
        if (this.lastP1.x > 0) {
            g.drawLine(this.lastP1.x, this.lastP1.y, this.lastP2.x, this.lastP2.y);
        }
        this.lastP1.x = P1.x;
        this.lastP1.y = P1.y;
        this.lastP2.x = P2.x;
        this.lastP2.y = P2.y;
    }

    public final void paintLine(Graphics g) {
        this.validate();
        Point position = this.start.position;
        Point position1 = this.end.position;
        g.setColor(this.getColor(this.color));
        Point P1 = new Point();
        Point P2 = new Point();
        this.calcEdge(P1, P2);
        Font lFont = new Font("Dialog", 0, 9);
        FontMetrics met1 = g.getFontMetrics(lFont);
        int w = 15;
        int h = 8;
        if (this.applet.zoom == 2) {
            w = 10;
            h = 8;
        } else if (this.applet.zoom > 2) {
            w = 10;
            h = 6;
        }
        if (this.type == 's') {
            g.setColor(Color.gray);
            int off = 16;
            if (this.applet.zoom >= 2) {
                g.drawLine(P1.x, P1.y, P2.x, P2.y);
            } else if (P1.x > P2.x) {
                if (P1.x - off > P2.x) {
                    g.drawLine(P1.x - off, P1.y, P2.x, P2.y);
                }
                g.drawLine(P1.x, P1.y, P1.x - 4, P1.y);
            } else {
                if (P2.x - off > P1.x) {
                    g.drawLine(P1.x, P1.y, P2.x - off, P2.y);
                }
                g.drawLine(P2.x - 4, P2.y, P2.x, P2.y);
            }
        } else {
            boolean flag = false;
            int box = 0;
            int rx = (P1.x + P2.x) / 2 - w / 2;
            int ry = (P1.y + P2.y) / 2 - h / 2;
            if (this.type == 'E') {
                if (this.severity == '2') {
                    g.setColor(Color.red);
                    flag = true;
                } else if (this.severity == '1') {
                    g.setColor(Color.yellow);
                    flag = true;
                } else if (this.severity == '0') {
                    g.setColor(Color.green);
                    flag = true;
                }
                box = 1;
            } else {
                box = this.applet.showLinkHandle;
            }
            g.drawLine(P1.x, P1.y, P2.x, P2.y);
            if (box == 1) {
                int temp1;
                int w2 = w;
                if (this.applet.zoom >= 0 && this.applet.zoom < 3 && (temp1 = met1.stringWidth(this.label) + 3) > w2) {
                    w2 = temp1;
                }
                g.drawRect(rx, ry, w2, h);
                g.setColor(Color.white);
                g.fillRect(rx + 1, ry + 1, w2 - 1, h - 1);
                g.setColor(Color.black);
                if (this.applet.zoom >= 0 && this.applet.zoom < 3) {
                    Font save = g.getFont();
                    g.setFont(lFont);
                    g.drawString(this.label, rx + 1, ry + h);
                    g.setFont(save);
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectinputstream) throws IOException, ClassNotFoundException {
        this.start = (Vertex)objectinputstream.readObject();
        this.end = (Vertex)objectinputstream.readObject();
        this.multi = objectinputstream.readInt();
    }

    public final void revalidate() {
        this.validate();
    }

    public String toString() {
        String s = "(Edge";
        s = String.valueOf(s) + " " + String.valueOf(this.start.hashCode());
        s = String.valueOf(s) + " " + String.valueOf(this.end.hashCode());
        s = String.valueOf(s) + " " + this.multi;
        s = String.valueOf(s) + " " + super.toString() + " ";
        return String.valueOf(s) + " )";
    }

    public String toC() {
        String s = "1|e|f|0|0|0|" + this.label + "|" + this.start.number + "," + this.startPos + "|" + this.end.number + "," + this.endPos;
        return s;
    }

    public final void validate() {
    }

    private void writeObject(ObjectOutputStream objectoutputstream) throws IOException {
        objectoutputstream.writeObject(this.start);
        objectoutputstream.writeObject(this.end);
        objectoutputstream.writeInt(this.multi);
    }
}

