/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

import java.util.Vector;
import unikix.clientapis.emulator.KixEmulator;
 
public class PFBuyBean
{
    private KixEmulator ke;
    private String      tn3270Host = "www.unikix.com";
    private int         tn3270Port = 2002;
    private int         model = KixEmulator.MODEL_3278_2_E;
    private String      hostCodepage = KixEmulator.CODEPAGE_DEFAULT;
     
    private String      company =  "comp1";
    private String      cost =  "";
    private String      numShares =  "1";
    private String      userID =  "user1";
     
    public void setCompany(String company)
    {
        this.company = company;
    }
     
    public String getCost()
    {
        return cost;
    }
     
    public void setNumShares(String numShares)
    {
        this.numShares = numShares;
    }
     
    public void setUserID(String userID)
    {
        this.userID = userID;
    }
     
    public void performWork()
    {
        init();
         
        ke.typeString(userID);
        ke.pressEnter();
        ke.waitUntilKeyboardUnlocked();
         
        ke.typeChar('b');
        ke.pressEnter();
        ke.waitUntilKeyboardUnlocked();
         
        ke.typeString(company);
        ke.tab();
        ke.typeString(numShares);
        ke.pressEnter();
        ke.waitUntilKeyboardUnlocked();
         
        cost = ke.getReadableString(1556, 11);
        ke.pressEnter();
        ke.waitUntilKeyboardUnlocked();
         
        ke.typeChar('e');
        ke.pressEnter();
        ke.waitUntilKeyboardUnlocked();
         
        ke.waitUntilDisconnected();
    }
     
    private void init()
    {
        if (ke == null)
        {
            initializeKixEmulator();
        }
         
        if (ke.isDisconnecting())
        {
            ke.waitUntilDisconnected();
        }
        if (ke.isDisconnected())
        {
            ke.connect();
        }
        ke.waitUntilConnected();
        ke.setInserting(false);
        ke.waitUntilKeyboardUnlocked();
    }
     
    public void setKixEmulator(KixEmulator keIn)
    {
        ke = keIn;
    }
     
    public KixEmulator getKixEmulator()
    {
        if (ke == null)
        {
            initializeKixEmulator();
        }
        return ke;
    }
     
    public void setTN3270Host(String tn3270HostIn)
    {
        tn3270Host = tn3270HostIn;
    }
     
    public String getTN3270Host()
    {
        return tn3270Host;
    }
     
    public void setTN3270Port(int tn3270PortIn)
    {
        tn3270Port = tn3270PortIn;
    }
     
    public int getTN3270Port()
    {
        return tn3270Port;
    }
     
    public void setModel(int modelIn)
    {
        model = modelIn;
    }
     
    public int getModel()
    {
        return model;
    }
     
    public void setHostCodepage(String hostCodepageIn)
    {
        hostCodepage = hostCodepageIn;
    }
     
    public String getHostCodepage()
    {
        return hostCodepage;
    }
     
    private void initializeKixEmulator()
    {
        ke = new KixEmulator();
        ke.setTN3270Host(tn3270Host);
        ke.setTN3270Port(tn3270Port);
        ke.setModel(model);
        ke.setHostCodepage(hostCodepage);
    }
     
}
