/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

//
// File: Sample2EventListener.java
//
// This file listens for events generated by a KixEmulator and displays those
// events and their values.
//

import unikix.clientapis.emulator.KixEmulator;
import unikix.clientapis.emulator.KixEmulatorListener;
import unikix.clientapis.emulator.KixEmulatorEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

public class Sample2EventListener implements PropertyChangeListener,
					     KixEmulatorListener
{
    public Sample2EventListener(KixEmulator ke)
    {
	//
	// Register for both PropertyChangeEvents and KixEmulatorEvents
	//
	ke.addPropertyChangeListener(this);
	ke.addKixEmulatorListener(this);
    }

    //
    // If a PropertyChangeEvent occurs this method is called
    //
    public void propertyChange(PropertyChangeEvent e)
    {
	//
	// Display the fact that a PropertyChangeEvent has occurred.
	//
	System.out.println("propertyChange: " + e.getPropertyName());

	//
	// If it is a 'connectionState' property, display the old
	// and new  connection state values as strings.
	//
	if (e.getPropertyName().equals("connectionState"))
	{
	    //
	    // Display the old and new values.
	    //
	    System.out.println("  Old Value: " +
		getStringFromConnectionState(
		    ((Integer)e.getOldValue()).intValue()) );
	    System.out.println("  New Value: " +
		getStringFromConnectionState(
		    ((Integer)e.getNewValue()).intValue()) );
	}
	else if (e.getPropertyName().equals("terminalMode"))
	{
	    //
	    // Display the old and new values.
	    //
	    System.out.println("  Old Value: " +
		getStringFromTerminalMode(
		    ((Integer)e.getOldValue()).intValue()) );
	    System.out.println("  New Value: " +
		getStringFromTerminalMode(
		    ((Integer)e.getNewValue()).intValue()) );
	}
	else
	{	
	    //
	    // For any property other than 'connectionState', display
	    // the old and new values.
	    //
	    System.out.println("  Old Value: " + e.getOldValue());
	    System.out.println("  New Value: " + e.getNewValue());
	}
    }

    //
    // If a HostChangedScreen KixEmulatorEvent occurs, this method is
    // called.
    //
    public void hostChangedScreen(KixEmulatorEvent e)
    {
	//
	// Display that a HostChangedScreenEvent has occurred.
	//
	System.out.println("hostChangedScreen:");
	System.out.println("  hostUnlockedKeyboard: " +
		    e.hostUnlockedKeyboard());
    }

    //
    // Returns a string based upon the connection state (an int) that is
    // passed to it.
    //
    private static String getStringFromConnectionState(int x)
    {
	switch(x)
	{
	    case KixEmulator.CONNECTION_STATE_CONNECTED:
				     return "CONNECTION_STATE_CONNECTED";
	    case KixEmulator.CONNECTION_STATE_CONNECTING:
				     return "CONNECTION_STATE_CONNECTING";
	    case KixEmulator.CONNECTION_STATE_DISCONNECTED:
				     return "CONNECTION_STATE_DISCONNECTED";
	    case KixEmulator.CONNECTION_STATE_DISCONNECTING:
				     return "CONNECTION_STATE_DISCONNECTING";
	}
	return null;
    }

    //
    // Returns a string based upon the terminal mode (an int) that is
    // passed to it.
    //
    private static String getStringFromTerminalMode(int x)
    {
	switch(x)
	{
	    case KixEmulator.TERMINAL_MODE_NONE:
				     return "TERMINAL_MODE_NONE";
	    case KixEmulator.TERMINAL_MODE_NVT:
				     return "TERMINAL_MODE_NVT";
	    case KixEmulator.TERMINAL_MODE_3270_NORMAL:
				     return "TERMINAL_MODE_3270_NORMAL";
	    case KixEmulator.TERMINAL_MODE_3270_SUSPEND:
				     return "TERMINAL_MODE_3270_SUSPEND";
	}
	return null;
    }
}
