/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

//
// File: Sample2.java
//
// This sample program creates an emulator and displays the events that
// emulator generates as they occur.
// It also requires the file: Sample2EventListener.java
//
// This program takes the parameters:
//   The host system	e.g. crippen
//   The port number	e.g. 9993
//
// e.g. java Sample1 crippen 9993
//

import unikix.clientapis.emulator.KixEmulator;
import java.awt.Graphics;
import java.awt.Frame;
import java.awt.Font;

public class Sample2
{
    public static final void main(String[] args)
    {
	//
	// If the host and port haven't been supplied, end the program.
	//
	if (args.length !=2)
	{
	   System.out.println("Usage: java Sample1 <host> <port>");
	   System.exit(0);
	}

	//
	// Create a new Frame and a new KixEmulator.
	//
	Frame f = new Frame("Sample 2")
		{
		    //
		    // Override update() so that no flicker occurs
		    //
		    public void update(Graphics g)
		    {
		    	paint(g);
		    }
		};
	KixEmulator ke = new KixEmulator();

	//
	// Set the Host, Port and Model of the KixEmulator.
	//
	ke.setTN3270Host(args[0]);
	ke.setTN3270Port(Integer.parseInt(args[1]));
	ke.setModel(KixEmulator.MODEL_3278_2_E);

	//
	// Set the Font of the KixEmulator to make it more readable.
	//
	ke.setFont(new Font("Monospaced", Font.PLAIN, 12));

	//
	// Add the event listener to the KixEmulator.
	//
	Sample2EventListener dummy = new Sample2EventListener(ke);

	//
	// Add the KixEmulator to the Frame, then pack and show the Frame.
	//
	f.add(ke);
	f.pack();
	f.setVisible(true);

	//
	// Connect the KixEmulator to the host.
	//
	ke.connect();
    }
}
