/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

//
// File: Sample1Applet.java
//
// This sample file is provided to show you how easy it is to create a
// working emulator as a Java applet. It requires an HTML file to operate.
// Sample1Applet.html has been supplied for this purpose.
//
package samples.clientapis.emulator;

import unikix.clientapis.emulator.KixEmulator;
import java.applet.Applet;
import java.awt.Font;
import java.awt.Graphics;

public class Sample1Applet extends Applet
{
    private KixEmulator ke;

    //
    // Create a new KixEmulator and set its Host, Port, Model and Font.
    //
    public void init()
    {
	String hostName;
	int    port;

	ke = new KixEmulator();

	//
	// Get the host
	//
	hostName = getDocumentBase().getHost();
	if ( (hostName == null) || (hostName.length()==0) )
	{
	    System.err.println("No valid host could be found");
	}

	//
	// Get the port
	//
	try
	{
	    port = Integer.parseInt(getParameter("Port"));
	}
	catch (NumberFormatException e)
	{
	    port = 2001;
	}

	//
	// Set the host, port, modal and font.
	//
	ke.setTN3270Host(hostName);
	ke.setTN3270Port(port);
	ke.setModel(KixEmulator.MODEL_3278_2_E);
	ke.setFont(new Font("Monospaced", Font.PLAIN, 12));

	//
	// Add the emulator to the Applet.
	//
	add(ke);
    }

    public void update(Graphics g)
    {
	// Override update to stop any flickering
	paint(g);
    }

    public void start()
    {
	//
	// Connect the KixEmulator to the host if the emulator is disconnected.
	//
	if (ke.isDisconnected())
	{
	    ke.connect();
	}
    }

    public void stop()
    {
	//
	// Disconnect the KixEmulator from the host if the emulator is connected
	//
	if (ke.isConnected())
	{
	    ke.disconnect();
	}
    }
}
