#
#pragma ident "@(#)Config-Reader4uwg-d.x	1.40 02/02/01 Sun Microsystems"
#

[ use MANAGED-MODULE ]
[ requires package configdWG ]
[ requires package pfaWG ]
[ requires template Config-Reader4uwg-models-d ]

[ load Config-Reader4uwg-m.x ]

_procedures = {
    [ source Config-Reader4uwg-d.prc ]
}

#activateActions(post) = dimmErrors
#activateService(dimmErrors) = _procedures
#activateCommand(dimmErrors) = initDimmErrors

_filters = {
    [ source Config-Reader4uwg-d.flt ]
}

_services = { 
    [ use SERVICE ]

    #
    # Standard Bourne Shell
    #
    sh = {
	command = "pipe://localhost//bin/sh;transport=shell"
	max = 1
    }
}


#
# A hack to send a sighup to picld on agent start
# For littleneck picl bug #4385806
#
picld = { [ use templates.Config-Reader4uwg-models-d.picld ]
    oid = 1

    status = {
	type 		= active
	refreshService	= _services.sh
	refreshCommand	= restart_picld.sh
	refreshMode	= sync
	
	# refresh only *once* at startup
	refreshInterval = 0
	
	# refresh within the first second
	# note the hold-off value in system accounts
	# for this, since picl must be restarted
	# before data is read
	initInterval	= 1
    }
}


#
# configdWG Availability
#
availability = {
    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.timestamp:update
    refreshCommand  = get_availabilty_status
}


system = { [ use templates.Config-Reader4uwg-models-d.system ]
    oid = 2

    type		= active
    refreshMode	= sync
    refreshCommand  = configdWG system 0 OS OS_version System_clock_frequency architecture hostname machine platform sample serial_number timestamp timestamp_raw total_disks total_memory total_processors total_tape_devices 
    initInterval    = 1

    # see the picld object above 
    initHoldoff	= 9

    # the refreshInterval is changed from 10s to 300s because the core team 
    # believed that the change will improve the server performance.  However, 
    # it caused the alarm to be late
    refreshInterval	= 300

    total_model_changes = { [ use _filters ]
	type		= derived
	refreshMode	= sync
	refreshCommand  = get_prom_changed_status 0
	refreshFilter   = modelChange
	refreshTrigger  = system.timestamp:refresh
	initInterval    = 2
	initHoldoff	= 10
    }
    total_config_changes = { [ use _filters ]
	type            = derived
	refreshMode     = sync
	refreshCommand  = get_prom_changed_status 1
	refreshFilter   = configChange
	initInterval    = 2
	initHoldoff	= 10
	refreshTrigger  = system.timestamp:refresh
    }
}

system-board = { [ use templates.Config-Reader4uwg-models-d.system-board ]
    oid = 3

    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG system-board 0 fru state UNIX_Timestamp32 Fru_Description Manufacture_Loc Sun_Part_No Sun_Serial_No Vendor_Name Initial_HW_Dash_Level Initial_HW_Rev_Level Fru_Shortname
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10
}

SUNWUltra-1  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-1  ]
    oid = 4
    
    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-1 0
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10
}

SUNWUltra-2  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-2  ]
    oid = 5

    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-2 0
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10
}

SUNWUltra-5  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-5  ]
    oid = 6
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-5 0
    initInterval    = 5
    refreshInterval = 86400
    initHoldoff	= 10
}

SUNWUltra-10  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-10  ]
    oid = 7
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-10 0
    initInterval    = 5
    refreshInterval = 86400
    initHoldoff	= 10
}

SUNWUltra-5_10  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-5_10  ]        
    oid = 8
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-5_10 0
    initInterval    = 5
    refreshInterval = 86400
    initHoldoff	= 10
}

SUNWUltra-250  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-250  ]
    oid = 9
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-250 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

# SUNWUltra-60 and SUNWUltra-80 node names are added for 220R(razor) and 420R(quahog)

SUNWUltra-60  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-60  ]
    oid = 10
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-60 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

SUNWUltra-80  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-80  ]
    oid = 11
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-80 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}


SUNWUltra-4  = { [ use templates.Config-Reader4uwg-models-d.SUNWUltra-4  ]
    oid = 12
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Ultra-4 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

# support for 280R

SUNWSun-Fire-280R  = { [ use templates.Config-Reader4uwg-models-d.SUNWSun-Fire-280R  ]
    oid = 13

    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Sun-Fire-280R 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

# support for 480R

SUNWSun-Fire-480R  = { [ use templates.Config-Reader4uwg-models-d.SUNWSun-Fire-480R  ]
    oid = 56
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Sun-Fire-480R 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

# support for 880

SUNWSun-Fire-880  = { [ use templates.Config-Reader4uwg-models-d.SUNWSun-Fire-880  ]
    oid  = 14
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,Sun-Fire-880 0
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

cpu-unit = { [ use templates.Config-Reader4uwg-models-d.cpu-unit ]
    oid = 15

    cpu-unitTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG cpu-unit 1 clock-frequency cpu-type dcache-size device_type ecache-size fru icache-size model pathname_element processor-id status unit temperature upa-portid
        initInterval    = 5
	refreshInterval	= 6000
	initHoldoff	= 10
    }	
}

cpu-mem-module = { [ use templates.Config-Reader4uwg-models-d.cpu-mem-module ]
    oid = 16

    cpu-mem-moduleTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG cpu-mem-module 1 num_cpus num_dimms status slot-name UNIX_Timestamp32 Fru_Description Manufacture_Loc Sun_Part_No Sun_Serial_No Vendor_Name Initial_HW_Dash_Level Initial_HW_Rev_Level Fru_Shortname
        initInterval    = 5
	refreshInterval	= 6000
	initHoldoff	= 10
    }
}

mc = { [ use templates.Config-Reader4uwg-models-d.mc ]
    oid = 17
    
    mcTbl = {
	type 		= derived
	refreshMode	= sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG mc 1 device_type fru_device 
	initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
    } 
}

bank = { [ use templates.Config-Reader4uwg-models-d.bank ]
    oid = 18
    
    bankTbl = {
        type            = derived 
        refreshMode     = sync 
        refreshTrigger  = system.total_model_changes:update 
        refreshCommand  = configdWG bank 1 bank-size device_type fru_device status
        initInterval    = 5 
        refreshInterval = 6000
	initHoldoff	= 10
    } 
}

dimm = { [ use templates.Config-Reader4uwg-models-d.dimm ]
    oid = 19
    
    dimmTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG dimm 1 device_type fru fru_device module-size socket-name status UNIX_Timestamp32 Fru_Description Manufacture_Loc Sun_Part_No Sun_Serial_No Vendor_Name Initial_HW_Dash_Level Initial_HW_Rev_Level Fru_Shortname
        initInterval    = 5
	refreshInterval	= 6000
	initHoldoff	= 10

	dimm-entry = { 
	    error-count = { [ use _procedures ]
		oid = 19	
	
		type = derived
		refreshMode = sync
		refreshTrigger = system.total_model_changes:update
		refreshCommand = getDimmErrors refr
		refreshInterval = 6000
		initInterval = 5
		initHoldoff = 15
	    }
	}

    }
}

memory = { [ use templates.Config-Reader4uwg-models-d.memory ]
    oid = 20
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG memory 1 pathname_element
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

simm = { [ use templates.Config-Reader4uwg-models-d.simm ]
    oid = 21
    
    simmTbl = { 
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG simm 1 board_reference_number fru size slot type
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10

	simm-entry = { 
	    error-count = { [ use _procedures ]
		oid = 21
		
		type = derived
		refreshMode = sync
		refreshTrigger = system.total_model_changes:update
		refreshCommand = getSimmErrors refr
		refreshInterval = 6000
		initInterval = 5
		initHoldoff = 15
	    }
	}
    }
}

power-supply = { [ use templates.Config-Reader4uwg-models-d.power-supply ]
    oid = 22
    
    power-supplyTbl = { 
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG power-supply 1 fru state UNIX_Timestamp32 Fru_Description Manufacture_Loc Sun_Part_No Sun_Serial_No Vendor_Name Initial_HW_Dash_Level Initial_HW_Rev_Level Fru_Shortname
        initInterval    = 5
	refreshInterval	= 6000
	initHoldoff	= 10
    }
}

fru-device = { [ use templates.Config-Reader4uwg-models-d.fru-device ]
    oid = 23

    fru-deviceTbl = { 
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG fru-device 1 UNIX_Timestamp32 Fru_Description Manufacture_Loc Sun_Part_No Sun_Serial_No Vendor_Name Initial_HW_Dash_Level Initial_HW_Rev_Level Fru_Shortname
        initInterval    = 5
	refreshInterval	= 6000
	initHoldoff	= 10
    }
}



cpu-fans = { [ use templates.Config-Reader4uwg-models-d.cpu-fans ]
    oid = 24
    
    cpu-fansTbl = {
	type		= derived
	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG cpu-fans 1 status speed
        initInterval    = 5
	refreshInterval	= 6000
	initHoldoff	= 10
    }
}

power-supply-fans = { [ use templates.Config-Reader4uwg-models-d.power-supply-fans ]
    oid = 25
    
    power-supply-fansTbl = {
	type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG power-supply-fans 1 status
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
    }
}

fan = { [ use templates.Config-Reader4uwg-models-d.fan ]
    oid = 26
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG fan 1 status
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

ffb = { [ use templates.Config-Reader4uwg-models-d.ffb ]
    oid = 27

    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG ffb 1 buffer device_type model pathname_element 
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10
}

afb = { [ use templates.Config-Reader4uwg-models-d.afb ]
    oid = 28

    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG afb 1 buffer device_type model pathname_element
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}


SUNWffb = { [ use templates.Config-Reader4uwg-models-d.SUNWffb ]
    oid = 29

    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG SUNW,ffb 1 3DRAM DAC FBC_version board_type buffer device_type height model revision upa-portid width
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10
}

keyswitch = { [ use templates.Config-Reader4uwg-models-d.keyswitch ]
    oid = 30
    
    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG keyswitch 0 position
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10
}

active-led = { [ use templates.Config-Reader4uwg-models-d.active-led ]
    oid = 31
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG active-led 0 state
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

disk-error-led = { [ use templates.Config-Reader4uwg-models-d.disk-error-led ]
    oid = 32
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG disk-error-led 0 state
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

gen-error-led = { [ use templates.Config-Reader4uwg-models-d.gen-error-led ] 
    oid = 33
    
    type            = derived 
    refreshMode     = sync  
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG gen-error-led 0 state
    initInterval    = 5 
    refreshInterval = 6000 
    initHoldoff	= 10
} 

power-led = { [ use templates.Config-Reader4uwg-models-d.power-led ] 
    oid = 34
    
    type            = derived 
    refreshMode     = sync  
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG power-led 0 state
    initInterval    = 5 
    refreshInterval = 6000 
    initHoldoff	= 10
} 

ps-error-led = { [ use templates.Config-Reader4uwg-models-d.ps-error-led ] 
    oid = 35
    
    type            = derived 
    refreshMode     = sync  
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG ps-error-led 0 state
    initInterval    = 5 
    refreshInterval = 6000 
    initHoldoff	= 10
} 

temp-error-led = { [ use templates.Config-Reader4uwg-models-d.temp-error-led ] 
    oid = 36
    
    type            = derived 
    refreshMode     = sync  
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG temp-error-led 0 state
    initInterval    = 5 
    refreshInterval = 6000 
    initHoldoff	= 10
} 

system-status-panel = { [ use templates.Config-Reader4uwg-models-d.system-status-panel ]
    oid = 37
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG system-status-panel 1  
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

disk-status-leds = { [ use templates.Config-Reader4uwg-models-d.disk-status-leds ]
    oid = 38
    
    type = derived
    refreshMode = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG disk-status-leds 1
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

disk-led = { [ use templates.Config-Reader4uwg-models-d.disk-led ]
    oid = 39

    disk-ledTbl = {
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG disk-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
    }
}

fan-led = { [ use templates.Config-Reader4uwg-models-d.fan-led ]
    oid = 40
    
    fan-ledTbl = {
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG fan-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
    }
}

cpu-led = { [ use templates.Config-Reader4uwg-models-d.cpu-led ]
    oid = 41
    
    cpu-ledTbl = {
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG cpu-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
    }
}
    
pci-led = { [ use templates.Config-Reader4uwg-models-d.pci-led ]
    oid = 42
    
    pci-ledTbl = {
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG pci-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
    }
}

service-led = { [ use templates.Config-Reader4uwg-models-d.service-led ]
    oid = 43
    
    service-ledTbl = {
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG service-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
    }
}

power-supply-led = { [ use templates.Config-Reader4uwg-models-d.power-supply-led ]
    oid = 44
    
    power-supply-ledTbl = {
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG power-supply-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
    }
}

settable-led = { [ use templates.Config-Reader4uwg-models-d.settable-led ]
    oid = 57
    
    settable-ledTbl = { 
	type = derived
	refreshMode = sync
	refreshTrigger  = system.total_model_changes:update
	refreshCommand  = configdWG settable-led 1 led-num state
	initInterval    = 5
	refreshInterval = 6000
	initHoldoff	= 10
	
	settable-led-entry = {
	    state = { [ use _procedures ]
		access                 = rw
		
		setActions             = runLocator
		setService(runLocator) = _internal
		setCommand(runLocator) = setLocator %value
	    
		consoleHint:editAccess       = rw
		consoleHint:customCellEditor = \
			  com.sun.symon.base.client.console.SMTblComboBoxEditor
		consoleHint:optionList       = ON OFF
	    }
	}
    }
}

temperature-sensor = { [ use templates.Config-Reader4uwg-models-d.temperature-sensor ]
    oid = 45
    
    temperature-sensorTbl = {
	type = derived
        refreshMode = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG temperature-sensor 1 temp highwarn lowwarn highfail lowfail
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
    }
}

rsc = { [ use templates.Config-Reader4uwg-models-d.rsc ]
    oid = 46
    
    type		= derived
    refreshMode	= sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG rsc 0 device_type fru_device name UNIX_Timestamp32 Fru_Description Manufacture_Loc Sun_Part_No Sun_Serial_No Vendor_Name Initial_HW_Dash_Level Initial_HW_Rev_Level Fru_Shortname
    initInterval    = 5
    refreshInterval	= 6000
    initHoldoff	= 10

    rsc_hostname = {
	type = derived
	refreshMode = sync
	refreshTrigger = system.total_model_changes:update
        refreshService = _services.sh
	refreshCommand = get_rsc_hostname.sh
    }

}

hardware-rules = { [ use templates.Config-Reader4uwg-models-d.hardware-rules ]
    oid = 47
    
    type            = passive
    
    rcr4u209 = {
	oid = 1
    }
    
    rcr4u212 = { 
	oid = 4
    }
    
    addremTbl = {
	oid = 14

	type = derived
	refreshMode = sync
	refreshTrigger = system.total_model_changes:update
	refreshCommand  = get_added_removed_nodes
        initInterval    = 5
	initHoldoff	= 10	
    }	
}

# pfa-rules = { [ use templates.Config-Reader4uwg-models-d.pfa-rules ]
#     type            = active
# }

#
# removed sena support
#


io_controller = { [ use templates.Config-Reader4uwg-models-d.io_controller ]
    oid = 49
    
    io_controllerTbl = {
	type            = derived
	refreshMode     = sync
	refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG io_controller 1 board# clock-frequency device_type fru instance model reg  upa-mid upa-portid version#
        initInterval    = 5
        refreshInterval = 6000
 	initHoldoff	= 10
	
	io_controllerTblEntry ={ 
	    fru = {
		oid = 13
	    }
	}
    }
}

io_device = { [ use templates.Config-Reader4uwg-models-d.io_device ]
    oid = 50 

    io_deviceTbl = {
	type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG io_device 1 device_type fru disk_count instance model node_hierarchy network_count reg tape_count
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
    
	io_deviceEntry = { 
	    fru = {
		oid = 12
	    }
	}
    }
}

disk = { [ use templates.Config-Reader4uwg-models-d.disk ]
    oid = 51

    diskTbl = {
	type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG disk 1 device_type name fru instance node_hierarchy target soft_errors hard_errors transport_errors
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
    }
}

tape = { [ use templates.Config-Reader4uwg-models-d.tape ]
    oid = 52
    
    tapeTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG tape 1 device_type fru instance model node_hierarchy tape_name status target soft_errors hard_errors transport_errors
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
    }
}

network = { [ use templates.Config-Reader4uwg-models-d.network ]
    oid = 53

    networkTbl = {
        type            = derived
        refreshMode     = sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG network 1 device_type fru ether inet name node_hierarchy symbol reg input_errors output_errors
        initInterval    = 5
        refreshInterval = 6000
	initHoldoff	= 10
	
	networkTblEntry ={ 
	    fru = {
		oid = 11
	    }
	}	
    }
}

io-unit = { [ use templates.Config-Reader4uwg-models-d.io-unit ]
    oid = 54
    
    type            = derived
    refreshMode     = sync
    refreshTrigger  = system.total_model_changes:update
    refreshCommand  = configdWG io-unit 1 board# device-id instance reg
    initInterval    = 5
    refreshInterval = 6000
    initHoldoff	= 10
}

generic-device = { [ use templates.Config-Reader4uwg-models-d.generic-device ]
    oid = 55
    
    generic-deviceTbl = {
 	type		= derived
 	refreshMode	= sync
        refreshTrigger  = system.total_model_changes:update
        refreshCommand  = configdWG generic-device 1 pathname_element
        initInterval    = 5
 	refreshInterval	= 6000
	initHoldoff	= 10
    }	
}








