#
#pragma ident "@(#)Config-Reader4uwg-models-d.x	1.22 01/01/19 Sun Microsystems"
#

type       = reference

_rules = { [ source Config-Reader4uwg-d.rul ] }


#
# A hack to send a sighup to picld on agent start
# For littleneck picl bug #4385806
#
picld = { [ use MANAGED-OBJECT ]
    mediumDesc = Picld Resetter
    consoleHint:hidden = true
    
    status = { [ use INT MANAGED-PROPERTY ]
	mediumDesc = Picld restart status
    }
}

system = { [ use MANAGED-OBJECT ]

    mediumDesc = System 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system
    consoleHint:smallIcon(DFT) = topoimages/general-ws-small.gif
    consoleHint:largeIcon(DFT) = topoimages/general-ws-large.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.sunSmTreeProp
	consoleHint:hidden = true

    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.sunSmNodeName
    }
    os = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Operating System
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.os
    }

    OS_version = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Operating System Version
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.OS_version
    }

    System_clock_frequency = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = System Clock Frequency
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.System_clock_frequency
    }

    architecture = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Architecture
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.architecture
    }

    hostname = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Hostname
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.hostname
    }

    machine = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Machine Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.machine
    }

    platform = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = System Platform 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.platform
    }
    sample = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        = Sampling Time 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.sample
    }

    serial_number = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        = Serial Number
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.serial_number
    }

    timestamp = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Timestamp
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.timestamp
    }

    timestamp_raw = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Raw Timestamp 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.timestamp_raw
    }
    total_disks = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Total Disks
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.total_disks
    }

    total_memory = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Total Memory
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.total_memory
    }

    total_processors = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Total Processors
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.total_processors
    }

    total_tape_devices = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        = Total Tape Devices
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.total_tape_devices
    }
    total_model_changes = { [ use INT MANAGED-PROPERTY ]
	mediumDesc        =  Number Of Model property/value changed
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.total_model_changes
	consoleHint:hidden = true
    }
    total_config_changes = { [ use INT MANAGED-PROPERTY ]
	mediumDesc        =  Number Of Times configuration changed.
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system.total_config_changes
	consoleHint:hidden = true
    }
}

system-board = { [ use MANAGED-OBJECT ]
    mediumDesc = System Board 
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.sunSmNodeName
    }
    fru = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc	 = FRU
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.fru
    }
    state = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = State
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.state
    }
    UNIX_Timestamp32 = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = UNIX_Timestamp32
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.UNIX_Timestamp32
    }
    Fru_Description = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Fru_Description
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Fru_Description
    }
    Manufacture_Loc = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Manufacture_Loc
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Manufacture_Loc
    }
    Sun_Part_No = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Sun_Part_No
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Sun_Part_No
    }
    Sun_Serial_No = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Sun_Serial_No
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Sun_Serial_No
    }
    Vendor_Name = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Vendor_Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Vendor_Name
    }
    Initial_HW_Dash_Level = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Initial_HW_Dash_Level
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Initial_HW_Dash_Level
    }
    Initial_HW_Rev_Level = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Initial_HW_Rev_Level
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Initial_HW_Rev_Level
    }
    Fru_Shortname = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Fru_Shortname
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-board.Fru_Shortname
    }
}

SUNWUltra-1 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-1 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-1
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-1.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-1.sunSmNodeName
    }
}

SUNWUltra-2 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-2 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-2
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-2.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-2.sunSmNodeName
    }
}

SUNWUltra-250 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-2 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-250
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-250.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-250.sunSmNodeName
    }

}

# SUNWUltra-60 and SUNWUltra-80 node names are added for 220R(razor) and 420R(quahog)

SUNWUltra-60 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-60
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-60
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-60.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-60.sunSmNodeName
    }

}

SUNWUltra-80 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-80
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-80
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-80.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-80.sunSmNodeName
    }

}

SUNWUltra-4 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-4
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-4
    
    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-4.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-4.sunSmNodeName
    }
    
}

SUNWUltra-5 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-5
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-5
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-5.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-5.sunSmNodeName
    }
}

SUNWUltra-10 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-10
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-10
    consoleHint:hidden = true
    
    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-10.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-10.sunSmNodeName
    }
}

SUNWUltra-5_10 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWUltra-5_10
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-5_10
    
    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-5_10.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWUltra-5_10.sunSmNodeName
    }
}


SUNWSun-Fire-280R = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWSun-Fire-280R
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-280R
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-280R.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-280R.sunSmNodeName
    }

}

SUNWSun-Fire-480R = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWSun-Fire-480R
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-480R
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-480R.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-480R.sunSmNodeName
    }

}

SUNWSun-Fire-880 = { [ use MANAGED-OBJECT ]
    mediumDesc = SUNWSun-Fire-880
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-880
    consoleHint:hidden = true

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-880.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWSun-Fire-880.sunSmNodeName
    }

}


# cpu board information
cpu-unit = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit
    consoleHint:smallIcon(DFT) = topoimages/CPU-module-small.gif
    consoleHint:largeIcon(DFT) = topoimages/CPU-module-xlarge.gif
    
    cpu-unitTbl = { [ use MANAGED-OBJECT-TABLE ]
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl
	
        cpu-unit-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.entry_no
	    }
	    clock-frequency = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Clock Frequency
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.clock-frequency
	    }
	    cpu-type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Cpu Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.cpu-type
	    }
	    dcache-size = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Dcache Size
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.dcache-size
	    }
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Device type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.device_type
	    }
	    ecache-size = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Ecache Size
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.ecache-size
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.fru
	    }
	    icache-size = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Icache Size
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.icache-size
	    }
	    model = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Model
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.model
	    }
	    pathname_element = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Pathname Element
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.pathname_element
	    }
	    processor-id = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Processor Id
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.processor-id
	    }
	    status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.status
		alarmRules        =  rcr4u207
	    }
	    unit = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Unit
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.unit
	    }
	    temperature = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc 	= Temperature
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.temperature
	    }
	    upa-portid = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Upa Portid
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-unit.cpu-unitTbl.cpu-unit-entry.upa-portid
	    }
	}
    }
}


# cpu board information

cpu-mem-module = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module
    consoleHint:smallIcon(DFT) = topoimages/CPU-module-small.gif
    consoleHint:largeIcon(DFT) = topoimages/CPU-module-xlarge.gif
    
    cpu-mem-moduleTbl = { [ use MANAGED-OBJECT-TABLE ]
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl
	

        cpu-mem-module-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.entry_no
	    }
	    num_cpus = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  Number of Cpus  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.num_cpus
	    }
	    num_dimms = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  Number of dimms
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.num_dimms
	    }
	    status = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc = Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.status
	    }
	    slot-name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc = slot-name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.slot-name
	    }
	    UNIX_Timestamp32 = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = UNIX_Timestamp32
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.UNIX_Timestamp32
	    }
	    Fru_Description = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Fru_Description
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Fru_Description
	    }
	    Manufacture_Loc = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Manufacture_Loc
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Manufacture_Loc
	    }
	    Sun_Part_No = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Sun_Part_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Sun_Part_No
	    }
	    Sun_Serial_No = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Sun_Serial_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Sun_Serial_No
	    }
	    Vendor_Name = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Vendor_Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Vendor_Name
	    }
	    Initial_HW_Dash_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Dash_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Initial_HW_Dash_Level
	    }
	    Initial_HW_Rev_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Rev_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Initial_HW_Rev_Level
	    }
	    Fru_Shortname = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Fru_Shortname
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-mem-module.cpu-mem-moduleTbl.cpu-mem-module-entry.Fru_Shortname
	    }
	}
    }
}


# memory controller

mc = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc
    consoleHint:smallIcon(DFT) = topoimages/memory-controller-small.gif
    consoleHint:largeIcon(DFT) = topoimages/memory-controller-xlarge.gif
    
    mcTbl = { [ use MANAGED-OBJECT-TABLE ]
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl
	
	mc-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl.mc-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl.mc-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl.mc-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl.mc-entry.entry_no
	    }
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl.mc-entry.device_type
	    }
	    fru_device = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = FRU Device
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:mc.mcTbl.mc-entry.fru_device
	    }
	}
    }
}


# memory bank table
bank = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank
    consoleHint:smallIcon(DFT) = topoimages/memory-bank-small.gif
    consoleHint:largeIcon(DFT) = topoimages/memory-bank-xlarge.gif

    bankTbl = { [ use MANAGED-OBJECT-TABLE ]
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl

        bank-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.entry_no
	    }
	    bank-size   = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Bank Size
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.bank-size
	    } 
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.device_type
	    }
	    fru_device = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = FRU Device
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.fru_device
	    }
	    status	= { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:bank.bankTbl.bank-entry.status
	    }
        } 
    }
}


# Dimm table
dimm = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm
    consoleHint:smallIcon(DFT) = topoimages/memory-small.gif
    consoleHint:largeIcon(DFT) = topoimages/memory-xlarge.gif
    
    dimmTbl = { [ use MANAGED-OBJECT-TABLE ]
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl
	
        dimm-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName 
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.entry_no
	    }
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.device_type
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.fru
	    }
	    fru_device = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc	  = FRU Device
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.fru_device
	    }
	    module-size = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Size 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.module-size
	    }

	    error-count = { [ use INTRULE MANAGED-PROPERTY _rules ]
		mediumDesc = Error Count
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.error-count
		alarmRules = rcr4u234    
	    }

	    socket-name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Socket Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.socket-name
	    }
	    status = { [ use STRINGRULE MANAGED-PROPERTY _rules]
		mediumDesc        =  Status 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.status
		alarmRules = rcr4u200
	    }
	    UNIX_Timestamp32 = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = UNIX_Timestamp32
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.UNIX_Timestamp32
	    }
	    Fru_Description = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Fru_Description
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Fru_Description
	    }
	    Manufacture_Loc = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Manufacture_Loc
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Manufacture_Loc
	    }
	    Sun_Part_No = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Sun_Part_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Sun_Part_No
	    }
	    Sun_Serial_No = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Sun_Serial_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Sun_Serial_No
	    }
	    Vendor_Name = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Vendor_Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Vendor_Name
	    }
	    Initial_HW_Dash_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Dash_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Initial_HW_Dash_Level
	    }
	    Initial_HW_Rev_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Rev_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Initial_HW_Rev_Level
	    }
	    Fru_Shortname = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Fru_Shortname
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:dimm.dimmTbl.dimm-entry.Fru_Shortname
	    }
	}
    }
}

# Simm Table
simm = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm
    consoleHint:smallIcon(DFT) = topoimages/memory-small.gif
    consoleHint:largeIcon(DFT) = topoimages/memory-xlarge.gif
    
    simmTbl    = { [ use MANAGED-OBJECT-TABLE ]
        mediumDesc = Simm Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl
	
        simm-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.entry_no
	    }
	    board_reference_number = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Board Reference Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.board_reference_number
	    }
	    error-count = { [ use INTRULE MANAGED-PROPERTY _rules ]
		mediumDesc = Error Count
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.error-count
		alarmRules = rcr4u234    
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.fru
	    }
	    size = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Size
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.size
	    }
	    slot = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Slot
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.slot
	    }
	    type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:simm.simmTbl.simm-entry.type
	    }
        }
    }
}

# Memory

memory    = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = Memory Table
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:memory

    memory-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	descColumn = sunSmNodeName
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:memory.memory-entry

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:memory.memory-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:memory.memory-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:memory.memory-entry.entry_no
	}
	pathname_element = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Pathname Element
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:memory.memory-entry.pathname_element
	}
    }
}

# key switch position

keyswitch = { [ use MANAGED-OBJECT ]
    mediumDesc = Keyswitch 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:keyswitch
    consoleHint:smallIcon(DFT) = topoimages/key-switch-small.gif
    consoleHint:largeIcon(DFT) = topoimages/key-switch-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:keyswitch.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:keyswitch.sunSmNodeName
    }
    position = { [ use STRINGNE MANAGED-PROPERTY ]
	mediumDesc        =  Position 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:keyswitch.position
    }
}

active-led = { [ use MANAGED-OBJECT ]
    mediumDesc = ActivityLED
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:active-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:active-led.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:active-led.sunSmNodeName
    }
    state = { [ use STRINGNE MANAGED-PROPERTY ]
	mediumDesc        =  State 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:active-led.state
    }
}

disk-error-led = { [ use MANAGED-OBJECT ]
    mediumDesc = DiskErrorLED
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-error-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-error-led.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-error-led.sunSmNodeName
    }
    state = { [ use STRINGNE MANAGED-PROPERTY ]
	mediumDesc        =  State
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-error-led.state
    }
}

gen-error-led = { [ use MANAGED-OBJECT ]
    mediumDesc = GeneralErrorLED 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:gen-error-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ] 
	consoleHint:hidden = true 
	mediumDesc        =  tree prop 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:gen-error-led.sunSmTreeProp
    } 
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
	mediumDesc        =  Name 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:gen-error-led.sunSmNodeName
    } 
    state = { [ use STRINGNE MANAGED-PROPERTY ] 
	mediumDesc        =  State  
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:gen-error-led.state
    } 
} 

power-led = { [ use MANAGED-OBJECT ]
    mediumDesc = PowerSupplyLED 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ] 
	consoleHint:hidden = true 
	mediumDesc        =  tree prop 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-led.sunSmTreeProp
    } 
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
	mediumDesc        =  Name 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-led.sunSmNodeName
    } 
    state = { [ use STRINGNE MANAGED-PROPERTY ] 
	mediumDesc        =  State  
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-led.state
    } 
} 

ps-error-led = { [ use MANAGED-OBJECT ]
    mediumDesc = PowerSupplyErrorLED 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ps-error-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ] 
	consoleHint:hidden = true 
	mediumDesc        =  tree prop 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ps-error-led.sunSmTreeProp
    } 
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
	mediumDesc        =  Name 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ps-error-led.sunSmNodeName
    } 
    state = { [ use STRINGNE MANAGED-PROPERTY ] 
	mediumDesc        =  State  
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ps-error-led.state
    } 
} 

temp-error-led = { [ use MANAGED-OBJECT ] 
    mediumDesc = TemperatureWarnLED  
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temp-error-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]  
	consoleHint:hidden = true  
	mediumDesc        =  tree prop  
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temp-error-led.sunSmTreeProp
    }  
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]  
	mediumDesc        =  Name  
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temp-error-led.sunSmNodeName
    }  
    state = { [ use STRINGNE MANAGED-PROPERTY ]  
	mediumDesc        =  State   
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temp-error-led.state
    }  
}  


# power_supply information
power-supply = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply
    consoleHint:smallIcon(DFT) = topoimages/power-supply-small.gif
    consoleHint:largeIcon(DFT) = topoimages/power-supply-xlarge.gif
    
    power-supplyTbl = { [ use MANAGED-OBJECT-TABLE ]
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl
	
        power_supply-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.entry_no
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.fru
	    }
	    state = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        = Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.state
		alarmRules        =  rcr4u203
	    }
	    UNIX_Timestamp32 = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = UNIX_Timestamp32
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.UNIX_Timestamp32
	    }
	    Fru_Description = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Fru_Description
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Fru_Description
	    }
	    Manufacture_Loc = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Manufacture_Loc
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Manufacture_Loc
	    }
	    Sun_Part_No = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Sun_Part_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Sun_Part_No
	    }
	    Sun_Serial_No = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Sun_Serial_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Sun_Serial_No
	    }
	    Vendor_Name = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Vendor_Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Vendor_Name
	    }
	    Initial_HW_Dash_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Dash_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Initial_HW_Dash_Level
	    }
	    Initial_HW_Rev_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Rev_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Initial_HW_Rev_Level
	    }
	    Fru_Shortname = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Fru_Shortname
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply.power-supplyTbl.power_supply-entry.Fru_Shortname
	    }
	}
    }
}

rsc = { [ use MANAGED-OBJECT ]
    
    mediumDesc = Remote System Controller (RSC)
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc
    consoleHint:smallIcon(DFT) = topoimages/general-ws-small.gif
    consoleHint:largeIcon(DFT) = topoimages/general-ws-large.gif

    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	consoleHint:hidden = true
	mediumDesc        =  tree prop
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.sunSmTreeProp
    }
    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.sunSmNodeName
    }
    device_type = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  Device Type
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.device_type
    }
    fru_device = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc        =  FRU Device 
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.fru_device
    }
    name = { [ use STRING MANAGED-PROPERTY ] 
	mediumDesc        =  Device Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.name
    }
    UNIX_Timestamp32 = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = UNIX_Timestamp32
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.UNIX_Timestamp32
    }
    Fru_Description = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Fru_Description
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Fru_Description
    }
    Manufacture_Loc = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Manufacture_Loc
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Manufacture_Loc
    }
    Sun_Part_No = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Sun_Part_No
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Sun_Part_No
    }
    Sun_Serial_No = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Sun_Serial_No
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Sun_Serial_No
    }
    Vendor_Name = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Vendor_Name
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Vendor_Name
    }
    Initial_HW_Dash_Level = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Initial_HW_Dash_Level
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Initial_HW_Dash_Level
    }
    Initial_HW_Rev_Level = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Initial_HW_Rev_Level
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Initial_HW_Rev_Level
    }
    Fru_Shortname = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc       = Fru_Shortname
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:rsc.Fru_Shortname
    }
    rsc_hostname = { [ use STRING MANAGED-PROPERTY ]
	mediumDesc	  = RSC Hostname
	consoleHine:mediumDesc = base.modules.Config-Reader4uwg:rsc.rsc_hostname
    }
}

fru-device = { [ use MANAGED-OBJECT ] 
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device
    consoleHint:smallIcon(DFT) = topoimages/board-small.gif
    consoleHint:largeIcon(DFT) = topoimages/board-xlarge.gif
    
    fru-deviceTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = SEEPROM Device Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl
	
	fru-device-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.entry_no
	    }
	    UNIX_Timestamp32 = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc       = UNIX_Timestamp32
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.UNIX_Timestamp32
	    }
	    Fru_Description = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc       = Fru_Description
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Fru_Description
	    }
	    Manufacture_Loc = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Manufacture_Loc
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Manufacture_Loc
	    }
	    Sun_Part_No = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc       = Sun_Part_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Sun_Part_No
	    }
	    Sun_Serial_No = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc       = Sun_Serial_No
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Sun_Serial_No
	    }
	    Vendor_Name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc       = Vendor_Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Vendor_Name
	    }
	    Initial_HW_Dash_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Dash_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Initial_HW_Dash_Level
	    }
	    Initial_HW_Rev_Level = { [ use STRING MANAGED-PROPERTY ]
                mediumDesc       = Initial_HW_Rev_Level
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Initial_HW_Rev_Level
	    }
	    Fru_Shortname = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc       = Fru_Shortname
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fru-device.fru-deviceTbl.fru-device-entry.Fru_Shortname
	    }
	}
    }
}

# fan  information

cpu-fans = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans
    consoleHint:smallIcon(DFT) = topoimages/fan-tray-small.gif
    consoleHint:largeIcon(DFT) = topoimages/fan-tray-xlarge.gif
    
    cpu-fansTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Fan Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl
	
        fan-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl.fan-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl.fan-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl.fan-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl.fan-entry.entry_no
	    }
	    status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl.fan-entry.status
		alarmRules        =  rcr4u204
	    }
	    speed = { [ use INTHILO MANAGED-PROPERTY ]
		mediumDesc        = Fan Speed
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-fans.cpu-fansTbl.fan-entry.speed
	    }
	}
    }
}


power-supply-fans = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans
    consoleHint:smallIcon(DFT) = topoimages/fan-tray-small.gif
    consoleHint:largeIcon(DFT) = topoimages/fan-tray-xlarge.gif

    power-supply-fansTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Power Supply Fan Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans.power-supply-fansTbl
	
	ps-fan-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans.power-supply-fansTbl.ps-fan-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans.power-supply-fansTbl.ps-fan-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans.power-supply-fansTbl.ps-fan-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans.power-supply-fansTbl.ps-fan-entry.entry_no
	    }
	    status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-fans.power-supply-fansTbl.ps-fan-entry.status
		alarmRules        =  rcr4u204
	    }
	}
    }
}

fan    = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = Fan Table
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan

    fan-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	descColumn = sunSmNodeName
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan.fan-entry

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan.fan-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan.fan-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number  
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan.fan-entry.entry_no
	}
	status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
	    mediumDesc        =  Status
	    alarmRules        =  rcr4u204
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan.fan-entry.status
	}
    }
}


ffb    = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = Ffb Table
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb

    ffb-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number  
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.entry_no
	}
	buffer	= { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Buffer Type
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.buffer
	}
	device_type = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Device Type
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.device_type
	}
	model = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Model
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.model
	}
	pathname_element = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Pathname Element
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:ffb.ffb-entry.pathname_element
	}
    }
}

afb    = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = Afb Table
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb
    consoleHint:hidden = true
    
    afb-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry
	
	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry number
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.entry_no
	}
	buffer  = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Buffer Type
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.buffer
	}
	device_type = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Device Type
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.device_type
	}
	model = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Model
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.model
	}
	pathname_element = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Pathname Element
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:afb.afb-entry.pathname_element
	}
    }
}


SUNWffb    = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = SUNWffb Table
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb
    consoleHint:hidden = true

    SUNWffb-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry

	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number  
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.entry_no
	}
	3DRAM = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  3DRAM
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.3DRAM
	}
	DAC = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  DAC
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.DAC
	}
	FBC_version = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  FBC Version
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.FBC_version
	}
	board_type = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Board Type
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.board_type
	}
	buffer = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Buffer
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.buffer
	}
	device_type = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Device Type
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.device_type
	}
	height = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Height
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.height
	}
	model = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Model
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.model
	}
	revision = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Revision
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.revision
	}
	upa-portid = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Upa Portid
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.upa-portid
	}
	width = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Width
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:SUNWffb.SUNWffb-entry.width
	}
    }
}


system-status-panel = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = System Status Panel
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-status-panel
    
    ssp-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-status-panel.ssp-entry
	
	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-status-panel.ssp-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-status-panel.ssp-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:system-status-panel.ssp-entry.entry_no
	}
    }
}

disk-status-leds = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = Disk Status LED Table
    consoleHint:hidden = true
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-status-leds
    
    disk-status-leds-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	descColumn = sunSmNodeName
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-status-leds.disk-status-leds-entry
	
	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-status-leds.disk-status-leds-entry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-status-leds.disk-status-leds-entry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-status-leds.disk-status-leds-entry.entry_no
	}
    }
}

disk-led = { [ use MANAGED-OBJECT ]
    mediumDesc = Disk LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif
    
    disk-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = Disk LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl
	
	disk-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl.disk-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl.disk-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl.disk-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl.disk-led-entry.entry_no
	    } 
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl.disk-led-entry.led-num
	    }  
	    state = { [ use STRINGNE MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk-led.disk-ledTbl.disk-led-entry.state
	    }      
	} 
    } 
}

fan-led = { [ use MANAGED-OBJECT ]
    mediumDesc = Fan LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif
    
    fan-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = Fan LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl
	
	fan-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl.fan-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl.fan-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl.fan-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl.fan-led-entry.entry_no
	    } 
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl.fan-led-entry.led-num
	    }  
	    state = { [ use STRINGNE MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:fan-led.fan-ledTbl.fan-led-entry.state
	    }  
	} 
    } 
}

cpu-led = { [ use MANAGED-OBJECT ]
    mediumDesc = CPU LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif
    
    cpu-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = CPU LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl
	
	cpu-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl.cpu-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl.cpu-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl.cpu-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl.cpu-led-entry.entry_no
	    } 
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl.cpu-led-entry.led-num
	    }  
	    state = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:cpu-led.cpu-ledTbl.cpu-led-entry.state
	    }  
	} 
    }
}

pci-led = { [ use MANAGED-OBJECT ]
    mediumDesc = PCI Card LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    pci-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = PCI Card LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl
	
	pci-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl.pci-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl.pci-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl.pci-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl.pci-led-entry.entry_no
	    } 
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl.pci-led-entry.led-num
	    }  
	    state = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:pci-led.pci-ledTbl.pci-led-entry.state
	    }  
	} 
    } 
}

service-led = { [ use MANAGED-OBJECT ]
    mediumDesc = Service Panel LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    service-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = Service Panel LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl
	
	service-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl.service-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl.service-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl.service-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl.service-led-entry.entry_no
	    } 
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl.service-led-entry.led-num
	    }   
	    state = { [ use STRINGNE MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:service-led.service-ledTbl.service-led-entry.state
	    }  
	} 
    } 
}

settable-led = { [ use MANAGED-OBJECT ]
    mediumDesc = Settable LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    settable-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = Settable LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl
	
	settable-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl.settable-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl.settable-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl.settable-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl.settable-led-entry.entry_no
	    } 
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl.settable-led-entry.led-num
	    }   
	    state = { [ use STRINGNE MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:settable-led.settable-ledTbl.settable-led-entry.state
	    }  
	} 
    } 
}

power-supply-led = { [ use MANAGED-OBJECT ]
    mediumDesc = Power Supply LEDs
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led
    consoleHint:smallIcon(DFT) = topoimages/LED-small.gif
    consoleHint:largeIcon(DFT) = topoimages/LED-xlarge.gif

    power-supply-ledTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = Power Supply LED Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl
	
	power-supply-led-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl.power-supply-led-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl.power-supply-led-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl.power-supply-led-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl.power-supply-led-entry.entry_no
	    }
	    led-num = { [ use STRING MANAGED-PROPERTY ]  
		mediumDesc        =  Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl.power-supply-led-entry.led-num
	    }   
	    state = { [ use STRINGNE MANAGED-PROPERTY ]  
		mediumDesc        =  State
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:power-supply-led.power-supply-ledTbl.power-supply-led-entry.state
	    } 
	} 
    } 
}


temperature-sensor = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor
    
    temperature-sensorTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc = Temperature Sensor Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl
	
        temperature-sensor-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no 
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true 
		mediumDesc        =  tree prop 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.sunSmTreeProp
	    } 
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ] 
		mediumDesc        =  Name 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.sunSmNodeName
	    } 
	    entry_no = { [ use INT MANAGED-PROPERTY ] 
		consoleHint:hidden = true 
		mediumDesc        =  Entry Number 
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.entry_no
	    }
	    temp = { [ use INTRULE MANAGED-PROPERTY _rules ]  
		mediumDesc        =  Temperature
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.temp
		alarmRules = rcr4u230
	    }  
	    highwarn = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  High Warning Threshold
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.highwarn
	    }
	    lowwarn = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  Low Warning Threshold
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.lowwarn
	    }
	    highfail = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  High Failure Threshold
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.highfail
	    }
	    lowfail = { [ use INT MANAGED-PROPERTY ]
		mediumDesc        =  Low Failure Threshold
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:temperature-sensor.temperature-sensorTbl.temperature-sensor-entry.lowfail
	    }
        } 
    } 
}

hardware-rules = { [ use MANAGED-OBJECT ]

    mediumDesc = Hardware Rules
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules 
    consoleHint:smallIcon(DFT) = topoimages/PFA-rules-small.gif
    consoleHint:largeIcon(DFT) = topoimages/PFA-rules-xlarge.gif
    #consoleHint:hidden = true

    rcr4u209 = { [ use RULE _rules MANAGED-PROPERTY ]
	mediumDesc        =  Memory Error
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.rcr4u209
	alarmRules        = rcr4u209
    }
    rcr4u212 = { [ use RULE _rules MANAGED-PROPERTY ]
	mediumDesc        =  Memory Error
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.rcr4u212
	alarmRules        = rcr4u212
    }

    rcr4u290 = { [ use RULE _rules MANAGED-PROPERTY ]
	mediumDesc        =  Memory Error
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.rcr4u290
        alarmRules	  = rcr4u290
    }	
    rcr4u291 = { [ use RULE _rules MANAGED-PROPERTY ]
	mediumDesc        =  Memory Error
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.rcr4u291
        alarmRules	  = rcr4u291
    }	



    addremTbl = { [ use MANAGED-OBJECT-TABLE ] 
	mediumDesc        = Added and Removed Nodes
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.addremTbl

	addremTblEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index         = entry_no
	    descColumn    = node-name
	    
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number  
	    }
	    unique_id = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc = Id
		consoleHint:hidden = true
	    }
	    node-name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc = Node Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.addremTbl.addremTblEntry.node-name	
	    }
	    add-rem = { [ use _rules STRINGRULE MANAGED-PROPERTY ]
		mediumDesc = Added or Removed
		alarmRules = rcr4u233
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:hardware-rules.addremTbl.addremTblEntry.add-rem
	    }
	}
    }
}

#
# io_controller information. These nodes are the nodes which head the
# IO device subtrees (currently sbus, pci, and sbi). These nodes are
# separated into a different table than io_device since controller nodes
# have a different generic set of properties.
#

io_controller = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller
    consoleHint:smallIcon(DFT) = topoimages/controller-small.gif
    consoleHint:largeIcon(DFT) = topoimages/controller-xlarge.gif

    io_controllerTbl = { [ use MANAGED-OBJECT-TABLE ]
	
        mediumDesc = IO Controllers Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl
	
        io_controllerTblEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.entry_no
	    }
	    
	    board_num = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Board Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.board_num
	    }
	    clock-frequency = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Clock Frequency
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.clock-frequency
	    }
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.device_type
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.fru
	    }
	    instance = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Instance Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.instance
	    }
	    model = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Model
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.model
	    }
	    reg = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Reg
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.reg
	    }
	    upa-mid = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = UPA Mid
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.upa-mid
	    }
	    upa-portid = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = UPA Portid
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.upa-portid
	    }
	    version_no = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Version Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_controller.io_controllerTbl.io_controllerTblEntry.version_no
	    }
        }
    }
}

#
# io_device information. These nodes are all those between {sbus,
# pci, sbi} and the leaf device nodes for disks, networks, and tapes.
# The properties listed here are a generic set of properties for these
# nodes. A particular node may have more properties, but we can only
# display the generic properties via SyMON.
#
io_device = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device
    consoleHint:smallIcon(DFT) = topoimages/IO-devices-small.gif
    consoleHint:largeIcon(DFT) = topoimages/IO-devices-xlarge.gif

    io_deviceTbl = { [ use MANAGED-OBJECT-TABLE ]
	
        mediumDesc = IO Devices
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl
	
        io_deviceEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.entry_no
	    }
	    
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.device_type
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.fru
	    }
	    disk_count = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Disk Count
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.disk_count
	    }
	    instance = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Instance Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.instance
		
	    }
	    model = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Model
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.model
	    }
	    node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        = Node Hierarchy
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.node_hierarchy
	    }
	    network_count = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Network Count
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.network_count
	    }
	    reg = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Reg
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.reg
	    }
	    tape_count = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Tape Count
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io_device.io_deviceTbl.io_deviceEntry.tape_count
	    }
        }
    }
}


# disk  information
disk    = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk
    consoleHint:smallIcon(DFT) = topoimages/disks-small.gif
    consoleHint:largeIcon(DFT) = topoimages/disks-xlarge.gif
    
    diskTbl    = { [ use MANAGED-OBJECT-TABLE ]
        mediumDesc = Disk Devices
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl
	
        diskEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.entry_no
	    }
	    
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.device_type
	    }
	    disk_name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Disk Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.disk_name
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.fru
	    }
	    instance = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Instance Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.instance
	    }
	    #           mounted_partitions = { [ use STRING MANAGED-PROPERTY ]
	    #               mediumDesc        = Mounted Partitions
	    #           }
	    node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        = Node Hierarchy
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.node_hierarchy
	    }
	    target = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Disk Target
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.target
	    }
	    soft_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
		mediumDesc        = Soft Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.soft_errors
		alarmRules = rcr4u234
	    }
            hard_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
	        mediumDesc        = Hard Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.hard_errors
		alarmRules = rcr4u234
	    }
	    transport_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
	    	mediumDesc        = Transport Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:disk.diskTbl.diskEntry.transport_errors
		alarmRules = rcr4u234
	    }
        }
    }
}

# tape  information
tape = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape
    consoleHint:smallIcon(DFT) = topoimages/tape-small.gif
    consoleHint:largeIcon(DFT) = topoimages/tape-xlarge.gif

    tapeTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Tape Devices
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl
	
        tapeEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.entry_no
	    }
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.device_type
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Field Replaceable
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.fru
	    }
	    instance = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Instance Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.instance
	    }
	    model = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        = Model
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.model
	    }
	    node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        = Node Hierarchy
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.node_hierarchy
	    }
	    tape_name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Tape Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.tape_name
	    }
	    status = { [ use STRINGRULE MANAGED-PROPERTY _rules ]
		mediumDesc        =  Status
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.status
		alarmRules        =  rcr4u225
	    }
	    target = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Tape Target
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.target
	    }
	    soft_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
		mediumDesc        = Soft Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.soft_errors
		alarmRules = rcr4u234
	    }
            hard_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
	        mediumDesc        = Hard Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.hard_errors
		alarmRules = rcr4u234
	    }
	    transport_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
	    	mediumDesc        = Transport Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:tape.tapeTbl.tapeEntry.transport_errors
		alarmRules = rcr4u234
	    }
        }
    }
}


# Network devices
network = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network
    consoleHint:smallIcon(DFT) = topoimages/network2-small.gif
    consoleHint:largeIcon(DFT) = topoimages/network2-xlarge.gif
    
    
    networkTbl = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = Network Device Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl
	
        networkEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Entry Number
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.entry_no
	    }
	    device_type = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Device Type
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.device_type
	    }
	    fru = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  FRU
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.fru
	    }
	    ether = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Ethernet Address
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.ether
	    }
	    inet = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Internet Address
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.inet
	    }
	    interface_name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Interface Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.interface_name
	    }
	    node_hierarchy = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        = Node Hierarchy
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.node_hierarchy
	    }
	    symbolic_name = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Symbolic Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.symbolic_name
	    }
	    reg = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  Reg
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.reg
	    }
	    input_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
		mediumDesc        = Input Errors
	    	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.input_errors
		alarmRules = rcr4u234
	    }
            output_errors = { [ use INTRULE MANAGED-PROPERTY _rules ]
	        mediumDesc        = Output Errors
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:network.networkTbl.networkEntry.output_errors
		alarmRules = rcr4u234
	    }
	}
    }
}


io-unit = { [ use MANAGED-OBJECT-TABLE ]
    mediumDesc = Io Unit
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit
    consoleHint:hidden = true

    io-unitEntry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	index = entry_no
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry
	
	sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  tree prop
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.sunSmTreeProp
	}
	sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Name
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.sunSmNodeName
	}
	entry_no = { [ use INT MANAGED-PROPERTY ]
	    consoleHint:hidden = true
	    mediumDesc        =  Entry Number
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.entry_no
	}
	
	board_num = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Board Number
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.board_num
	}
	device-id = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Device Id
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.device-id
	}
	instance = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Instance
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.instance
	}
	reg = { [ use STRING MANAGED-PROPERTY ]
	    mediumDesc        =  Reg
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:io-unit.io-unitEntry.reg
	}
    }
}

generic-device    = { [ use MANAGED-OBJECT ]
    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device
    consoleHint:hidden = true
    consoleHint:smallIcon(DFT) = topoimages/IO-devices-small.gif
    consoleHint:largeIcon(DFT) = topoimages/IO-devices-xlarge.gif

    generic-deviceTbl    = { [ use MANAGED-OBJECT-TABLE ]
	mediumDesc = OBP Device Table
	consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device.generic-deviceTbl
	
        generic-device-entry = { [ use MANAGED-OBJECT-TABLE-ENTRY ]
	    index = entry_no
	    descColumn = sunSmNodeName
	    mediumDesc = Table Entry
	    consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device.generic-deviceTbl.generic-device-entry
	    
	    sunSmTreeProp = { [ use STRING MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  tree prop
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device.generic-deviceTbl.generic-device-entry.sunSmTreeProp
	    }
	    sunSmNodeName = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Name
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device.generic-deviceTbl.generic-device-entry.sunSmNodeName
	    }
	    entry_no = { [ use INT MANAGED-PROPERTY ]
		consoleHint:hidden = true
		mediumDesc        =  entry number  
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device.generic-deviceTbl.generic-device-entry.entry_no
	    }
	    pathname_element = { [ use STRING MANAGED-PROPERTY ]
		mediumDesc        =  Pathname Element
		consoleHint:mediumDesc = base.modules.Config-Reader4uwg:generic-device.generic-deviceTbl.generic-device-entry.pathname_element
	    }
	}
    }
}


[ load Config-Reader4uwg-ruleinit-d.x ]
[ load Config-Reader4uwg-ruletext-d.x ]


