#!/bin/ksh
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2001 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#


Trace_Subsystems()
{
echo "#   Trace Subsystems: begin at `$DATECMD`"  >> $LOGFILE
$MYNAME.Pro_Sub$BAMSHELL
echo "#   Trace Subsystems: end   at `$DATECMD`"  >> $LOGFILE
}

Trace_Messages()
{
echo "#   Trace Messages: begin at `$DATECMD`"  >> $LOGFILE
$MYNAME.Pro_Msg$BAMSHELL
echo "#   Trace Messages: end   at `$DATECMD`"  >> $LOGFILE
}

Error_Log()
{
echo "#   Error Log: begin at `$DATECMD`"  >> $LOGFILE
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "BATCH            Problem Determination: Error Log            $DATEVAR"
echo "#   Starting lgprint command:{" >> $LOGFILE
lgprint 1>> $LOGFILE 2>&1
cat $PUBLIC/msg/elog_print >> $LOGFILE
echo "#   }The end of the lgprint command." >> $LOGFILE
${PAGER-'/bin/more'} $PUBLIC/msg/elog_print
echo "Press Return to Continue"
read risp
echo "#   Error Log: end   at `$DATECMD`"  >> $LOGFILE
}

Trace_Processes()
{
echo "#   Trace Processes: begin at `$DATECMD`"  >> $LOGFILE
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "BATCH            Problem Determination: Trace Processes      $DATEVAR"
ebminfo > /tmp/trace.$$
currdir=`pwd`
cd $PACK
ls -a .*err* 2>$DEVNULL \
           | sed -e 's/\.elg\./\.lgdem\./' \
           | sed -e 's/\.ebm\./\.ebmmd\./' \
           | sed -e 's/\.psg\./\.psg_d\./' \
           | sed -e 's/\.err/ /' \
           | sed -e 's/\./ /' > /tmp/ebmprocs.$$
cat /tmp/ebmprocs.$$ | while read procline
do
  set $procline
  echo "#" >>  /tmp/trace.$$
  echo "# Error message from process $1, PID $2:" >>  /tmp/trace.$$
  echo "#" >>  /tmp/trace.$$
  cat .*.err$2 >> /tmp/trace.$$
  echo "#" >>  /tmp/trace.$$
done
cd $currdir
echo "#   Starting ebminfo command:{" >> $LOGFILE
cat /tmp/trace.$$ >> $LOGFILE
echo "#   }The end of the ebminfo command." >> $LOGFILE
${PAGER-'/bin/more'} /tmp/trace.$$
echo "Press Return to Continue"
read risp
rm /tmp/trace.$$
rm /tmp/ebmprocs.$$
echo "#   Trace Processes: end   at `$DATECMD`"  >> $LOGFILE
}

Verify_Disk_Space()
{
case $EBM_OS_NAME in
   NT)
      if [ ! -f $CHECKDISKS ]
      then
        echo "# ERROR. $CHECKDISKS not found" >> $LOGFILE
        xebmbox SEVERE+Verify Disk Space+ERROR. Configuration File not found.
        return
      fi
      xebmbox INFORMATION+Verify Disk Space+Checking Disk Space. Please Wait ... &
      sleep 2
      $CHECKDISKS
      sleep 2
      xebmbox INFORMATION+Verify Disk Space+Verification Completed Successfully.
      ;;
   *)
      if [ ! -f $CHECKDISKS ]
      then
        echo "# ERROR. $CHECKDISKS not found" >> $LOGFILE
        $KIXCLS
        DATEVAR="`$DATEVARFILE`"; export DATEVAR
        echo "BATCH            Problem Determination                       $DATEVAR"
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo " "
        echo "  ERROR. Configuration File ot found"
        echo " "
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo "--------------------------------------------------------------------------------"
        echo "Press Return to Continue"
        read risp
        return
      fi
      echo "Checking Disk Space. Please Wait ...."
      sleep 2
      rm -f /tmp/bam.checkdisks.$$
      touch /tmp/bam.checkdisks.$$
      chmod 666 /tmp/bam.checkdisks.$$
      $CHECKDISKS > /tmp/bam.checkdisks.$$
      if [ ! -s /tmp/bam.checkdisks.$$ ]
      then
        $KIXCLS
        DATEVAR="`$DATEVARFILE`"; export DATEVAR
        echo "BATCH            Problem Determination: Verify Disk Space    $DATEVAR"
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo "  Verification Completed Successfully."
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo ""
        echo "--------------------------------------------------------------------------------"
        case "$BAM_SKILL_0_6" in
          7) rm -f /tmp/bam.checkdisks.$$
             exit 0
             ;;
          ""|*)
            echo "Press Return to Continue"
            read risp
            rm -f /tmp/bam.checkdisks.$$
            return
            ;;
        esac
      else
        case "$BAM_SKILL_0_6" in
          7) cat /tmp/bam.checkdisks.$$
             rm -f /tmp/bam.checkdisks.$$
             exit 1
             ;;
          ""|*) 
            ${PAGER-'/bin/more'} /tmp/bam.checkdisks.$$
            echo "Press Return to Continue"
            read risp
            rm -f /tmp/bam.checkdisks.$$
            return
            ;;
        esac
      fi
      ;;
esac
}

EBM_SnapShot()
{
echo "#   Create Snap Shot begin at `$DATECMD`"  >> $LOGFILE
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "BATCH            Problem Determination: Create Snap Shot     $DATEVAR"
echo " "
echo " "
echo " "
echo " "
echo "#   Starting ebmsnap command:{" >> $LOGFILE
ebmsnap 2>> $LOGFILE
echo "#   }The end of the ebmsnap command." >> $LOGFILE
echo " "
echo " "
echo " "
echo "Press Return to Continue"
read risp
echo "#   Create Snap Shot: end   at `$DATECMD`"  >> $LOGFILE
}

Dump_Memory()
{
echo "#   Dump Memory: begin at `$DATECMD`"  >> $LOGFILE
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "BATCH            Problem Determination: Dump Memory          $DATEVAR"
echo "#   Starting shmdump/infjbs command:{" >> $LOGFILE
shmdump 1> /tmp/dump.$$ 2>&1
infjbs 1>> /tmp/dump.$$ 2>&1
cat /tmp/dump.$$ >> $LOGFILE
echo "#   }The end of the shmdump/infjbs command." >> $LOGFILE
${PAGER-'/bin/more'} /tmp/dump.$$
rm /tmp/dump.$$
echo "Press Return to Continue"
read risp
echo "#   Dump Memory: end   at `$DATECMD`"  >> $LOGFILE
}

Check_EBM_Up()
{
if [ ! -f $PACK/etc/EBM.ACT ]
then
  echo "# ERROR. BATCH system must be active." >> $LOGFILE
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "BATCH            Problem Determination                       $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo " "
  echo "  ERROR. The BATCH system must be active."
  echo " "
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo "--------------------------------------------------------------------------------"
  echo "Press Return to Continue"
  read risp
  exit 1
fi
ebminfo -p > $DEVNULL 2>&1
if [ $? -ne 0 ]
then
  echo "# ERROR. BATCH system must be active." >> $LOGFILE
  $KIXCLS
  DATEVAR="`$DATEVARFILE`"; export DATEVAR
  echo "BATCH            Problem Determination                       $DATEVAR"
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo " "
  echo "  ERROR. The BATCH system must be active."
  echo " "
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo ""
  echo "--------------------------------------------------------------------------------"
  echo "Press Return to Continue"
  read risp
  exit 1
fi
}

case "$BAM_SKILL_0_6" in
     7) Verify_Disk_Space
        exit 0
        ;;
     ""|*) ;;
esac
Pro_loop=1
while [ $Pro_loop -ne 0 ]
do
# Begin Pro Menu Loop {
# this line clears the screen 
$KIXCLS
DATEVAR="`$DATEVARFILE`"; export DATEVAR
echo "BATCH            Problem Determination                       $DATEVAR"
echo " "
echo " "
echo " "
echo " "
echo " "
echo "             1   Error Log"
echo "             2   Admlog"
echo "             3   Trace Subsystems"
echo "             4   Trace Processes"
echo "             5   Trace Messages"
echo "             6   Dump Memory"
echo "             7   Verify Disk Space"
echo "             8   Create Snap Shot"
echo " "
echo " "
echo "             H - Help"
echo "             R - Return Main Menu"
echo " "
echo "--------------------------------------------------------------------------------"
echo $N "Enter the option number corresponding to the selection you want: $C"
read opt
case $opt in
     1) Check_EBM_Up
        Error_Log
        ;;
     2) Check_EBM_Up
        admlog
        ;;
     3) Check_EBM_Up
        Trace_Subsystems
        ;;
     4) Check_EBM_Up
        Trace_Processes
        ;;
     5) Check_EBM_Up
        Trace_Messages
        ;;
     6) Check_EBM_Up
        Dump_Memory
        ;;
     7) Verify_Disk_Space
        ;;
     8) EBM_SnapShot
        ;;
     R|r|"")
        Pro_loop=0
        ;;
     H|h)   
        $KIXCLS
        DATEVAR="`$DATEVARFILE`"; export DATEVAR
        echo "BATCH            Problem Determination                       $DATEVAR"
        ${PAGER-'/bin/more'} $PACK/etc/$MYNAME.Pro.help
        echo "Press Return to Continue"
        read risp
     ;;
     *) echo "#"
        echo "# ERROR. Invalid Option"
        echo "#"
        echo "Press Return to Continue"
        read risp
     ;;
esac
# End Pro Menu Loop }
done
exit 0
