#!/bin/ksh
MYNAME=`basename $0`; export MYNAME
USER=$1;export USER
FILENAME=$2;export FILENAME
JOBNAME=$3;export JOBNAME
JOBTYPE=$4;export JOBTYPE
SUBSYS=$5; export SUBSYS
WKDIR=$6/$SUBSYS; export WKDIR

echo ""
echo "--------------------------------------------------------------------------------"
echo Starting $MYNAME with option:
echo File Name : $FILENAME
echo Job Name  : $JOBNAME
echo User Name : $USER
echo Job Type  : $JOBTYPE
echo Subsystem : $SUBSYS
echo Working Dir: $WKDIR

cd $WKDIR
if [ $? -ne 0 ]
then
  echo "$MYNAME: Error accessing Workind Dir $WKDIR"
  echo "--------------------------------------------------------------------------------"
  exit 2
fi

if [ ! -f $JOBTYPE/$FILENAME ]
then
  echo "$MYNAME: $JOBTYPE/$FILENAME not found under `pwd`"
  echo "--------------------------------------------------------------------------------"
  exit 3
fi

if [ ! -z "$EBMSYS" ]
then
  unset EBMSYS
fi

if [ ! -z "$KIXSYS" ]
then
  unset KIXSYS
fi

. $EBMHOME/batchenv $SUBSYS

if [ -z "$EBMSYS" ]
then
  echo "$MYNAME: Error, unable to set $SUBSYS environemnt"
  echo "--------------------------------------------------------------------------------"
  exit 4
fi

case $JOBTYPE in
  "jmvs")
         if [ ! "$FILENAME" = "$JOBNAME" ]
         then
           mv jmvs/$FILENAME jmvs/$JOBNAME
           if [ $? -ne 0 ]
           then
             echo "$MYNAME: Error renaming $FILENAME as $JOBNAME"
             echo "--------------------------------------------------------------------------------"
             exit 5
           fi
           chmod 666 jmvs/$JOBNAME
         fi
         echo "$MYNAME: Begin of MVS JCL FileName:$FILENAME-JobName:$JOBNAME {"
         cat jmvs/$JOBNAME
         echo "$MYNAME: End of MVS JCL FileName:$FILENAME-JobName:$JOBNAME }"
         if [ -f ish/$JOBNAME ]
         then
           rm ish/$JOBNAME
           if [ $? -ne 0 ]
           then
             echo "$MYNAME: Error deleting ish/$JOBNAME"
             echo "--------------------------------------------------------------------------------"
             exit 15
           fi
         fi
         mvstrans $JOBNAME $MVSTRANS_OPT
         if [ $? -ne 0 ]
         then
           rm -f jmvs/$JOBNAME
           rm -f ish/$JOBNAME
           if [ -d error ]
           then
             mv ish/$JOBNAME.* error/.
             chmod 666 error/$JOBNAME.*
           else
             rm ish/$JOBNAME.*
           fi
           echo "$MYNAME: Error translating FileName:$FILENAME-JobName:$JOBNAME"
           echo "--------------------------------------------------------------------------------"
           exit 26
         fi
         ;;
  "jdos")
         if [ ! "$FILENAME" = "$JOBNAME" ]
         then
           mv jdos/$FILENAME jdos/$JOBNAME
           if [ $? -ne 0 ]
           then
             echo "$MYNAME: Error renaming $FILENAME as $JOBNAME"
             echo "--------------------------------------------------------------------------------"
             exit 6
           fi
           chmod 666 jdos/$JOBNAME
         fi
         echo "$MYNAME: Begin of VSE JCL FileName:$FILENAME-JobName:$JOBNAME {"
         cat jdos/$JOBNAME
         echo "$MYNAME: End of VSE JCL FileName:$FILENAME-JobName:$JOBNAME }"
         if [ -f ish/$JOBNAME ]
         then
           rm ish/$JOBNAME
           if [ $? -ne 0 ]
           then
             echo "$MYNAME: Error deleting ish/$JOBNAME"
             echo "--------------------------------------------------------------------------------"
             exit 16
           fi
         fi
         dostrans $JOBNAME $DOSTRANS_OPT
         if [ $? -ne 0 ]
         then
           rm -f jdos/$JOBNAME
           rm -f ish/$JOBNAME
           if [ -d error ]
           then
             mv ish/$JOBNAME.* error/.
             chmod 666 error/$JOBNAME.*
           else
             rm ish/$JOBNAME.*
           fi
           echo "$MYNAME: Error translating FileName:$FILENAME-JobName:$JOBNAME"
           echo "--------------------------------------------------------------------------------"
           exit 7
         fi
         ;;
  "ish")
         ;;
esac

echo "$MYNAME: Begin of BATCH Job $JOBNAME {"
cat ish/$JOBNAME
echo "$MYNAME: End of BATCH Job $JOBNAME }"
if [ ! -z "$KIXSYS" ]
then
  echo "$MYNAME: unikixjob $JOBNAME -k$EBMSYS -JAutoSub"
  unikixjob $JOBNAME -k$EBMSYS -JAutoSub
  ret=$?
else
  echo "$MYNAME: subjob $JOBNAME -k$EBMSYS -JAutoSub"
  subjob $JOBNAME -k$EBMSYS -JAutoSub
  ret=$?
fi
if [ $ret -ne 0 ]
then
  echo "$MYNAME: Error, submit command aborted"
else
  rm $JOBTYPE/$JOBNAME
  if [ $? -ne 0 ]
  then
    echo "$MYNAME: Error, deleting job $JOBTYPE/$JOBNAME"
    ret=28
  fi
fi
rm -f ish/$JOBNAME
echo "--------------------------------------------------------------------------------"
exit $ret
