
/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/



/* $Date:   18 Sep 2001 13:54:08  $ */
/* $Modtime:   17 Sep 2001 16:08:56  $ */

#ifndef	lint
#ifdef __STDC__
const
#endif
static char sccsid[] = "@(#) $Workfile:   runfs.c  $ $Revision:   1.0  $";
#endif

/*
 * $Log:   /unikix/source2/SunMBM9.2.0/unikixebm/ebmsrc/rtsfs/PVCS/runfs.c_v  $
 * 
 *    Rev 1.0   18 Sep 2001 13:54:08   unikix
 * Initial 9.2
 * 
 *    Rev 1.1   08 Mar 2001 16:07:46   giulio
 * B7608
 * postponed the rdbms allocate action until the terminal redirection is executed.
 * 
 *    Rev 1.0   31 Jan 2000 15:35:00   unikix
 * Initial 9.0
 * 
 *    Rev 1.3   12/12/97 14:50:02   giulio
 * 2675
 * 
 *    Rev 1.2   10/24/96 11:46:38   giulio
 * B001734
 * runfs.c (like runner.c) uses the unikixcom/src/usrsrc user exit functions
 * those functions are shared with the TRANS usr exit calls.
 * runfs.c now checks if the allocate function failed, if yes the program aborts.
 * 
 *    Rev 1.1   10/03/96 09:36:28   giulio
 * B001783
 * runfs_stop receives now one more parameter the cond code passed to the
 * CCF_SET_CONDCODE function from the COBOL program.
 * runfs_stop does not rollback anymore if return code if <0 or >4095
 * runfs_stop rollback now if cond code passed is not 0.
 * The messages showing commit and rollback are changed.
 * The message showing the return-code is changed to show also the condcode.
 * 
 *    Rev 1.0   08/16/96 15:02:04   unikix
 * Initial EBM8.1.0.0
 * 
 */
/**********************************************************************/

# include  <stdio.h>
# include  <fcntl.h>
# include  <errno.h>
# include  <sys/types.h>
#define MAX_APPL_LENGTH 8
char rts_rdbms[ MAX_APPL_LENGTH + 1 ];

extern FILE *fdbug;
int     rts_debug;    
char    rtsfs_xtermdev[30];
static int      rtsfs_savefd[3];
static char     rtsfs_hstr[80] = "";

rtsfs_cobsw(pdebug)
int pdebug;
{
    char    *lenv;      /*environment value for COBSW*/
    int     lrc;
    int     lcurlen;
    int     i, k;
    char    *lcp;
    char    lstr[80];

    lenv = (char*)getenv("COBSW");
    if (lenv == NULL) {
	if (pdebug) {
		strcpy(rtsfs_hstr, "COBSW=+A");
		lrc = putenv(rtsfs_hstr);
		return(lrc);
	}
    } else {
        if((lcp=(char*)strchr(lenv,'A'))==NULL) {
            if (pdebug) {
		    strcpy(lstr, "COBSW=");
		    strcat(lstr, lenv);     
		    strcat(lstr, "+A");    
		    strcpy(rtsfs_hstr, lstr);
		    lrc = putenv(rtsfs_hstr);
		    return(lrc);
            }
        } else {
            strcpy(lstr, "COBSW=");
            k = strlen(lenv);
            lcurlen = strlen(lstr);
            for (i = 0; i < k; i++) {
		    if (lenv [i + 1] == 'A') {
			    i++;
		    } else {
			    lstr[lcurlen] = lenv[i];
			    lcurlen++;
		    }
            }
	    lstr[lcurlen] = '\0';
            if (pdebug) {
		    strcat(lstr, "+A");
            }
            strcpy(rtsfs_hstr, lstr);
            lrc = putenv(rtsfs_hstr);
            return(lrc);
        }
    }
    return(0);
}



rtsfs_animate (pcmd)
int pcmd;
{
    int lrc;

    if (rts_debug == 0) {
        return;
    }
    switch (pcmd) {
	    case 0: {
		rtsfs_reopenm(0);
		rtsfs_reopenm(1);
		rtsfs_reopenm(2);
		break;
	    }
	    case 1: {
		rtsfs_reopena(0, rtsfs_xtermdev, O_RDWR);
		rtsfs_reopena(1, rtsfs_xtermdev, O_WRONLY+O_APPEND);
		rtsfs_reopena(2, rtsfs_xtermdev, O_WRONLY);
		break;
	    }
    }
    return;
}


rtsfs_reopena(pfildes,  pttyname, paccess)
int pfildes;
char    *pttyname;
int paccess;
{
    int lrc;

    rtsfs_savefd [pfildes] = dup (pfildes);
    close (pfildes);
    lrc = open(pttyname, paccess, 666);
    if (lrc != pfildes) {
	    if (lrc < 0) {
		printf("rtsfs_reopena: reopen of %d failed, errno=%d\n",
		    pfildes,errno);
	    } else {
		printf("rtsfs_reopena: reopen of %d returned %d\n",
		    pfildes, lrc);
	    }
	    exit (-1);
    }
    return;
}

rtsfs_reopenm(pfildes)
int pfildes;
{
    int lrc;

    close (pfildes);
    lrc = dup (rtsfs_savefd[pfildes]);
    close (rtsfs_savefd[pfildes]);
    rtsfs_savefd[pfildes] = lrc;
    if (lrc != pfildes) {
	    if (lrc < 0) {
		printf("rtsfs_reopenm: reopen of %d failed, errno=%d\n",
		    pfildes,errno);
	    } else {
		printf("rtsfs_reopenm: reopen of %d returned %d\n",
		    pfildes, lrc);
	    }
	    exit (-1);
    }
return;
}

runfs_main ()
{
int fscode;
char *test_appl;
char*ebmanim;

        fscode = 0;
	memset(rts_rdbms,'\0',MAX_APPL_LENGTH+1);
	if((test_appl=(char *)getenv("RTS_RDBMS"))!=NULL) {
		if(strlen(test_appl) > MAX_APPL_LENGTH) {
			printf("rtsfs: warning invalid application name\n");
			strcpy(rts_rdbms,"NO_RDBMS");
		} else {
			strcpy(rts_rdbms,test_appl);
		}
	} else {
		strcpy(rts_rdbms,"NO_RDBMS");
	}
	if((ebmanim=(char *)getenv("EBMANIM"))!=NULL) {
		if(*ebmanim=='/') {
			rts_debug=1;
			strcpy((char *)rtsfs_xtermdev, ebmanim);
			if(fdbug!=NULL) {
					fprintf(fdbug, "rtsfs batch:xtermdev=%s ebmanim=%s\n",rtsfs_xtermdev,ebmanim);
					fflush(fdbug);
			}
		}
	}
	if(rts_debug) {
		if(fdbug!=NULL) {
				fprintf(fdbug, "starting anm on %s\n",rtsfs_xtermdev);
				fflush(fdbug);
		}
		rtsfs_cobsw(1);
		rtsfs_animate(1);
	} else {
		if(fdbug!=NULL) {
				fprintf(fdbug, "starting rtsfs_cobsw(0)\n");
				fflush(fdbug);
		}
		rtsfs_cobsw(0);
	}
        if (fscode = fsuser_allocate()) {
           printf("rtsfs: user exit allocate function returned code %d\n",
                          fscode);
           ebmcobexit(-1);
        }
        return(0);
}

runfs_stop(retcode,ccode)
short retcode;
short ccode;
{
int fscode;

	if(rts_debug) {
		rtsfs_animate(0);
	}
	if (ccode != 0) {
		printf("rtsfs: RETURN-CODE=%d, COND-CODE=%d\n", retcode, ccode);
		fsuser_rollback();
		printf("rtsfs: user exit rollback function executed\n");
	} else {
		printf("rtsfs: RETURN-CODE=%d, COND-CODE=%d\n", retcode, ccode);
		fsuser_commit();
		printf("rtsfs: user exit commit function executed\n");
	}
 fscode = 0;
 if (fscode = fsuser_deallocate()) {
  printf("rtsfs: user exit deallocate function returned code %d\n", fscode);
 }
	return(0);
}
