#!/bin/ksh
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2001 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#


EBM_PLI_VERSION="ebm_pli_obj.mk 1.0 97/01/30"
DEBUGFILE=./.ebm_pli_obj.lst
rm -f $DEBUGFILE 2>/dev/null
echo "+++"                   > $DEBUGFILE
echo "+++ $EBM_PLI_VERSION" >> $DEBUGFILE
echo "+++ date    :: `date`" >> $DEBUGFILE
echo "+++ execfile:: $EXEFILE" >> $DEBUGFILE
echo "+++ options :: $*"     >> $DEBUGFILE
chmod 777 $DEBUGFILE
vsam_flag=0
oracle_flag=0
for liantopt in $*
do
  case $liantopt in
    -vsam)
      vsam_flag=1
    ;;
    -oracle)
      oracle_flag=1
    ;;
    *)
      echo "::ebm_pli_obj.mk::${liantopt}::unknown_option::"
      echo "+++ ebm objs::ebm_pli_obj.mk::${liantopt}::unknown_option::" >> $DEBUGFILE
      exit 1
    ;;
  esac
done
# BATCH only
if [ $oracle_flag -eq 0 -a $vsam_flag -eq 0 ]
then
  FILES="$PACK/RTSFS/ebmplidate.o $PACK/RTSFS/el_date.o"
fi

# BATCH and VSAM
if [ $oracle_flag -eq 0 -a $vsam_flag -eq 1 ]
then
  FILES="$PACK/RTSFS/ebmplidate.o $PACK/RTSFS/el_date.o"
  rm -f libbcisam.a
  rm -f libbcisam.o
  cp $UNIKIX/lib/libbcisam.a .
  if [ $? -ne 0 ]
  then
      echo "::ebm_pli_obj.mk::./libbcisam.a::permission_denied::"
      echo "::ebm_pli_obj.mk::./libbcisam.a::permission_denied::" >> $DEBUGFILE
    exit 1
  fi
  chmod 666 libbcisam.a
  ar -x libbcisam.a libbcisam.o
  chmod 666 ./libbcisam.o
  ar -d libbcisam.a libbcisam.o
  FILES="$FILES ./libbcisam.o"
  FILES="$FILES ./libbcisam.a"
fi

# BATCH and ORACLE
if [ $oracle_flag -eq 1 -a $vsam_flag -eq 0 ]
then
  $PACK/RTSFS/plioracle.mk $PACK/RTSFS
  if [ $? -ne 0 ]
  then
      echo "::ebm_pli_obj.mk::$PACK/RTSFS/plioracle.mk::execution_failed::"
      echo "::ebm_pli_obj.mk::$PACK/RTSFS/plioracle.mk::execution_failed::" >> $DEBUGFILE
    exit 1
  fi
  FILES="$PACK/RTSFS/ebmplidate.o $PACK/RTSFS/el_date.o"
  FILES="$FILES $PACK/RTSFS/ebmusrexit.o"
  FILES="$FILES $PACK/RTSFS/fsusrexitORA.o"
  FILES="$FILES ./KXORAPLI.o"
fi

# BATCH VSAM and ORACLE
if [ "$oracle_flag" -eq 1 -a "$vsam_flag" -eq 1 ]
then
  rm -f LcisamN_kusr.a
  rm -f libbcisam.o
# B3044
  rm -f libbcisam.a
  cp $UNIKIX/lib/libbcisam.a LcisamN_kusr.a
  if [ $? -ne 0 ]
  then
      echo "::ebm_pli_obj.mk::./LcisamN_kusr.a::permission_denied::"
      echo "::ebm_pli_obj.mk::./LcisamN_kusr.a::permission_denied::" >> $DEBUGFILE
    exit 1
  fi
  chmod 666 LcisamN_kusr.a
  ar -d LcisamN_kusr.a kxusrexit.o
  ar -x LcisamN_kusr.a libbcisam.o
  chmod 666 ./libbcisam.o
# B3044
  ar -d LcisamN_kusr.a libbcisam.o
  $PACK/RTSFS/plioracle.mk $PACK/RTSFS
  if [ $? -ne 0 ]
  then
      echo "::ebm_pli_obj.mk::$PACK/RTSFS/plioracle.mk::execution_failed::"
      echo "::ebm_pli_obj.mk::$PACK/RTSFS/plioracle.mk::execution_failed::" >> $DEBUGFILE
    exit 1
  fi
  FILES="$PACK/RTSFS/ebmplidate.o $PACK/RTSFS/el_date.o"
# B3044
  FILES="$FILES $UNIKIX/src/trans/kxusrexit.o"
  FILES="$FILES ./KXORAPLI.o"
  FILES="$FILES ./libbcisam.o"
  FILES="$FILES ./LcisamN_kusr.a"
fi
echo $FILES
echo "+++ ebm objs::$FILES" >> $DEBUGFILE
echo "+++" >> $DEBUGFILE
exit 0
