       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCT04.
       REMARKS. THIS PROGRAM IS A GENERAL PURPOSE ERROR ROUTINE.
                CONTROL IS TRANSFERRED TO IT BY OTHER PROGRAMS IN THE
                ONLINE ACCOUNT FILE APPLICATION WHEN AN UNRECOVERABLE
                ERROR HAS OCCURRED.
                IT SENDS A MESSAGE TO INPUT TERMINAL DESCRIBING THE
                TYPE OF ERROR AND ASKS THE OPERATOR TO REPORT IT.
                THEN IT ABENDS, SO THAT ANY UPDATES MADE IN THE
                UNCOMPLETED TRANSACTION ARE BACKED OUT AND SO THAT AN
                ABEND DUMP IS AVAILABLE.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
           COPY ACCTSET.
       01  MISC.
           02  I                   PIC S9(4) COMP.
           02  IX                  PIC S9(4) COMP VALUE +31.
           02  DSN-MSG.
               04  FILLER          PIC X(13) VALUE 'THE FILE IS: '.
               04  DSN             PIC X(8).
               04  FILLER          PIC X VALUE '.'.
           02  HEX-LIST.
               04  HEX-0601        PIC S9(4) COMP VALUE +1537.
               04  HEX-0602        PIC S9(4) COMP VALUE +1538.
               04  HEX-0608        PIC S9(4) COMP VALUE +1544.
               04  HEX-060C        PIC S9(4) COMP VALUE +1548.
               04  HEX-060F        PIC S9(4) COMP VALUE +1551.
               04  HEX-0680        PIC S9(4) COMP VALUE +1664.
               04  HEX-0681        PIC S9(4) COMP VALUE +1665.
               04  HEX-0682        PIC S9(4) COMP VALUE +1666.
               04  HEX-0683        PIC S9(4) COMP VALUE +1667.
               04  HEX-06E1        PIC S9(4) COMP VALUE +1761.
               04  HEX-0A01        PIC S9(4) COMP VALUE +2561.
               04  HEX-0A02        PIC S9(4) COMP VALUE +2562.
               04  HEX-0A04        PIC S9(4) COMP VALUE +2564.
               04  HEX-0A08        PIC S9(4) COMP VALUE +2568.
               04  HEX-0A20        PIC S9(4) COMP VALUE +2592.
               04  HEX-0AE1        PIC S9(4) COMP VALUE +2785.
               04  HEX-0E01        PIC S9(4) COMP VALUE +3585.
               04  HEX-0EE1        PIC S9(4) COMP VALUE +3809.
               04  HEX-1001        PIC S9(4) COMP VALUE +4097.
               04  HEX-1004        PIC S9(4) COMP VALUE +4100.
               04  HEX-1011        PIC S9(4) COMP VALUE +4113.
               04  HEX-1012        PIC S9(4) COMP VALUE +4114.
               04  HEX-1014        PIC S9(4) COMP VALUE +4116.
               04  HEX-1081        PIC S9(4) COMP VALUE +4225.
               04  HEX-10E1        PIC S9(4) COMP VALUE +4321.
               04  HEX-10E9        PIC S9(4) COMP VALUE +4329.
               04  HEX-10FF        PIC S9(4) COMP VALUE +4351.
               04  HEX-1804        PIC S9(4) COMP VALUE +6148.
               04  HEX-1808        PIC S9(4) COMP VALUE +6152.
               04  HEX-18E1        PIC S9(4) COMP VALUE +6369.
               04  HEX-MISC        PIC S9(4) COMP VALUE +0001.
           02  HEX-CODE REDEFINES HEX-LIST PIC X(2) OCCURS 31.
           02  ERR-LIST.
               04  MSG-0601        PIC X(60) VALUE
                   'A PROGRAM OR FCT TABLE ERROR (INVALID FILE NAME).'.
               04  MSG-0602        PIC X(60) VALUE
                   'A PROGRAM OR FILE ERROR (VSAM ILLOGIC).'.
               04  MSG-0608        PIC X(60) VALUE
               'A PROGRAM OR FCT TABLE ERROR (INVALID FILE REQUEST).'.
               04  MSG-060C        PIC X(60) VALUE
                   'A FILE BEING CLOSED THAT MUST BE OPEN.'.
               04  MSG-060F        PIC X(60) VALUE
                   'A PROGRAM OR FILE ERROR (UNEXPECTED END-OF-FILE).'.
               04  MSG-0680        PIC X(60) VALUE
                   'A FILE INPUT/OUTPUT ERROR.'.
               04  MSG-0681        PIC X(60) VALUE
                   'A PROGRAM OR FILE ERROR (RECORD NOT FOUND).'.
               04  MSG-0682        PIC X(60) VALUE
                   'A PROGRAM OR FILE ERROR (DUPLICATE RECORD).'.
               04  MSG-0683        PIC X(60) VALUE
                   'INADEQUATE SPACE IN A FILE.'.
               04  MSG-06E1        PIC X(60) VALUE
               'A PROGRAM OR FILE ERROR (LENGTH ERROR, FILE CONTROL).'.
               04  MSG-0A01        PIC X(60) VALUE
                   'A PROGRAM OR TEMPORARY STORAGE ERROR (ITEM ERROR).'.
               04  MSG-0A02        PIC X(60) VALUE
               'A PROGRAM OR TEMPORARY STORAGE ERROR (UNKNOWN QUEUE).'.
               04  MSG-0A04        PIC X(60) VALUE
                   'AN INPUT/OUTPUT ERROR IN TEMPORARY STORAGE.'.
               04  MSG-0A08        PIC X(60) VALUE
                   'NO SPACE IN TEMPORARY STORAGE.'.
               04  MSG-0A20        PIC X(60) VALUE
                   'A PROGRAM OR SYSTEM ERROR (INVALID REQUEST IN TS).'.
               04  MSG-0AE1        PIC X(60) VALUE
              'A PROGRAM OR TEMPORARY STORAGE ERROR (TS LENGTH ERROR).'.
               04  MSG-0E01        PIC X(60) VALUE
               'A PROGRAM OR PPT TABLE ERROR (UNKNOWN PROGRAM NAME).'.
               04  MSG-0EE0        PIC X(60) VALUE
                   'A PROGRAM ERROR (INVALID PROGRAM REQUEST).'.
               04  MSG-1001        PIC X(60) VALUE
                   'A PROGRAM ERROR (END OF DATA, USING IC).'.
               04  MSG-1004        PIC X(60) VALUE
               'AN INPUT/OUTPUT ERROR IN TEMPORARY STORAGE (USING IC).'.
               04  MSG-1011        PIC X(60) VALUE
               'A PROGRAM OR PCT TABLE ERROR (TRANSID ERROR USING IC).'.
               04  MSG-1012        PIC X(60) VALUE
                   'A PROGRAM OR TCT TABLE ERROR (TERMIDERR USING IC).'.
               04  MSG-1014        PIC X(60) VALUE
                   'A PROGRAM OR SYSTEM ERROR (INVTSREQ USING IC).'.
               04  MSG-1081        PIC X(60) VALUE
                   'A PROGRAM OR SYSTEM ERROR (INVTSREQ USING IC).'.
               04  MSG-10E1        PIC X(60) VALUE
               'A PROGRAM OR TEMP STORAGE ERROR (NOT FOUND USING IC).'.
               04  MSG-10E9        PIC X(60) VALUE
                   'A PROGRAM ERROR (INVALID REQUEST USING IC).'.
               04  MSG-10FF        PIC X(60) VALUE
                   'A PROGRAM ERROR (ENVDEFERR USING IC).'.
               04  MSG-1804        PIC X(60) VALUE
                   'A PROGRAM ERROR (BMS MAPFAIL).'.
               04  MSG-1808        PIC X(60) VALUE
                   'A PROGRAM ERROR (INVALID MAP SIZE).'.
               04  MSG-18E1        PIC X(60) VALUE
                   'A PROGRAM ERROR (BMS LENGTH ERROR).'.
               04  MSG-MISC        PIC X(60) VALUE
                   'AN UNKNOWN TYPE OF ERROR.'.
           02  ERR-MSG REDEFINES ERR-LIST PIC X(60) OCCURS 31.
       01  DCOM-IRETCODE.
           02  DCOM-IRC            PIC 9(3) COMP.
           02  DCOM-IRC-R REDEFINES DCOM-IRC.
               03  DCOM-IRC-1      PIC X.
               03  DCOM-IRC-2      PIC X.
       01  DCOM-ERR-MSG.
		   02  FILLER              PIC X(9) VALUE 'DATACOM: '.
		   02  DERR-CMD            PIC X(5).
           02  FILLER              PIC X(4) VALUE ' ON '.
		   02  DERR-TABID          PIC X(3).
           02  FILLER              PIC X(1) VALUE ' '.
		   02  DERR-KEY            PIC X(5).
           02  FILLER              PIC X(10) VALUE ' RETURNED '.
		   02  DERR-RTCODE         PIC X(2).
           02  FILLER              PIC X(1) VALUE ' '.
		   02  DERR-IRETNUM        PIC 9(3).
       LINKAGE SECTION.
       01  DFHCOMMAREA.
           02  ERR-PGRMID          PIC X(8).
           02  ERR-CODE.
               04  ERR-FN          PIC X.
               04  ERR-RCODE       PIC X.
               04  DATACOM-ERR.
                   06  DERR-CMD        PIC X(5).
                   06  DERR-TABID      PIC X(3).
                   06  DERR-KEY        PIC X(5).
                   06  DERR-RTCODE     PIC X(2).
                   06  DERR-IRTCODE    PIC X(1).
       PROCEDURE DIVISION.
           MOVE LOW-VALUES TO ACCTERRO.
           MOVE EIBTRNID TO TRANEO.
           MOVE ERR-PGRMID TO PGMEO.
           IF DERR-RTCODE OF DATACOM-ERR NOT = SPACES
               MOVE CORRESPONDING DATACOM-ERR TO DCOM-ERR-MSG
               MOVE DERR-IRTCODE TO DCOM-IRC-2
               MOVE DCOM-IRC TO DERR-IRETNUM
               MOVE DCOM-ERR-MSG TO RSNEO
           ELSE
			   PERFORM CODE-LOOKUP THROUGH CODE-END
				   VARYING I FROM 1 BY 1 UNTIL I NOT < IX
			   MOVE ERR-MSG (IX) TO RSNEO
			   IF IX < 11
                   MOVE EIBDS TO DSN,
				   MOVE DSN-MSG TO FILEEO.
           EXEC CICS SEND MAP ('ACCTERR') MAPSET('ACCTSET') ERASE FREEKB
               END-EXEC.
           EXEC CICS ABEND ABCODE('EACC') END-EXEC.
       CODE-LOOKUP.
           IF HEX-CODE (I) = ERR-CODE MOVE I TO IX.
       CODE-END.  EXIT.
       DUMMY-END.
           GOBACK.
