       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCT03.
       REMARKS. THIS PROGRAM IS THE FIRST INVOKED BY TRANSACTIONS
                'ACC03', 'ACLG' AND 'AC05'. 'AC03' COMPLETES A REQUEST FOR
                PRINTING OF A CUSTOMER RECORD, WHICH WAS PROCESSED
                INITIALLY BY TRANSACTION 'AC01'.  'ACLG,' WHICH IS A
                USER REQUEST TO PRINT THE LOG, MERELY REQUESTS 'AC05'
                BE STARTED WHEN THE LOG PRINTER ('L86O') IS AVAILABLE.
                'AC05' TRANSFERS THE LOG DATA FROM TEMPORARY STORAGE TO
                THE PRINTER.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01  COMMAREA-FOR-ACCT04.
           02  ERR-PGM                 PIC X(8) VALUE 'ACCT03'.
           02  ERR-FN                  PIC X.
           02  ERR-RCODE               PIC X.
       01  TS-LNG                      PIC S9(4) COMP VALUE +751.
           COPY ACCTSET.
      *
       PROCEDURE DIVISION.
      *
      *    INITIALIZE.
       INIT.
           EXEC CICS HANDLE CONDITION ITEMERR(LOG-END)
               QIDERR(RTRN) ERROR(NO-GOOD) END-EXEC.
      *
      *    TEST FOR TRANSACTION TYPE.
           IF EIBTRNID = 'AC03' GO TO AC03.
           IF EIBTRNID = 'ACLG' GO TO ACLG, ELSE GO TO AC05.
      *
      *    PROCESS TRANSACTION 'AC03'.
       AC03.
           EXEC CICS RETRIEVE INTO(ACCTDTLI) LENGTH(TS-LNG) END-EXEC.
           EXEC CICS SEND MAP('ACCTDTL') MAPSET('ACCTSET') PRINT
                 L80 ERASE END-EXEC.
           GO TO RTRN.
      *
      *    PROCESS TRANSACTION 'ACLG'.
       ACLG.
           EXEC CICS START TRANSID('AC05') TERMID('CPRT') END-EXEC.
           MOVE LOW-VALUES TO ACCTMSGO.
           MOVE 'PRINTING OF LOG HAS BEEN SCHEDULED' TO MSGO.
           EXEC CICS SEND MAP('ACCTMSG') MAPSET('ACCTSET') ERASE
               FREEKB END-EXEC.
           GO TO RTRN.
      *
      *    PROCESS TRANSACTION 'AC05'.
       AC05.
           EXEC CICS READQ TS QUEUE('ACCTLOG') INTO (ACCTDTLI)
               LENGTH(TS-LNG) NEXT END-EXEC.
           EXEC CICS SEND MAP('ACCTDTL') MAPSET('ACCTSET') PRINT ERASE
               END-EXEC.
           GO TO AC05.
       LOG-END.
           EXEC CICS DELETEQ TS QUEUE('ACCTLOG') END-EXEC.
      *
      *    RETURN TO CICS.
       RTRN.
           EXEC CICS RETURN END-EXEC.
      *
      *    PROCESS UNRECOVERABLE ERRORS.
       NO-GOOD.
           MOVE EIBFN TO ERR-FN, MOVE EIBRCODE TO ERR-RCODE.
           EXEC CICS HANDLE CONDITION ERROR END-EXEC.
           EXEC CICS LINK PROGRAM ('ACCT04')
               COMMAREA(COMMAREA-FOR-ACCT04) LENGTH(10) END-EXEC.
           GOBACK.
