/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/


/* $Date:   19 Sep 2001 16:47:50  $ */
/* $Modtime:   18 Sep 2001 16:42:46  $ */

#ifndef	lint
#ifdef __STDC__
const
#endif
static char sccsid[] = "@(#) $Workfile:   kxsec_exits.c  $ $Revision:   1.0  $";
#endif

/*
 * $Log:   /unikix/source2/SunMTP7.2.0/unikixsrc/user/security/PVCS/kxsec_exits.c_v  $
 * 
 *    Rev 1.0   19 Sep 2001 16:47:50   unikix
 * Initial 7.2
 * 
 *    Rev 1.1   19 May 2000 08:40:28   daved
 * Remove references to UniKix.
 * 
 *    Rev 1.0   30 Jan 2000 11:48:00   unikix
 * Initial 7.0
 * 
 *    Rev 1.0   15 Mar 1999 20:00:08   unikix
 * Initial 6.0
 * 
 *    Rev 1.0   03 Sep 1998 15:20:04   steve
 * Initial revision.
 * 
 *    Rev 1.0   05/22/97 17:05:02   unikix
 * Initial 5.1
 * 
 *    Rev 1.2   07/31/96 13:29:18   unikix
 * Had to change name on non-ansi compiles on previous install
 * 
 *    Rev 1.1   07/31/96 11:52:26   unikix
 * Corrected the argument types in the prototype 
 * 
 *    Rev 1.0   07/26/96 14:06:54   steve
 * Initial revision.
 * 
 */

/*
kxsec_exits.c exported routines:
	kxsec_login
	kxsec_logout
        kxsec_rescheck
        kxsec_docache
        kxsec_dontcache
        kxsec_clearcache
	
kxsec_exits.c exported variables:
	
kxsec_exits.c imports:
	
*/

/* ------------- unix includes ------------- */

#include <sys/types.h>
#ifdef __STDC__
#include <unistd.h>
#endif
#ifdef __STDC__
#include <stdlib.h>
#endif

/* ------------ Product includes ------------ */

#include "security.h"

/* ------------- local defines ------------- */


/* --------- external definitions ---------- */


/* ---------- static definitions ----------- */


/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_login
%f
 *
 * DESCRIPTION:
 *      This function is called to log on the indicated userid.
 *
%d
 * INPUTS:
 *   username		- the name of the user being logged on
 *   username_length	- the number of characters in that user name
 *   password		- the password for that user
 *   password_length	- the number of characters in that password
 *   newpw		- the new password for that user, if supplied
 *   newpw_length	- the number of characters in that new password, zero 
 *				if not supplied
 *
 * OUTPUTS:
 *   Return Codes:
 *     TRUE		- User is successfully logged on and password updated if
 *				new password was supplied
 *     FALSE		- User was not successfully logged on; either userid or
 *				password was invalid
 *
 * CAVEATS:
 *
%F
 ************************************************************************/

boolean kxsec_login(
#ifdef __STDC__
		    char *username, int username_length, 
		    char *password, int password_length, 
		    char *newpw, int newpw_length)
#else
		    username, username_length, password, 
		    password_length, newpw, newpw_length)
char *username;
int username_length; 
char *password;
int password_length; 
char *newpw;
int newpw_length;
#endif
{
   return TRUE;
}

/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_logout
%f
 *
 * DESCRIPTION:
 *      This function is called to log off the indicated userid.
 *
%d
 * INPUTS:
 *   username		- the name of the user to be logged off
 *   username_length	- the number of characters in that user name
 *
 * OUTPUTS:
 *   Return Codes:
 *     TRUE		- User is successfully logged off
 *     FALSE		- User was not successfully logged off
 *
 * CAVEATS:
 *
%F
 ************************************************************************/

boolean kxsec_logout(
#ifdef __STDC__
		     char *username, int username_length)
#else
		     username, username_length)
char *username;
int username_length;
#endif
{
   return TRUE;
}

/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_docache
%f
 *
 * DESCRIPTION:
 *      This function is called to enable caching of results from asset
 *	checking done by this process. This eliminates multiple calls to
 *	an external security manager for the same asset / permission.
 *
%d
 * INPUTS:
 *   None
 *
 * OUTPUTS:
 *   None
 *
 * CAVEATS:
 *
%F
 ************************************************************************/
void kxsec_docache()
{
   return;
}

/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_clearcache
%f
 *
 * DESCRIPTION:
 *      This function is called to clear the cache of results from asset
 *	checking done by this process. This is done whenever the cached results
 *	must be refreshed from the external security manager (eg. end of tx).
 *
%d
 * INPUTS:
 *   None
 *
 * OUTPUTS:
 *   None
 *
 * CAVEATS:
 *
%F
 ************************************************************************/
void kxsec_clearcache()
{
   return;
}

/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_dontcache
%f
 *
 * DESCRIPTION:
 *      This function is called to disable caching of results from asset
 *	checking by this process. This call is only needed if caching is
 *	explicitly enabled by calling kxsec_docache(), since the default is
 *	that caching is disabled.
 *
%d
 * INPUTS:
 *   None
 *
 * OUTPUTS:
 *   None
 *
 * CAVEATS:
 *
%F
 ************************************************************************/
void kxsec_dontcache()
{
   return;
}

/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_rescheck
%f
 *
 * DESCRIPTION:
 *      This function is called to check for permission to an asset by
 *	the indicated userid.
 *
%d
 * INPUTS:
 *   asset_type		- the asset type, e.g. KIX_FILES
 *   asset_name		- the name of the asset, e.g. the dataset name
 *   asset_name_length	- the number of characters in that asset name
 *   username		- the name of the user for whom access is being checked
 *   username_length	- the number of characters in that user name
 *   access_type	- the permission being requested, e.g. WriteAccess
 *
 * OUTPUTS:
 *   Return Codes:
 *     TRUE		- User is granted the requested permission to the asset
 *     FALSE		- User is denied the requested permission to the asset
 *
 * CAVEATS:
 *
%F
 ************************************************************************/
boolean	kxsec_rescheck(
#ifdef __STDC__
		       enum asset_type asset_type_req,
		       char *asset_name, int asset_name_length, 
		       char *username, int username_length, 
		       enum access_type access_type_req)
#else
		       asset_type_req, asset_name, asset_name_length, 
		       username, username_length, access_type_req)
enum asset_type asset_type_req;
char	*asset_name;
int	asset_name_length;
char	*username;
int	username_length;
enum access_type access_type_req;
#endif

{
   return TRUE;
}

/*************************************************************************
%F
%d
%f
 * Name of Function: kxsec_mgrstatus
%f
 *
 * DESCRIPTION:
 *      This function is called to determine whether the external security 
 *	manager is operational or not
 *
%d
 * INPUTS:
 *   None
 *
 * OUTPUTS:
 *   Return Codes:
 *     TRUE		- External security manager is operational and ready
 *     FALSE		- External security manager is not currently operational
 *
 * CAVEATS:
 *
%F
 ************************************************************************/

boolean kxsec_mgrstatus()
{
   return FALSE;
}
