/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

/* $Date:   30 Oct 2001 12:38:04  $ */
/* $Modtime:   29 Oct 2001 17:30:02  $ */

#ifndef	lint
#ifdef __STDC__
const
#endif
static char sccsid[] = "@(#) $Workfile:   kxsyscnvtbl.c  $ $Revision:   1.3  $";
#endif

/*
 * $Log:   /ENG/cm134148/720.dilithium/unikixsrc/user/convert/PVCS/kxsyscnvtbl.c_v  $
 * 
 *    Rev 1.3   30 Oct 2001 12:38:04   cm134148
 * B008464
 * Moved Lowercase table back into kxcnvtbl.c (this table is user
 * editable). Also commented sixbit table with offsets.
 * 
 *    Rev 1.2   19 Oct 2001 14:59:06   cm134148
 * B008443
 * Moved Bit2ebcd and Lwr2upr tables from user module kxcnvtbl.c
 * 
 *    Rev 1.1   26 Sep 2001 09:32:12   calumm
 * B008438
 * Added API note changes
 * System_Ebcd2asc
 *     28 -> 1f (previously 88)
 *     29 -> 10 (previously 89)
 *     2c -> 1e (previously 8c)
 * System_Asc2ebcd
 *     10 -> 29 (previously 10)
 *     1e -> 2c (previously 1e)
 *     1f -> 28 (previously 1f)
 * 
 *    Rev 1.0   19 Sep 2001 16:47:36   unikix
 * Initial 7.2
 * 
 *    Rev 1.0   25 Apr 2001 13:56:16   calumm
 * D007705
 * System conversion tables. The user conversion tables are
 * in kxcnvtbl.c
 */

/*
kxsyscnvtbl.c exported routines
kxsyscnvtbl.c exported variables:
	Bit2ebcd
	System_Asc2ebcd
	System_Ebcd2asc
kxsyscnvtbl.c imports nothing
*/

/*
**   Sixbit to Ebcdic conversion table.
*/
unsigned char Bit2ebcd[64] = {
/* 00 */ 0x40, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
/* 08 */ 0xc8, 0xc9, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
/* 10 */ 0x50, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
/* 18 */ 0xd8, 0xd9, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
/* 20 */ 0x60, 0x61, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
/* 28 */ 0xe8, 0xe9, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
/* 30 */ 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
/* 38 */ 0xf8, 0xf9, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
};

/*
**   Ebcdic to Ascii system data conversion table.
**  
**   Created with the following command on AIX.
**
**   iconv -f IBM-1047 -t ISO8859-1 infile > outfile
**
**   infile contains 256 characters 0x00 to 0xFF.
**   You will need a hex editor (such as khexdit on Linux) to create
**   this file and to copy the hex values from outfile. 
**
**   Four of the characters are changed to match table C-1 in the
**   3270 Information Display System Data Stream Programmer's Reference
**   (GA23-0059-07).
**
**      4a -> 5b (previously a2)
**      4f -> 21 (previously 7c)
**      5a -> 5d (previously 21)
**      6a -> 7c (previously a6)
**
**   Three of the characters are changed to match the note on p87 below
**   Table 4. "Order codes occurring in 3270 data streams", in the
**   CICS Family Client/Server Programming Manual (SC33-1435-00).
**
**      28 -> 1f (previously 88)
**      29 -> 10 (previously 89)
**      2c -> 1e (previously 8c)
*/
unsigned char System_Ebcd2asc[256] = {
/* 00 */ 0x00, 0x01, 0x02, 0x03, 0x9c, 0x09, 0x86, 0x7f,
/* 08 */ 0x97, 0x8d, 0x8e, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
/* 10 */ 0x10, 0x11, 0x12, 0x13, 0x9d, 0x85, 0x08, 0x87,
/* 18 */ 0x18, 0x19, 0x92, 0x8f, 0x1c, 0x1d, 0x1e, 0x1f,
/* 20 */ 0x80, 0x81, 0x82, 0x83, 0x84, 0x0a, 0x17, 0x1b,
/* 28 */ 0x1f/*0x88*/, 0x10/*0x89*/, 0x8a, 0x8b, 0x1e/*0x8c*/, 0x05, 0x06, 0x07,
/* 30 */ 0x90, 0x91, 0x16, 0x93, 0x94, 0x95, 0x96, 0x04,
/* 38 */ 0x98, 0x99, 0x9a, 0x9b, 0x14, 0x15, 0x9e, 0x1a,
/* 40 */ 0x20, 0xa0, 0xe2, 0xe4, 0xe0, 0xe1, 0xe3, 0xe5,
/* 48 */ 0xe7, 0xf1, 0x5b/*0xa2*/, 0x2e, 0x3c, 0x28, 0x2b, 0x21/*0x7c*/,
/* 50 */ 0x26, 0xe9, 0xea, 0xeb, 0xe8, 0xed, 0xee, 0xef,
/* 58 */ 0xec, 0xdf, 0x5d/*0x21*/, 0x24, 0x2a, 0x29, 0x3b, 0x5e,
/* 60 */ 0x2d, 0x2f, 0xc2, 0xc4, 0xc0, 0xc1, 0xc3, 0xc5,
/* 68 */ 0xc7, 0xd1, 0x7c/*0xa6*/, 0x2c, 0x25, 0x5f, 0x3e, 0x3f,
/* 70 */ 0xf8, 0xc9, 0xca, 0xcb, 0xc8, 0xcd, 0xce, 0xcf,
/* 78 */ 0xcc, 0x60, 0x3a, 0x23, 0x40, 0x27, 0x3d, 0x22,
/* 80 */ 0xd8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
/* 88 */ 0x68, 0x69, 0xab, 0xbb, 0xf0, 0xfd, 0xfe, 0xb1,
/* 90 */ 0xb0, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
/* 98 */ 0x71, 0x72, 0xaa, 0xba, 0xe6, 0xb8, 0xc6, 0xa4,
/* A0 */ 0xb5, 0x7e, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
/* A8 */ 0x79, 0x7a, 0xa1, 0xbf, 0xd0, 0x5b, 0xde, 0xae,
/* B0 */ 0xac, 0xa3, 0xa5, 0xb7, 0xa9, 0xa7, 0xb6, 0xbc,
/* B8 */ 0xbd, 0xbe, 0xdd, 0xa8, 0xaf, 0x5d, 0xb4, 0xd7,
/* C0 */ 0x7b, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
/* C8 */ 0x48, 0x49, 0xad, 0xf4, 0xf6, 0xf2, 0xf3, 0xf5,
/* D0 */ 0x7d, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
/* D8 */ 0x51, 0x52, 0xb9, 0xfb, 0xfc, 0xf9, 0xfa, 0xff,
/* E0 */ 0x5c, 0xf7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
/* E8 */ 0x59, 0x5a, 0xb2, 0xd4, 0xd6, 0xd2, 0xd3, 0xd5,
/* F0 */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
/* F8 */ 0x38, 0x39, 0xb3, 0xdb, 0xdc, 0xd9, 0xda, 0x9f
};

/*
**   Ascii to Ebcdic system data conversion table.
**  
**   Created with the following command on AIX.
**
**   iconv -f ISO8859-1 -t IBM-1047 infile > outfile
**
**   infile contains 256 characters 0x00 to 0xFF.
**   You will need a hex editor (such as khexdit on Linux) to create
**   this file and to copy the hex values from outfile. 
**
**   Four of the characters are changed to match table C-1 in the
**   3270 Information Display System Data Stream Programmer's Reference
**   (GA23-0059-07).
**
**      21 -> 4f (previously 5a)
**      5b -> 4a (previously ad)
**      5d -> 5a (previously bd)
**      7c -> 6a (previously 4f)
**
**   Three of the characters are changed to match the note on p87 below
**   Table 4. "Order codes occurring in 3270 data streams", in the
**   CICS Family Client/Server Programming Manual (SC33-1435-00).
**
**      10 -> 29 (previously 10)
**      1e -> 2c (previously 1e)
**      1f -> 28 (previously 1f)
*/
unsigned char System_Asc2ebcd[256] = {
/* 00 */ 0x00, 0x01, 0x02, 0x03, 0x37, 0x2d, 0x2e, 0x2f,
/* 08 */ 0x16, 0x05, 0x25, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
/* 10 */ 0x29/*0x10*/, 0x11, 0x12, 0x13, 0x3c, 0x3d, 0x32, 0x26,
/* 18 */ 0x18, 0x19, 0x3f, 0x27, 0x1c, 0x1d, 0x2c/*0x1e*/, 0x28/*0x1f*/,
/* 20 */ 0x40, 0x4f/*0x5a*/, 0x7f, 0x7b, 0x5b, 0x6c, 0x50, 0x7d,
/* 28 */ 0x4d, 0x5d, 0x5c, 0x4e, 0x6b, 0x60, 0x4b, 0x61,
/* 30 */ 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
/* 38 */ 0xf8, 0xf9, 0x7a, 0x5e, 0x4c, 0x7e, 0x6e, 0x6f,
/* 40 */ 0x7c, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
/* 48 */ 0xc8, 0xc9, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6,
/* 50 */ 0xd7, 0xd8, 0xd9, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,
/* 58 */ 0xe7, 0xe8, 0xe9, 0x4a/*0xad*/, 0xe0, 0x5a/*0xbd*/, 0x5f, 0x6d,
/* 60 */ 0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
/* 68 */ 0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
/* 70 */ 0x97, 0x98, 0x99, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
/* 78 */ 0xa7, 0xa8, 0xa9, 0xc0, 0x6a/*0x4f*/, 0xd0, 0xa1, 0x07,
/* 80 */ 0x20, 0x21, 0x22, 0x23, 0x24, 0x15, 0x06, 0x17,
/* 88 */ 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x09, 0x0a, 0x1b,
/* 90 */ 0x30, 0x31, 0x1a, 0x33, 0x34, 0x35, 0x36, 0x08,
/* 98 */ 0x38, 0x39, 0x3a, 0x3b, 0x04, 0x14, 0x3e, 0xff,
/* A0 */ 0x41, 0xaa, 0x4a, 0xb1, 0x9f, 0xb2, 0x6a, 0xb5,
/* A8 */ 0xbb, 0xb4, 0x9a, 0x8a, 0xb0, 0xca, 0xaf, 0xbc,
/* B0 */ 0x90, 0x8f, 0xea, 0xfa, 0xbe, 0xa0, 0xb6, 0xb3,
/* B8 */ 0x9d, 0xda, 0x9b, 0x8b, 0xb7, 0xb8, 0xb9, 0xab,
/* C0 */ 0x64, 0x65, 0x62, 0x66, 0x63, 0x67, 0x9e, 0x68,
/* C8 */ 0x74, 0x71, 0x72, 0x73, 0x78, 0x75, 0x76, 0x77,
/* D0 */ 0xac, 0x69, 0xed, 0xee, 0xeb, 0xef, 0xec, 0xbf,
/* D8 */ 0x80, 0xfd, 0xfe, 0xfb, 0xfc, 0xba, 0xae, 0x59,
/* E0 */ 0x44, 0x45, 0x42, 0x46, 0x43, 0x47, 0x9c, 0x48,
/* E8 */ 0x54, 0x51, 0x52, 0x53, 0x58, 0x55, 0x56, 0x57,
/* F0 */ 0x8c, 0x49, 0xcd, 0xce, 0xcb, 0xcf, 0xcc, 0xe1,
/* F8 */ 0x70, 0xdd, 0xde, 0xdb, 0xdc, 0x8d, 0x8e, 0xdf
};
