/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

/* $Date:   12 Jan 2002 11:02:26  $ */
/* $Modtime:   04 Jan 2002 12:49:04  $ */

#ifndef	lint
#ifdef __STDC__
const
#endif
static char sccsid[] = "@(#) $Workfile:   kxcnvtbl.c  $ $Revision:   1.4  $";
#endif

/*
 * $Log:   /ENG/cm134148/720.dilithium/unikixsrc/user/convert/PVCS/kxcnvtbl.c_v  $
 * 
 *    Rev 1.4   12 Jan 2002 11:02:26   cm134148
 * B4619602
 * Reverted to original values in uppercase table in the range
 * E0 to FF. This exacerbates a problem with DBCS where we
 * perform uppercasing character by character and produce bad
 * DBCS characters.
 * 
 *    Rev 1.3   30 Oct 2001 12:37:16   cm134148
 * B008464
 * Moved Lowercase table back into this module from kxsyscnvtbl.c
 * also commented it with table offsets.
 * 
 *    Rev 1.2   19 Oct 2001 14:58:16   cm134148
 * B008443
 * Moved Bit2ebcd and Lwr2upr tables to system module kxsyscnvtbl.c
 * 
 *    Rev 1.1   26 Sep 2001 09:22:20   calumm
 * B008438
 * Changed entry 17 of User_Asc2ebcd from 0x20 to 0x26 (typo).
 * 
 *    Rev 1.0   19 Sep 2001 16:47:36   unikix
 * Initial 7.2
 * 
 *    Rev 1.3   08 May 2001 13:58:18   daved
 * Correct misspellings.
 * 
 *    Rev 1.2   25 Apr 2001 13:53:00   calumm
 * D007705
 * New conversion tables.
 * Based on Ascii ISO8859-1 and Ebcdic IBM-1047.
 * 
 *    Rev 1.1   01 Feb 2001 11:06:32   shwetank
 * B007444
 * Changed the conversion for '[' and ']' characters.
 * Need to use separate tables for user data and 3270 controls 
 * when converting datastream ascii <-> ebcdic
 * 
 *    Rev 1.0   30 Jan 2000 11:47:48   unikix
 * Initial 7.0
 * 
 *    Rev 1.3   14 Jan 2000 13:02:18   rick
 * B004159
 * Fix translation of !, |, and ] characters per Shwetank
 * 
 *    Rev 1.2   23 Jul 1999 12:31:40   kupendra
 * B003785
 * 
 *    Rev 1.1   21 Jul 1999 11:45:06   kupendra
 * B003785
 * Changed the values to take care of SA, SFE and MF orders clashing
 * with DBCS characters
 * 
 *    Rev 1.0   15 Mar 1999 19:59:54   unikix
 * Initial 6.0
 * 
 *    Rev 1.0   05/22/97 17:33:20   unikix
 * Initial 5.1
 * 
 *    Rev 1.0   04/10/96 14:13:30   unikix
 * Initial 5.0
 * 
 *    Rev 1.1   11/28/95 14:48:52   rick
 * B001165
 * Changed entries in the EBCDIC-to-ASCII and ASCII-to-EBCDIC so they are
 * reversible; i.e. if you convert one way and then back to the other, you 
 * wind up with the same original character.
 * 
 *    Rev 1.0   12/28/94 15:18:24   unikix
 * Initial revision (from V410ad)
 * 
 *    Rev 1.0.1.2   10/26/94 10:06:02   alan
 * Load conversion tables into memory
 * 
 *    Rev 1.0.1.1   10/14/94 09:35:26   alan
 * New data stream Ascii-Ebcdic conversion logic
 * Use dd conversion table
 * 
 *    Rev 1.0.1.0   11/18/93 16:34:22   unikix
 * UniKix 4.1 baseline (from V400m)
 * 
 *    Rev 1.0   06/10/93 11:58:42   unikix
 * UniKix 3.1.2 version
 */

/*
kxcnvtbl.c exported routines
kxcnvtbl.c exported variables:
	Lwr2upr
	User_Asc2ebcd
	User_Ebcd2asc
kxcnvtbl.c imports nothing
*/

/* 
**   Ascii lowercase to uppercase conversion table.
*/
unsigned char Lwr2upr[256] =  {
/* 00 */ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
/* 08 */ 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
/* 10 */ 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
/* 18 */ 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
/* 20 */ 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
/* 28 */ 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
/* 30 */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
/* 38 */ 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
/* 40 */ 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
/* 48 */ 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
/* 50 */ 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
/* 58 */ 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
/* 60 */ 0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
/* 68 */ 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
/* 70 */ 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
/* 78 */ 0x58, 0x59, 0x5a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
/* 80 */ 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
/* 88 */ 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
/* 90 */ 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
/* 98 */ 0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
/* A0 */ 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
/* A8 */ 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
/* B0 */ 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
/* B8 */ 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
/* C0 */ 0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
/* C8 */ 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
/* D0 */ 0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
/* D8 */ 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
/* E0 */ 0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
/* E8 */ 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
/* F0 */ 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
/* F8 */ 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};

/*
**   Ebcdic to Ascii user data conversion table.
**  
**   Created with the following command on AIX.
**
**   iconv -f IBM-1047 -t ISO8859-1 infile > outfile
**
**   infile contains 256 characters 0x00 to 0xFF.
**   You will need a hex editor (such as khexdit on Linux) to create
**   this file and to copy the hex values from outfile. 
**
**   This table should be the reverse of User_Asc2ebcd.
*/
unsigned char User_Ebcd2asc[256] = {
/* 00 */ 0x00, 0x01, 0x02, 0x03, 0x9c, 0x09, 0x86, 0x7f,
/* 08 */ 0x97, 0x8d, 0x8e, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
/* 10 */ 0x10, 0x11, 0x12, 0x13, 0x9d, 0x85, 0x08, 0x87,
/* 18 */ 0x18, 0x19, 0x92, 0x8f, 0x1c, 0x1d, 0x1e, 0x1f,
/* 20 */ 0x80, 0x81, 0x82, 0x83, 0x84, 0x0a, 0x17, 0x1b,
/* 28 */ 0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x05, 0x06, 0x07,
/* 30 */ 0x90, 0x91, 0x16, 0x93, 0x94, 0x95, 0x96, 0x04,
/* 38 */ 0x98, 0x99, 0x9a, 0x9b, 0x14, 0x15, 0x9e, 0x1a,
/* 40 */ 0x20, 0xa0, 0xe2, 0xe4, 0xe0, 0xe1, 0xe3, 0xe5,
/* 48 */ 0xe7, 0xf1, 0xa2, 0x2e, 0x3c, 0x28, 0x2b, 0x7c,
/* 50 */ 0x26, 0xe9, 0xea, 0xeb, 0xe8, 0xed, 0xee, 0xef,
/* 58 */ 0xec, 0xdf, 0x21, 0x24, 0x2a, 0x29, 0x3b, 0x5e,
/* 60 */ 0x2d, 0x2f, 0xc2, 0xc4, 0xc0, 0xc1, 0xc3, 0xc5,
/* 68 */ 0xc7, 0xd1, 0xa6, 0x2c, 0x25, 0x5f, 0x3e, 0x3f,
/* 70 */ 0xf8, 0xc9, 0xca, 0xcb, 0xc8, 0xcd, 0xce, 0xcf,
/* 78 */ 0xcc, 0x60, 0x3a, 0x23, 0x40, 0x27, 0x3d, 0x22,
/* 80 */ 0xd8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
/* 88 */ 0x68, 0x69, 0xab, 0xbb, 0xf0, 0xfd, 0xfe, 0xb1,
/* 90 */ 0xb0, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
/* 98 */ 0x71, 0x72, 0xaa, 0xba, 0xe6, 0xb8, 0xc6, 0xa4,
/* A0 */ 0xb5, 0x7e, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
/* A8 */ 0x79, 0x7a, 0xa1, 0xbf, 0xd0, 0x5b, 0xde, 0xae,
/* B0 */ 0xac, 0xa3, 0xa5, 0xb7, 0xa9, 0xa7, 0xb6, 0xbc,
/* B8 */ 0xbd, 0xbe, 0xdd, 0xa8, 0xaf, 0x5d, 0xb4, 0xd7,
/* C0 */ 0x7b, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
/* C8 */ 0x48, 0x49, 0xad, 0xf4, 0xf6, 0xf2, 0xf3, 0xf5,
/* D0 */ 0x7d, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50,
/* D8 */ 0x51, 0x52, 0xb9, 0xfb, 0xfc, 0xf9, 0xfa, 0xff,
/* E0 */ 0x5c, 0xf7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
/* E8 */ 0x59, 0x5a, 0xb2, 0xd4, 0xd6, 0xd2, 0xd3, 0xd5,
/* F0 */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
/* F8 */ 0x38, 0x39, 0xb3, 0xdb, 0xdc, 0xd9, 0xda, 0x9f
};

/*
**   Ascii to Ebcdic user data conversion table.
**  
**   Created with the following command on AIX.
**
**   iconv -f ISO8859-1 -t IBM-1047 infile > outfile
**
**   infile contains 256 characters 0x00 to 0xFF.
**   You will need a hex editor (such as khexdit on Linux) to create
**   this file and to copy the hex values from outfile. 
**
**   This table should be the reverse of User_Ebcd2asc.
*/
unsigned char User_Asc2ebcd[256] = {
/* 00 */ 0x00, 0x01, 0x02, 0x03, 0x37, 0x2d, 0x2e, 0x2f,
/* 08 */ 0x16, 0x05, 0x25, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
/* 10 */ 0x10, 0x11, 0x12, 0x13, 0x3c, 0x3d, 0x32, 0x26,
/* 18 */ 0x18, 0x19, 0x3f, 0x27, 0x1c, 0x1d, 0x1e, 0x1f,
/* 20 */ 0x40, 0x5a, 0x7f, 0x7b, 0x5b, 0x6c, 0x50, 0x7d,
/* 28 */ 0x4d, 0x5d, 0x5c, 0x4e, 0x6b, 0x60, 0x4b, 0x61,
/* 30 */ 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
/* 38 */ 0xf8, 0xf9, 0x7a, 0x5e, 0x4c, 0x7e, 0x6e, 0x6f,
/* 40 */ 0x7c, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
/* 48 */ 0xc8, 0xc9, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6,
/* 50 */ 0xd7, 0xd8, 0xd9, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6,
/* 58 */ 0xe7, 0xe8, 0xe9, 0xad, 0xe0, 0xbd, 0x5f, 0x6d,
/* 60 */ 0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
/* 68 */ 0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
/* 70 */ 0x97, 0x98, 0x99, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6,
/* 78 */ 0xa7, 0xa8, 0xa9, 0xc0, 0x4f, 0xd0, 0xa1, 0x07,
/* 80 */ 0x20, 0x21, 0x22, 0x23, 0x24, 0x15, 0x06, 0x17,
/* 88 */ 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x09, 0x0a, 0x1b,
/* 90 */ 0x30, 0x31, 0x1a, 0x33, 0x34, 0x35, 0x36, 0x08,
/* 98 */ 0x38, 0x39, 0x3a, 0x3b, 0x04, 0x14, 0x3e, 0xff,
/* A0 */ 0x41, 0xaa, 0x4a, 0xb1, 0x9f, 0xb2, 0x6a, 0xb5,
/* A8 */ 0xbb, 0xb4, 0x9a, 0x8a, 0xb0, 0xca, 0xaf, 0xbc,
/* B0 */ 0x90, 0x8f, 0xea, 0xfa, 0xbe, 0xa0, 0xb6, 0xb3,
/* B8 */ 0x9d, 0xda, 0x9b, 0x8b, 0xb7, 0xb8, 0xb9, 0xab,
/* C0 */ 0x64, 0x65, 0x62, 0x66, 0x63, 0x67, 0x9e, 0x68,
/* C8 */ 0x74, 0x71, 0x72, 0x73, 0x78, 0x75, 0x76, 0x77,
/* D0 */ 0xac, 0x69, 0xed, 0xee, 0xeb, 0xef, 0xec, 0xbf,
/* D8 */ 0x80, 0xfd, 0xfe, 0xfb, 0xfc, 0xba, 0xae, 0x59,
/* E0 */ 0x44, 0x45, 0x42, 0x46, 0x43, 0x47, 0x9c, 0x48,
/* E8 */ 0x54, 0x51, 0x52, 0x53, 0x58, 0x55, 0x56, 0x57,
/* F0 */ 0x8c, 0x49, 0xcd, 0xce, 0xcb, 0xcf, 0xcc, 0xe1,
/* F8 */ 0x70, 0xdd, 0xde, 0xdb, 0xdc, 0x8d, 0x8e, 0xdf
};

#ifdef  TESTMAIN

/*
** Check if User_Ebcd2asc[] and User_Asc2ebcd[] are inverses.
**
** Use this check after changing either table.
** 
**      cc -DTESTMAIN kxcnvtbl.c
**
** run a.out and get the following:
** 
**      cntok: 256
**      User_Asc2ebcd[] is inverse of User_Ebcd2asc[]
*/

#include <stdio.h>

main()
{
    int a2e[256];
    int i, j, cntok;

    for (i=0; i < 256; i++) {
	a2e[i] = -1;
    }

    for (i=0; i < 256; i++) {
	j = User_Ebcd2asc[i] & 0xff;
	a2e[j] = i;
    }

    cntok = 0;

    for (i=0; i < 256; i++) {
	if ((0xff & User_Asc2ebcd[i]) != a2e[i]) {
	    printf("ERR: i: %x  User_Asc2ebcd[i]: %x  a2e[i]: %x\n",
		    i, User_Asc2ebcd[i], a2e[i] );
	} else {
     	    cntok++;
	}
    }

    printf("cntok: %d\n", cntok);

    if (cntok == 256) {
 	printf("User_Asc2ebcd[] is inverse of User_Ebcd2asc[]\n");
    }

    return 0;
}
#endif  /* TESTMAIN */
