/*
 * Decompiled with CFR 0.152.
 */
package com.peerlogic.trans.util;

import com.peerlogic.trans.util.Constants;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Vector;

public class ErrorMessages
implements Constants {
    private static ErrorMessages singleton = new ErrorMessages();
    private Vector messages = new Vector();

    public static ErrorMessages getInstance() {
        return singleton;
    }

    private ErrorMessages() {
        try {
            this.readFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("*** ErrorMessages[constructor] Failed to read UNIKIXERR.err file");
            System.exit(1);
        }
    }

    private void readFile() throws Exception {
        String string;
        String string2 = System.getProperty("UNIKIX");
        if (string2 == null) {
            throw new Exception("ErrorMessages[readFile] UNIKIX property not set.");
        }
        String string3 = string2 + "/lib/UNIKIXERR.err";
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string3));
        int n = 0;
        Object e = null;
        while ((string = lineNumberReader.readLine()) != null) {
            try {
                ++n;
                int n2 = Integer.parseInt(string.substring(0, 4));
                while (n2 > this.messages.size()) {
                    this.messages.add(e);
                }
                this.messages.add(string);
            }
            catch (Exception exception) {
                System.out.println("ErrorMessages[readFile] Parse error line " + n + ":" + string);
            }
        }
    }

    public String getMessage(int n) {
        String string = null;
        try {
            string = (String)this.messages.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (string == null) {
            string = "Message " + n + " not found";
        }
        return string;
    }

    public int size() {
        return this.messages.size();
    }
}

