/*
 * Decompiled with CFR 0.152.
 */
package com.peerlogic.trans.ipc;

import com.peerlogic.trans.ipc.MessageQueue;
import com.peerlogic.trans.util.Constants;
import com.peerlogic.trans.util.Permission;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageQueueFactory
implements Constants {
    private static Hashtable openQueues = new Hashtable();

    private MessageQueueFactory() {
    }

    public static MessageQueue getQueue(int n) throws Exception {
        return MessageQueueFactory.getQueue(n, new Permission(2, 0, 0));
    }

    public static synchronized MessageQueue getQueue(int n, Permission permission) throws Exception {
        Integer n2 = MessageQueueFactory.getKey(n, permission);
        MessageQueue messageQueue = (MessageQueue)openQueues.get(n2);
        if (messageQueue != null) {
            return messageQueue;
        }
        return MessageQueueFactory.createQueue(n, permission);
    }

    private static MessageQueue createQueue(int n, Permission permission) throws Exception {
        MessageQueue messageQueue = new MessageQueue();
        if (!MessageQueueFactory.openQueue(messageQueue, n, permission)) {
            return null;
        }
        Integer n2 = MessageQueueFactory.getKey(n, permission);
        openQueues.put(n2, messageQueue);
        return messageQueue;
    }

    private static Integer getKey(int n, Permission permission) {
        return new Integer(n * 1000 + permission.getUser() * 100 + permission.getGroup() * 10 + permission.getOther());
    }

    private static boolean openQueue(MessageQueue messageQueue, int n, Permission permission) throws Exception {
        String string = System.getProperty("KIXSYS");
        if (string == null) {
            throw new Exception("MessageQueueFactory[openQueue] KIXSYS property not set.");
        }
        return messageQueue.open(string, n, permission);
    }

    public static void displayOpenQueues() {
        Enumeration enumeration = openQueues.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }
}

