/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.DataHolder;
import com.ibm.cics.server.EndOfChainIndicatorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.NotAllocatedException;
import com.ibm.cics.server.TCTUAHolder;
import com.ibm.cics.server.Terminal;
import com.ibm.cics.server.TerminalException;
import com.ibm.cics.server.TerminalSendBits;
import com.peerlogic.trans.jcics.ExceptionHelper;
import com.peerlogic.trans.jcics.NotImplementedException;
import java.util.BitSet;

public class TerminalPrincipalFacility
extends Terminal
implements TerminalSendBits {
    private byte[] nextCommarea = null;
    private byte[] nextTransid = null;
    private static final byte INVALID_WCC = 0;
    private static final int B_FRSET = 1;
    private static final int B_FREEKB = 2;
    private static final int B_ALARM = 4;
    private static final int B_PRINT = 8;
    protected static final byte[] bin2ebcTbl = new byte[]{64, -63, -62, -61, -60, -59, -58, -57, -56, -55, 74, 75, 76, 77, 78, 79, 80, -47, -46, -45, -44, -43, -42, -41, -40, -39, 90, 91, 92, 93, 94, 95, 96, 97, -30, -29, -28, -27, -26, -25, -24, -23, 106, 107, 108, 109, 110, 111, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 123, 124, 125, 126, 127};

    TerminalPrincipalFacility(String string) {
        super(string);
    }

    public void clear() throws InvalidRequestException {
        this.erase();
    }

    public void erase() throws InvalidRequestException {
        this.performSendControl(-1, false, true, false, false, false);
    }

    public void sendControl(Cursor cursor) throws InvalidRequestException {
        this.performSendControl(cursor.toBinary(), false, false, false, false, false);
    }

    public void sendControl(BitSet bitSet) throws InvalidRequestException {
        boolean bl = bitSet.get(0);
        boolean bl2 = bitSet.get(1);
        boolean bl3 = bitSet.get(2);
        boolean bl4 = bitSet.get(4);
        boolean bl5 = bitSet.get(3);
        this.performSendControl(-1, bl, bl2, bl3, bl4, bl5);
    }

    public void sendControl(Cursor cursor, BitSet bitSet) throws InvalidRequestException {
        boolean bl = bitSet.get(0);
        boolean bl2 = bitSet.get(1);
        boolean bl3 = bitSet.get(2);
        boolean bl4 = bitSet.get(4);
        boolean bl5 = bitSet.get(3);
        this.performSendControl(cursor.toBinary(), bl, bl2, bl3, bl4, bl5);
    }

    public void send(byte[] byArray) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        this.performSend(byArray, (byte)0, false, false);
    }

    public void send(byte[] byArray, BitSet bitSet) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        this.performSend(byArray, TerminalPrincipalFacility.wcc(bitSet), bitSet.get(5), bitSet.get(1));
    }

    private static byte wcc(BitSet bitSet) {
        int n = 0;
        if (bitSet.get(4)) {
            n |= 1;
        }
        if (bitSet.get(2)) {
            n |= 2;
        }
        if (bitSet.get(0)) {
            n |= 4;
        }
        if (bitSet.get(3)) {
            n |= 8;
        }
        return bin2ebcTbl[n];
    }

    public void sendText(byte[] byArray) throws InvalidRequestException, LengthErrorException {
        this.performSendText(byArray, -1, false, false, false, false, false, false);
    }

    public void sendText(byte[] byArray, Cursor cursor) throws InvalidRequestException, LengthErrorException {
        this.performSendText(byArray, cursor.toBinary(), false, false, false, false, false, false);
    }

    public void sendText(byte[] byArray, Cursor cursor, BitSet bitSet) throws InvalidRequestException, LengthErrorException {
        boolean bl = bitSet.get(0);
        boolean bl2 = bitSet.get(1);
        boolean bl3 = bitSet.get(2);
        boolean bl4 = bitSet.get(3);
        boolean bl5 = bitSet.get(4);
        boolean bl6 = bitSet.get(5);
        this.performSendText(byArray, cursor.toBinary(), bl, bl2, bl3, bl4, bl5, bl6);
    }

    public void sendText(byte[] byArray, BitSet bitSet) throws InvalidRequestException, LengthErrorException {
        boolean bl = bitSet.get(0);
        boolean bl2 = bitSet.get(1);
        boolean bl3 = bitSet.get(2);
        boolean bl4 = bitSet.get(3);
        boolean bl5 = bitSet.get(4);
        boolean bl6 = bitSet.get(5);
        this.performSendText(byArray, -1, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public void converse(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        throw new NotImplementedException();
    }

    public void converseASIS(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        throw new NotImplementedException();
    }

    public void getTCTUA(TCTUAHolder tCTUAHolder) {
        if (tCTUAHolder == null) {
            throw new NullPointerException("holder");
        }
        byte[] byArray = this.getTCTUAImpl();
        tCTUAHolder.value = byArray;
    }

    public byte[] getTERMCODE() {
        throw new NotImplementedException();
    }

    public void setNextCOMMAREA(byte[] byArray) {
        this.nextCommarea = byArray;
    }

    public void setNextTransaction(String string) {
        if (string.length() > 4) {
            throw new IllegalArgumentException("nextTransaction.length() > 4");
        }
        this.nextTransid = string.getBytes();
        if (this.nextTransid.length != 4) {
            byte[] byArray = new byte[4];
            int n = 0;
            while (n < this.nextTransid.length) {
                byArray[n] = this.nextTransid[n];
                ++n;
            }
            int n2 = this.nextTransid.length;
            while (n2 < 4) {
                byArray[n2] = 32;
                ++n2;
            }
            this.nextTransid = byArray;
        }
    }

    public void setTCTUA(byte[] byArray) throws InvalidRequestException {
        if (byArray == null) {
            throw new NullPointerException("data");
        }
        this.setTCTUAImpl(byArray);
    }

    public void waitTerminal() {
        throw new NotImplementedException();
    }

    public void receive(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        dataHolder.value = this.performReceive(false, false);
    }

    public void receiveASIS(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        dataHolder.value = this.performReceive(true, false);
    }

    public void receiveBuffer(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        dataHolder.value = this.performReceive(false, true);
    }

    public void receiveBufferASIS(DataHolder dataHolder) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException {
        dataHolder.value = this.performReceive(true, true);
    }

    byte[] getNextTransaction() {
        return this.nextTransid;
    }

    byte[] getNextCOMMAREA() {
        return this.nextCommarea;
    }

    static void throwInvalidRequestException() throws InvalidRequestException {
        byte[] byArray = new byte[6];
        byte[] byArray2 = new byte[]{2, 2};
        byArray[0] = -32;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        throw new InvalidRequestException(new ExceptionHelper(0, byArray, byArray2));
    }

    private native void performSendControl(int var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6) throws InvalidRequestException;

    private native void performSend(byte[] var1, byte var2, boolean var3, boolean var4) throws InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException;

    private native void performSendText(byte[] var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8) throws InvalidRequestException, LengthErrorException;

    private native byte[] performReceive(boolean var1, boolean var2) throws EndOfChainIndicatorException, InvalidRequestException, LengthErrorException, NotAllocatedException, TerminalException;

    private native byte[] getTCTUAImpl();

    private native void setTCTUAImpl(byte[] var1);

    static {
        System.loadLibrary("kixjs2");
    }
}

