/*
 * Copyright 1996-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_CPUPART_H
#define	_SYS_CPUPART_H

#pragma ident	"@(#)cpupart.h	1.10	02/02/24 SMI"

#include <sys/types.h>
#include <sys/processor.h>
#include <sys/cpuvar.h>
#include <sys/disp.h>
#include <sys/pset.h>
#include <sys/lgrp.h>

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef _KERNEL

typedef int	cpupartid_t;

/*
 * Special partition id.
 */
#define	CP_DEFAULT	0

/*
 * Flags for cpupart_list()
 */
#define	CP_ALL		0		/* return all cpu partitions */
#define	CP_NONEMPTY	1		/* return only non-empty ones */

typedef struct cpupart {
	disp_t		cp_kp_queue;	/* partition-wide kpreempt queue */
	cpupartid_t	cp_id;		/* partition ID */
	int		cp_ncpus;	/* number of online processors */
	struct cpupart	*cp_next;	/* next partition in list */
	struct cpupart	*cp_prev;	/* previous partition in list */
	struct cpu	*cp_cpulist;	/* processor list */
	struct kstat	*cp_kstat;	/* per-partition statistics */

	/*
	 * cp_nrunnable and cp_nrunning are used to calculate load average.
	 */
	uint_t		cp_nrunnable;	/* current # of runnable threads */
	uint_t		cp_nrunning;	/* current # of running threads */

	/*
	 * cp_updates, cp_nrunnable_cum, cp_nwaiting_cum, and cp_hp_avenrun
	 * are used to generate kstat information on an as-needed basis.
	 */
	uint64_t	cp_updates;	/* number of statistics updates */
	uint64_t	cp_nrunnable_cum; /* cum. # of runnable threads */
	uint64_t	cp_nwaiting_cum;  /* cum. # of waiting threads */

	klgrpset_t	cp_lgrpset;	/* set of lgroups on which this */
					/*    partition has cpus */
	lpl_t		cp_lgrploads[NLGRPS_MAX];
					/* table of load averages for this  */
					/*    partition, indexed by lgrp ID */
	int		cp_hp_avenrun[3]; /* high-precision load average */
	uint_t		cp_attr;	/* bitmask of attributes */
} cpupart_t;

typedef struct cpupart_kstat {
	kstat_named_t	cpk_updates;		/* number of updates */
	kstat_named_t	cpk_runnable;		/* cum # of runnable threads */
	kstat_named_t	cpk_waiting;		/* cum # waiting for I/O */
	kstat_named_t	cpk_ncpus;		/* current # of CPUs */
	kstat_named_t	cpk_avenrun_1min;	/* 1-minute load average */
	kstat_named_t	cpk_avenrun_5min;	/* 5-minute load average */
	kstat_named_t	cpk_avenrun_15min;	/* 15-minute load average */
} cpupart_kstat_t;

extern cpupart_t	cp_default;
extern cpupart_t	*cp_list_head;
extern uint_t		cp_numparts_nonempty;

extern void	cpupart_initialize_default();

extern int	cpupart_create(psetid_t *);
extern int	cpupart_destroy(psetid_t);
extern psetid_t	cpupart_query_cpu(cpu_t *);
extern int	cpupart_attach_cpu(psetid_t, cpu_t *);
extern int	cpupart_get_cpus(psetid_t *, processorid_t *, uint_t *);
extern int	cpupart_bind_thread(kthread_id_t, psetid_t, int, void *);
extern void	cpupart_kpqalloc(pri_t);
extern int	cpupart_get_loadavg(psetid_t, int *, int);
extern uint_t	cpupart_list(psetid_t *, uint_t, int);
extern int	cpupart_setattr(psetid_t, uint_t);
extern int	cpupart_getattr(psetid_t, uint_t *);

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_CPUPART_H */
